/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mue.Gun;
import mue.Position;
import mue.RobotData;
import mue.StatisticWaveListener;
import mue.Util;
import robocode.AdvancedRobot;
import robocode.Condition;

final class StatisticWave
extends Condition {
    private Map angleMap;
    private RobotData target;
    private AdvancedRobot robot;
    private double[] sinAngles;
    private double[] cosAngles;
    private Gun[] guns;
    private double originX;
    private double originY;
    private double power;
    private int time;
    private int distance;
    private StatisticWaveListener listener;
    private int lastTick;

    public StatisticWave(StatisticWaveListener statisticWaveListener, AdvancedRobot advancedRobot, RobotData robotData, double d) {
        super("StatisticWave");
        this.robot = advancedRobot;
        this.target = robotData;
        this.angleMap = new HashMap(20);
        this.listener = statisticWaveListener;
        this.power = d;
        Position position = this.target.guessPosition();
        this.distance = (int)Math.round(Util.distance(this.robot.getX(), this.robot.getY(), position.getX(), position.getY()));
        this.sinAngles = null;
        this.cosAngles = null;
        this.guns = null;
    }

    public void fire() {
        if (this.angleMap.isEmpty()) {
            return;
        }
        this.sinAngles = new double[this.angleMap.size()];
        this.cosAngles = new double[this.angleMap.size()];
        this.guns = new Gun[this.angleMap.size()];
        Iterator iterator = this.angleMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.guns[n] = (Gun)iterator.next();
            double d = Math.toRadians((Double)this.angleMap.get(this.guns[n]));
            this.sinAngles[n] = Math.sin(d);
            this.cosAngles[n] = Math.cos(d);
            ++n;
        }
        this.originX = this.robot.getX();
        this.originY = this.robot.getY();
        this.lastTick = this.time = (int)this.robot.getTime();
        this.robot.addCustomEvent((Condition)this);
    }

    public void addGun(Gun gun, double d) {
        this.angleMap.put(gun, new Double(d));
    }

    public RobotData getTarget() {
        return this.target;
    }

    public double getPower() {
        return this.power;
    }

    public boolean test() {
        if (!this.target.isAlive() && (long)this.lastTick == this.target.getTime() + 1L) {
            this.robot.removeCustomEvent((Condition)this);
            return false;
        }
        int n = (int)this.target.getTime();
        if (!this.target.isAlive()) {
            ++n;
        }
        double d = (double)(n - this.time) * (20.0 - 3.0 * this.power);
        double d2 = (double)(this.lastTick - this.time) * (20.0 - 3.0 * this.power);
        double d3 = Util.distance(this.originX, this.originY, this.target.getX(), this.target.getY());
        this.lastTick = n;
        if (d < d3 - 26.0) {
            return false;
        }
        if (d2 > d3 + 26.0) {
            this.robot.removeCustomEvent((Condition)this);
            int n2 = 0;
            while (n2 < this.guns.length) {
                if (this.guns[n2] != null) {
                    this.listener.addMiss(this.target.getName(), this.guns[n2], this.distance, this.power);
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.guns.length) {
                if (this.guns[n4] != null) {
                    double d4 = this.originX + this.sinAngles[n4] * d2;
                    double d5 = this.originY + this.cosAngles[n4] * d2;
                    double d6 = this.originX + this.sinAngles[n4] * d;
                    double d7 = this.originY + this.cosAngles[n4] * d;
                    if (this.target.intersects(d4, d5, d6, d7)) {
                        this.listener.addHit(this.target.getName(), this.guns[n4], this.distance, this.power);
                        this.guns[n4] = null;
                    } else {
                        ++n3;
                    }
                }
                ++n4;
            }
            if (n3 == 0) {
                this.robot.removeCustomEvent((Condition)this);
            }
        }
        return false;
    }
}

