/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.move;

import vuen.fractal.FractalE;
import vuen.fractal.data.Memory;
import vuen.fractal.data.Packet;
import vuen.fractal.move.Roller;
import vuen.fractal.util.BotMath;

public class Angler {
    FractalE robot;
    Memory memory;
    Roller roller;

    public Angler(FractalE robot, Memory memory, Roller roller) {
        this.robot = robot;
        this.memory = memory;
        this.roller = roller;
    }

    public void init() {
    }

    public void go() {
        int i;
        Packet self = this.memory.getPacket(0);
        Packet enemy = this.memory.getPacket(this.memory.getTarget());
        if (enemy == null || self == null) {
            return;
        }
        double angle = BotMath.normalRelativeAngle(BotMath.anglePoints(enemy.x, enemy.y, self.x, self.y) - self.heading + 90.0);
        double heading = self.heading + 90.0 * (BotMath.sign(this.roller.ahead) - 1.0);
        double[] anglewall = new double[4];
        double[] distance = new double[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            distance[i2] = BotMath.distanceNormalWall(self.x, self.y, (double)i2 * 90.0);
        }
        double approach = BotMath.cap(300.0 - BotMath.distancePoints(enemy.x, enemy.y, self.x, self.y) * 2.0 / 300.0, -1.0, 1.0) * 60.0;
        double flee = BotMath.sign(this.roller.ahead) * approach * BotMath.bound((Math.min(Math.min(distance[0], distance[1]), Math.min(distance[2], distance[3])) - 100.0) / 300.0);
        angle += flee;
        for (i = 0; i < 4; ++i) {
            anglewall[i] = BotMath.normalRelativeAngle((double)(i - 1) * 90.0 - self.heading);
        }
        for (i = 0; i < 4; ++i) {
        }
        for (i = 0; i < 4; ++i) {
            if (!(anglewall[i] * BotMath.sign(this.roller.ahead) < 0.0) || !(anglewall[i] * BotMath.sign(this.roller.ahead) > -60.0)) continue;
            angle += (anglewall[i] - angle) * BotMath.bound((110.0 - distance[i]) / 100.0);
        }
        this.robot.setTurnRight(angle);
    }
}

