/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import robocode.RobocodeFileOutputStream;
import vuen.fractal.FractalE;

public class Misc {
    private Misc() {
    }

    public static void getGL(FractalE robot) {
        BufferedReader r;
        try {
            r = new BufferedReader(new FileReader(robot.getDataFile("gl.txt")));
        }
        catch (IOException e) {
            robot.println("IOException reading 'gl.txt': " + e.getMessage());
            robot.println("Unable to read 'gl.txt'. Creating file...");
            Misc.createGLtxt(robot);
            return;
        }
        try {
            FractalE.gl = Misc.readBool(r);
            if (!FractalE.gl) {
                return;
            }
            robot.println("GL drawing activated.");
            FractalE.glhud = Misc.readBool(r);
            FractalE.glgraph = Misc.readBool(r);
            FractalE.glwave = Misc.readBool(r);
        }
        catch (IOException e) {
            robot.println("IOException reading 'gl.txt': " + e.getMessage());
            robot.println("Unable to read 'gl.txt'. Creating file...");
            Misc.createGLtxt(robot);
        }
    }

    public static boolean readBool(BufferedReader r) throws IOException {
        String str;
        while ((str = r.readLine()).length() <= 1 || str.substring(0, 2).equals("//")) {
        }
        return Boolean.valueOf(str);
    }

    public static void createGLtxt(FractalE robot) {
        try {
            PrintStream w = new PrintStream((OutputStream)new RobocodeFileOutputStream(robot.getDataFile("gl.txt")));
            w.println("//This file contains the information for");
            w.println("// Fractal's GL drawing functions. This file");
            w.println("// can be safely deleted.");
            w.println("");
            w.println("// This activates GL drawing; you can set the");
            w.println("// below value to true if you have RobocodeGL.");
            w.println("false");
            w.println("");
            w.println("//This activates the hud.");
            w.println("true");
            w.println("");
            w.println("//This activates the onscreen movement curve graphing.");
            w.println("true");
            w.println("");
            w.println("//This activates wave drawing.");
            w.println("false");
            w.println("");
            if (w.checkError()) {
                robot.println("Error writing 'gl.txt'.");
            }
            w.close();
        }
        catch (IOException e) {
            robot.println("IOException writing 'gl.txt': " + e.getMessage());
            robot.println("Unable to write 'gl.txt'.");
        }
    }

    public static String getNameOnly(String name) {
        int i;
        int start = 0;
        int end = 0;
        for (i = start; i < name.length(); ++i) {
            if (name.substring(i, i + 1).equals(" ")) {
                end = i;
                i = name.length();
            }
            if (i != name.length() - 1) continue;
            end = i + 1;
        }
        for (i = end - 1; i >= 0; --i) {
            if (name.substring(i, i + 1).equals(".")) {
                start = i + 1;
                i = -1;
            }
            if (i != 0) continue;
            start = 0;
        }
        return name.substring(start, end);
    }
}

