/*
 * Decompiled with CFR 0.152.
 */
package kcn.unnamed;

import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import kcn.unnamed.movsim.MovSim;
import kcn.unnamed.movsim.MovSimStat;
import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Unnamed
extends AdvancedRobot {
    private static final int MAX_VELOCITY = 8;
    private static final int BUCKET_SIZE = 37;
    private static final int SEGMENTS_DIST = 8;
    private static final int SEGMENTS_BP = 3;
    private static final int SEGMENTS_WALL = 3;
    private static final int SEGMENTS_STOP = 5;
    private static final int SEGMENTS_VEL = 3;
    private static final int SEGMENTS_ACCEL = 3;
    private static final float[][][][][][][] stats;
    private static final int[][][][][][] highestIndex;
    private static final int[][][][][][] totals;
    private static final TreeMap distances;
    private static final TreeMap wallDistances;
    private static final TreeMap stopTimes;
    private static final TreeMap velocities;
    private static final double[] distanceLimits;
    private static final double[] wallLimits;
    private static final double[] stopLimits;
    private static final double[] velocityLimits;
    private static int totalValues;
    private static double[] goodCTT;
    private static double[][][] currentChanceToTurn;
    private static int[][][] linearHitBin;
    private static int[][][] zeroHitBin;
    private ScannedRobotEvent lastScan = null;
    private LinkedList waves = new LinkedList();
    private LinkedList enemyWaves = new LinkedList();
    private Random random = new Random();
    private long timeOfLastChange = 0L;
    private long lastTime = 0L;
    private int lastVelSign = 1;
    private double myLastVelocity = 0.0;
    private int moveDirection = 1;
    private int moveTime = 0;
    private double enemyBulletPower = 3.0;
    private double avgEnemyBulletPower = 3.0;
    private double maxVelocity;
    private double setVelocity = this.maxVelocity = 8.0;
    private double bfHeight;
    private double bfWidth;
    private double totalStopTime = 0.0;
    private int numStopTimes = 0;
    private double bulletPower = 2.0;
    private Point2D lastEnemyLoc = null;
    private double moveDistance = 100.0;
    private static int[] distTest;
    private static int[] stopTest;
    private static int[] wallTest;
    private static int[] velTest;
    private static int linearHits;
    private static int zeroHits;
    private static boolean mirroring;
    private int mirrorTest = 0;
    private int antiMirrorTest = 0;
    private int[] moves = new int[10];
    private int mirrorMoveTimePassed = 0;
    private int mirrorMoveDirection = 1;

    public Unnamed() {
        for (int i = 0; i < this.moves.length; ++i) {
            this.moves[i] = (int)(this.random.nextDouble() * 0.8 * 450.0 / 11.0);
        }
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.bfHeight = this.getBattleFieldHeight();
        this.bfWidth = this.getBattleFieldWidth();
        while (true) {
            this.turnRadarRightRadians(1.0);
        }
    }

    private double getBulletPower(int bp, double distance) {
        int index = this.getSegmentIndex(distance, distanceLimits);
        distance = index == distanceLimits.length ? (distanceLimits[index - 1] + 1000.0) / 2.0 : (index == 0 ? distanceLimits[index] / 2.0 : (distanceLimits[index - 1] + distanceLimits[index]) / 2.0);
        switch (bp) {
            case 0: {
                return 3.0;
            }
            case 1: {
                return Math.max(0.1, Math.min(1.0 + 2.0 * (1.0 - distance / 1300.0), 3.0));
            }
            case 2: {
                return Math.max(0.1, Math.min(0.1 + 2.9 * (1.0 - distance / 600.0), 3.0));
            }
        }
        return 3.0;
    }

    private int getSegmentIndex(double value, double[] limits) {
        int i;
        for (i = 0; i < limits.length && value > limits[i]; ++i) {
        }
        return i;
    }

    private void printArray(int[] array) {
        System.out.print("[" + array[0]);
        for (int i = 1; i < array.length; ++i) {
            System.out.print(", " + array[i]);
        }
        System.out.println("]");
    }

    private void printArray(double[] array) {
        System.out.print("[" + array[0]);
        for (int i = 1; i < array.length; ++i) {
            System.out.print(", " + array[i]);
        }
        System.out.println("]");
    }

    private void printArray(float[] array) {
        System.out.print("[" + array[0]);
        for (int i = 1; i < array.length; ++i) {
            System.out.print(", " + array[i]);
        }
        System.out.println("]");
    }

    private static void addValue(TreeMap valueMap, double value) {
        Double key = new Double(value);
        if (valueMap.containsKey(key)) {
            valueMap.put(key, new Integer((Integer)valueMap.get(key) + 1));
        } else {
            valueMap.put(key, new Integer(1));
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        double angleOffset;
        int velSign;
        int myDirection;
        double absbearing = this.constrainRelative(this.getHeadingRadians() + event.getBearingRadians());
        double distance = event.getDistance();
        double velocity = event.getVelocity();
        Point2D.Double loc = new Point2D.Double(this.getX(), this.getY());
        Point2D.Double enemyLoc = new Point2D.Double(((Point2D)loc).getX() + Math.sin(absbearing) * distance, ((Point2D)loc).getY() + Math.cos(absbearing) * distance);
        double lateralVelocity = velocity * Math.sin(event.getHeadingRadians() - absbearing);
        double myLateralVelocity = this.getVelocity() * Math.sin(this.getHeadingRadians() - (absbearing + Math.PI));
        double lastVelocity = this.lastScan != null ? this.lastScan.getVelocity() : 0.0;
        double lastEnergy = this.lastScan != null ? this.lastScan.getEnergy() : 100.0;
        double acceleration = Math.abs(velocity) - Math.abs(lastVelocity);
        double myAcceleration = Math.abs(this.getVelocity()) - Math.abs(this.myLastVelocity);
        double wallDistance = 0.0;
        int direction = lateralVelocity >= 0.0 ? 1 : -1;
        int n = myDirection = myLateralVelocity >= 0.0 ? 1 : -1;
        int n2 = velocity != 0.0 ? (velocity < 0.0 ? -1 : 1) : (velSign = this.lastVelSign);
        while (!this.outsideBattlefield(Unnamed.cartesian(enemyLoc, event.getHeadingRadians(), wallDistance))) {
            wallDistance += 1.0;
        }
        if (velocity > 0.0 && lastVelocity <= 0.0 || velocity < 0.0 && lastVelocity >= 0.0 || velocity == 0.0 && lastVelocity != 0.0) {
            this.timeOfLastChange = this.getTime();
        }
        int dist = this.getSegmentIndex(distance, distanceLimits);
        int wall = this.getSegmentIndex(wallDistance / (8.0 * (distance / Unnamed.bulletSpeed(this.bulletPower))), wallLimits);
        int stop = this.getSegmentIndex(this.getTime() - this.timeOfLastChange, stopLimits);
        int latVel = this.getSegmentIndex(Math.abs(lateralVelocity), velocityLimits);
        int acc = (int)Math.round(acceleration);
        acc = acc < 0 ? 0 : (acc > 0 ? 2 : 1);
        int mydist = Math.min(7, (int)(distance / 100.0));
        int myvel = (int)(Math.abs(myLateralVelocity) / 3.0);
        int myacc = (int)Math.round(myAcceleration);
        myacc = myacc < 0 ? 0 : (myacc > 0 ? 2 : 1);
        double bestGain = Double.NEGATIVE_INFINITY;
        int bestBp = 0;
        for (int i = 0; i < 3; ++i) {
            double b;
            double chance;
            double gain;
            float[] theStats = stats[dist][i][wall][stop][latVel][acc];
            int highest = highestIndex[dist][i][wall][stop][latVel][acc];
            int total = totals[dist][i][wall][stop][latVel][acc];
            if (total <= 0 || !((gain = (chance = (double)theStats[highest] / (double)total) * (((b = this.getBulletPower(i, distance)) > 1.0 ? 6.0 * b - 2.0 : 4.0 * b) - b) - (1.0 - chance) * b) > bestGain)) continue;
            bestGain = gain;
            bestBp = i;
        }
        bestBp = 1;
        int bp = 1;
        if (distance < 200.0) {
            bp = 0;
        }
        this.bulletPower = this.getBulletPower(bp, distance);
        this.bulletPower = Math.min(this.bulletPower, Math.min(this.getEnergy() / 5.0, Math.max((event.getEnergy() - 2.0) / 6.0, event.getEnergy() / 4.0)));
        wall = this.getSegmentIndex(wallDistance / (8.0 * (distance / Unnamed.bulletSpeed(this.bulletPower))), wallLimits);
        float[] curStats = stats[dist][bp][wall][stop][latVel][acc];
        int curHighest = highestIndex[dist][bp][wall][stop][latVel][acc];
        if (this.getEnergy() > 0.0) {
            Unnamed.addValue(distances, Math.round(distance));
            Unnamed.addValue(wallDistances, Math.min((double)Math.round(100.0 * wallDistance / (8.0 * (distance / Unnamed.bulletSpeed(this.bulletPower)))) / 100.0, 1.0));
            Unnamed.addValue(stopTimes, this.getTime() - this.timeOfLastChange);
            Unnamed.addValue(velocities, (double)Math.round(20.0 * Math.abs(lateralVelocity)) / 20.0);
            ++totalValues;
        }
        if (this.getEnergy() > 0.0) {
            int n3 = dist;
            distTest[n3] = distTest[n3] + 1;
            int n4 = stop;
            stopTest[n4] = stopTest[n4] + 1;
            int n5 = wall;
            wallTest[n5] = wallTest[n5] + 1;
            int n6 = latVel;
            velTest[n6] = velTest[n6] + 1;
        }
        if (this.getTime() - this.lastTime != 1L) {
            System.out.println(this.getTime() - this.lastTime);
        }
        int i = 0;
        while ((long)i < this.getTime() - this.lastTime) {
            Object next;
            Iterator iter = this.waves.iterator();
            while (iter.hasNext()) {
                next = (Wave)iter.next();
                if (!((Wave)next).isDone(enemyLoc)) continue;
                double angle = this.constrainRelative(this.getAngle(((Wave)next).from, enemyLoc) - this.getAngle(((Wave)next).from, ((Wave)next).original));
                float[] thenStats = stats[((Wave)next).dist][((Wave)next).bp][((Wave)next).wall][((Wave)next).stop][((Wave)next).latVel][((Wave)next).acc];
                int index = Math.max(0, Math.min((int)Math.round((double)((Wave)next).direction * (angle / (1.2 * Unnamed.maxAngle(((Wave)next).speed))) * 18.0 + 18.0), 36));
                int[] nArray = totals[((Wave)next).dist][((Wave)next).bp][((Wave)next).wall][((Wave)next).stop][((Wave)next).latVel];
                int n7 = ((Wave)next).acc;
                nArray[n7] = nArray[n7] + 1;
                int n8 = index;
                float f = thenStats[n8] = thenStats[n8] + 1.0f;
                if (f >= thenStats[highestIndex[((Wave)next).dist][((Wave)next).bp][((Wave)next).wall][((Wave)next).stop][((Wave)next).latVel][((Wave)next).acc]]) {
                    Unnamed.highestIndex[((Wave)next).dist][((Wave)next).bp][((Wave)next).wall][((Wave)next).stop][((Wave)next).latVel][((Wave)next).acc] = index;
                }
                iter.remove();
            }
            iter = this.enemyWaves.iterator();
            while (iter.hasNext()) {
                next = (EnemyWave)iter.next();
                if (!((EnemyWave)next).isDone(loc)) continue;
                iter.remove();
            }
            ++i;
        }
        if (lastEnergy - event.getEnergy() >= 0.1 && lastEnergy - event.getEnergy() <= 3.0) {
            this.enemyBulletPower = lastEnergy - event.getEnergy();
            this.avgEnemyBulletPower = this.avgEnemyBulletPower * 3.0 / 4.0 + this.enemyBulletPower / 4.0;
            this.enemyWaves.add(new EnemyWave(enemyLoc, loc, this.enemyBulletPower, myDirection, mydist, myvel, myacc));
        }
        if (enemyLoc.distance(this.bfWidth - ((Point2D)loc).getX(), this.bfHeight - ((Point2D)loc).getY()) < 40.0) {
            ++this.mirrorTest;
            this.antiMirrorTest = 0;
        } else {
            this.mirrorTest = 0;
            ++this.antiMirrorTest;
        }
        if (this.mirrorTest > 20) {
            mirroring = true;
        }
        if (distance < 200.0 || this.getTime() > 100L && this.antiMirrorTest > 0) {
            mirroring = false;
        }
        if (mirroring) {
            System.out.println("ANTI-MIRROR!");
            ++this.mirrorMoveTimePassed;
            if (this.mirrorMoveTimePassed > this.moves[0]) {
                System.arraycopy(this.moves, 1, this.moves, 0, this.moves.length - 1);
                this.moves[this.moves.length - 1] = (int)(this.random.nextDouble() * 0.8 * distance / Unnamed.bulletSpeed(this.enemyBulletPower));
                this.mirrorMoveDirection *= -1;
                this.mirrorMoveTimePassed = 0;
            }
            Move move = this.decideMirrorMovement(loc, this.getHeadingRadians(), distance, absbearing, this.mirrorMoveDirection, this.mirrorMoveTimePassed);
            this.setAhead(move.distanceToMove);
            this.setTurnRightRadians(move.radiansToTurn);
        } else {
            Point2D newDestination;
            double distDelta = (distance < 300.0 ? 0.75 : 0.5) + 1.5707963267948966;
            while (this.outsideBattlefield(newDestination = Unnamed.cartesian(loc, absbearing + (double)this.moveDirection * (distDelta -= 0.01), 180.0))) {
            }
            double theta = Utils.normalRelativeAngle((double)(this.getAngle(loc, newDestination) - this.getHeadingRadians()));
            if (zeroHits > 5 && zeroHits > 10 * linearHits) {
                System.out.println("ANTI-HEAD-ON");
                if (distDelta <= 0.6283185307179586) {
                    this.moveDirection *= -1;
                }
            } else {
                if (distDelta <= 0.7853981633974483 || this.random.nextDouble() < currentChanceToTurn[myvel][myacc][mydist] * (Unnamed.bulletSpeed(this.enemyBulletPower) / Unnamed.bulletSpeed(3.0))) {
                    this.moveDirection *= -1;
                }
                this.setVelocity = this.setVelocity == this.maxVelocity ? this.maxVelocity - 0.6 : this.maxVelocity;
                this.setMaxVelocity(this.setVelocity);
            }
            this.setAhead(Math.cos(theta) * this.moveDistance);
            this.setTurnRightRadians(Math.tan(theta));
        }
        this.setTurnRadarRightRadians(this.constrainRelative(absbearing - this.getRadarHeadingRadians()) * 2.0);
        if (mirroring) {
            MovSim sim = new MovSim();
            MovSimStat him = new MovSimStat(((Point2D)enemyLoc).getX(), ((Point2D)enemyLoc).getY(), event.getVelocity(), event.getHeadingRadians(), 0.0);
            MovSimStat me = new MovSimStat(((Point2D)loc).getX(), ((Point2D)loc).getY(), this.getVelocity(), this.getHeadingRadians(), 0.0);
            Point2D.Double myLoc = new Point2D.Double(me.x, me.y);
            Point2D.Double hisLoc = new Point2D.Double(him.x, him.y);
            this.bulletPower = 3.0;
            int bulletTime = (int)(distance / Unnamed.bulletSpeed(3.0));
            int time = 0;
            for (int i2 = 0; i2 < this.moves.length && time < bulletTime - 2; ++i2) {
                for (int j = 0; j < this.moves[i2] && time < bulletTime - 2; ++j, ++time) {
                    Move myMove = this.decideMirrorMovement(myLoc, me.h, myLoc.distance(hisLoc), this.getAngle(myLoc, hisLoc), this.mirrorMoveDirection, this.mirrorMoveTimePassed + time);
                    Move hisMove = this.decideMirrorMovement(hisLoc, him.h, hisLoc.distance(myLoc), this.getAngle(hisLoc, myLoc), this.mirrorMoveDirection, this.mirrorMoveTimePassed + time - 2);
                    me = sim.futurePos(me.x, me.y, me.v, me.h, myMove.distanceToMove, myMove.radiansToTurn, this.bfWidth, this.bfHeight);
                    him = sim.futurePos(him.x, him.y, him.v, him.h, hisMove.distanceToMove, hisMove.radiansToTurn, this.bfWidth, this.bfHeight);
                    myLoc = new Point2D.Double(me.x, me.y);
                    hisLoc = new Point2D.Double(him.x, him.y);
                    bulletTime = (int)(myLoc.distance(hisLoc) / Unnamed.bulletSpeed(this.bulletPower));
                }
            }
            angleOffset = this.getAngle(loc, new Point2D.Double(this.bfWidth - ((Point2D)myLoc).getX(), this.bfHeight - ((Point2D)myLoc).getY()));
            this.setTurnGunRightRadians(this.constrainRelative(angleOffset - this.getGunHeadingRadians()));
        } else {
            angleOffset = (double)direction * ((double)(curHighest - 18) / 18.0) * Unnamed.maxAngle(Unnamed.bulletSpeed(this.bulletPower));
            this.setTurnGunRightRadians(this.constrainRelative(absbearing + angleOffset - this.getGunHeadingRadians()));
        }
        if (this.getEnergy() > 0.0 && this.bulletPower == this.getBulletPower(bp, distance)) {
            int i3 = 0;
            while ((long)i3 < this.getTime() - this.lastTime) {
                Wave newWave = new Wave(loc, enemyLoc, this.bulletPower, direction, dist, bp, wall, stop, latVel, acc);
                this.waves.add(newWave);
                int j = 0;
                while ((long)j < this.getTime() - this.lastTime - (long)i3 - 1L) {
                    newWave.isDone(enemyLoc);
                    ++j;
                }
                ++i3;
            }
        }
        if (this.getEnergy() > this.bulletPower + 0.5) {
            this.setFire(this.bulletPower);
        }
        this.lastVelSign = velSign;
        this.lastTime = this.getTime();
        this.lastScan = event;
        this.lastEnemyLoc = enemyLoc;
        this.myLastVelocity = this.getVelocity();
    }

    private Move decideMirrorMovement(Point2D loc, double heading, double distance, double absbearing, int moveDirection, int timePassed) {
        Point2D newDestination;
        double distDelta = (distance > 450.0 ? -0.3 : 0.0) + 1.5707963267948966;
        for (int i = 0; i < this.moves.length && timePassed > 0; timePassed -= this.moves[i], ++i) {
            moveDirection *= -1;
        }
        moveDirection *= -1;
        while (this.outsideBattlefield(newDestination = Unnamed.cartesian(loc, absbearing + (double)moveDirection * (distDelta -= 0.01), 180.0))) {
        }
        double theta = Utils.normalRelativeAngle((double)(this.getAngle(loc, newDestination) - heading));
        return new Move(Math.cos(theta) * this.moveDistance, Math.tan(theta));
    }

    public void onDeath(DeathEvent event) {
        this.resetAllLimits();
    }

    public void onWin(WinEvent event) {
        this.resetAllLimits();
    }

    public void onHitByBullet(HitByBulletEvent event) {
        try {
            EnemyWave wave = (EnemyWave)this.enemyWaves.removeFirst();
            double factor = (double)wave.direction * this.constrainRelative(this.getAngle(wave.from, new Point2D.Double(this.getX(), this.getY())) - this.getAngle(wave.from, wave.original)) / Unnamed.maxAngle(wave.speed);
            if (factor > 0.6) {
                ++linearHits;
                Unnamed.currentChanceToTurn[wave.myvel][wave.myacc][wave.dist] = goodCTT[wave.dist] * 1.3333;
            } else if (factor < 0.2) {
                ++zeroHits;
                Unnamed.currentChanceToTurn[wave.myvel][wave.myacc][wave.dist] = goodCTT[wave.dist] * 0.75;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void resetAllLimits() {
        Unnamed.resetLimits(distances, distanceLimits, 8, totalValues, Double.POSITIVE_INFINITY);
        Unnamed.resetLimits(wallDistances, wallLimits, 3, totalValues, Double.POSITIVE_INFINITY);
        Unnamed.resetLimits(stopTimes, stopLimits, 5, totalValues, Double.POSITIVE_INFINITY);
        Unnamed.resetLimits(velocities, velocityLimits, 3, totalValues, 7.99);
        this.printArray(distanceLimits);
        this.printArray(wallLimits);
        this.printArray(stopLimits);
        this.printArray(velocityLimits);
        System.out.println(" --------- ");
        this.printArray(distTest);
        this.printArray(wallTest);
        this.printArray(stopTest);
        this.printArray(velTest);
    }

    private static void resetLimits(TreeMap valueMap, double[] limits, int segmentSize, int total, double maxValue) {
        Iterator iter = valueMap.keySet().iterator();
        double beforeValue = 0.0;
        double value = 0.0;
        double temp = 0.0;
        int chunk = total / segmentSize;
        for (int i = 0; i < limits.length; ++i) {
            int j;
            Double key;
            for (j = 0; j < chunk; j += ((Integer)valueMap.get(key)).intValue()) {
                key = (Double)iter.next();
                value = key;
            }
            chunk -= (j - total / segmentSize) / (limits.length - i);
            limits[i] = Math.min(value, maxValue);
        }
    }

    private double constrainRelative(double angle) {
        return (angle + Math.PI * 7) % (Math.PI * 2) - Math.PI;
    }

    private double getAngle(Point2D from, Point2D to) {
        return Math.atan2(to.getX() - from.getX(), to.getY() - from.getY());
    }

    private boolean outsideBattlefield(Point2D loc) {
        return !new RoundRectangle2D.Double(19.0, 19.0, this.bfWidth - 38.0, this.bfHeight - 38.0, 75.0, 75.0).contains(loc);
    }

    private static Point2D cartesian(Point2D origin, double theta, double radius) {
        return new Point2D.Double(Math.sin(theta) * radius + origin.getX(), Math.cos(theta) * radius + origin.getY());
    }

    private static final double bulletSpeed(double power) {
        return 20.0 - 3.0 * power;
    }

    private static final double maxAngle(double bulletSpeed) {
        return Unnamed.travelAngle(8.0, bulletSpeed);
    }

    private static final double travelAngle(double speed, double bulletSpeed) {
        return Math.asin(speed / bulletSpeed);
    }

    static {
        int k;
        int j;
        int i;
        stats = new float[8][3][3][5][3][3][37];
        highestIndex = new int[8][3][3][5][3][3];
        totals = new int[8][3][3][5][3][3];
        distances = new TreeMap();
        wallDistances = new TreeMap();
        stopTimes = new TreeMap();
        velocities = new TreeMap();
        distanceLimits = new double[]{300.0, 350.0, 400.0, 450.0, 500.0, 550.0, 600.0};
        wallLimits = new double[]{0.3, 0.7};
        stopLimits = new double[]{8.0, 24.0, 36.0, 48.0};
        velocityLimits = new double[]{3.0, 6.0};
        totalValues = 0;
        goodCTT = new double[]{0.2, 0.16, 0.12, 0.055, 0.04, 0.024, 0.033, 0.025, 0.018, 0.01, 0.01, 0.01, 0.01};
        currentChanceToTurn = new double[3][3][8];
        linearHitBin = new int[3][3][8];
        zeroHitBin = new int[3][3][8];
        distTest = new int[8];
        stopTest = new int[5];
        wallTest = new int[3];
        velTest = new int[3];
        linearHits = 0;
        zeroHits = 0;
        mirroring = false;
        for (i = 0; i < 8; ++i) {
            for (j = 0; j < 3; ++j) {
                for (k = 0; k < 3; ++k) {
                    for (int m = 0; m < 5; ++m) {
                        for (int n = 0; n < 3; ++n) {
                            Arrays.fill(highestIndex[i][j][k][m][n], 0, 3, 18);
                        }
                    }
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                for (k = 0; k < 8; ++k) {
                    Unnamed.currentChanceToTurn[i][j][k] = goodCTT[k];
                }
            }
        }
    }

    private static class EnemyWave {
        public Point2D from;
        public Point2D original;
        public double distance;
        public double speed;
        public int direction;
        public int dist;
        public int myvel;
        public int myacc;
        public boolean valid;

        public EnemyWave(Point2D from, Point2D original, double bp, int direction, int dist, int myvel, int myacc) {
            this.from = from;
            this.original = original;
            this.speed = Unnamed.bulletSpeed(bp);
            this.distance = this.speed * 2.0;
            this.direction = direction;
            this.dist = dist;
            this.myvel = myvel;
            this.myacc = myacc;
        }

        public final boolean isDone(Point2D myLocation) {
            this.distance += this.speed;
            return this.distance > this.from.distance(myLocation) + 50.0;
        }
    }

    private static class Wave {
        public Point2D from;
        public Point2D original;
        public double distance;
        public double speed;
        public int direction;
        public int latVel;
        public int acc;
        public int dist;
        public int bp;
        public int stop;
        public int wall;

        public Wave(Point2D from, Point2D original, double power, int direction, int dist, int bp, int wall, int stop, int latVel, int acc) {
            this.from = from;
            this.original = original;
            this.direction = direction;
            this.dist = dist;
            this.bp = bp;
            this.wall = wall;
            this.stop = stop;
            this.latVel = latVel;
            this.acc = acc;
            this.distance = this.speed = 20.0 - 3.0 * power;
        }

        public final boolean isDone(Point2D target) {
            double d;
            this.distance += this.speed;
            return d > this.from.distance(target);
        }
    }

    private static class Move {
        public double distanceToMove;
        public double radiansToTurn;

        public Move(double d, double r) {
            this.distanceToMove = d;
            this.radiansToTurn = r;
        }
    }
}

