/*
 * Decompiled with CFR 0.152.
 */
package ags.util.points;

import ags.util.points.AbsolutePoint;
import java.awt.geom.Point2D;
import java.io.Serializable;
import robocode.util.Utils;

public final class RelativePoint
extends Point2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double direction;
    public double magnitude;

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getDirection() {
        return this.direction;
    }

    public double getDirDist(double dir) {
        return Utils.normalRelativeAngle((double)(this.direction - dir));
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public RelativePoint addRelativePoint(RelativePoint rel) {
        return RelativePoint.fromXY(this.getX() + rel.getX(), this.getY() + rel.getY());
    }

    public RelativePoint incrementDirMag(double direction, double magnitude) {
        return RelativePoint.fromDM(this.direction + direction, this.magnitude + magnitude);
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        this.direction = Utils.normalAbsoluteAngle((double)Math.atan2(x, y));
        this.magnitude = Math.hypot(x, y);
    }

    public void setDirectionMagnitude(double direction, double magnitude) {
        this.direction = Utils.normalAbsoluteAngle((double)direction);
        this.magnitude = magnitude;
        this.x = magnitude * Math.sin(this.direction);
        this.y = magnitude * Math.cos(this.direction);
    }

    private static RelativePoint getNewInstance() {
        return new RelativePoint();
    }

    public static RelativePoint fromXY(double x, double y) {
        RelativePoint newpoint = RelativePoint.getNewInstance();
        newpoint.setLocation(x, y);
        return newpoint;
    }

    public static RelativePoint fromDM(double direction, double magnitude) {
        RelativePoint newpoint = RelativePoint.getNewInstance();
        newpoint.setDirectionMagnitude(direction, magnitude);
        return newpoint;
    }

    public static RelativePoint fromPP(AbsolutePoint p1, AbsolutePoint p2) {
        RelativePoint newpoint = RelativePoint.getNewInstance();
        newpoint.setLocation(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        return newpoint;
    }
}

