/*
 * Decompiled with CFR 0.152.
 */
package kid.communication;

import kid.communication.Message;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class ScannedRobotMessage
extends Message {
    private static final long serialVersionUID = 5103237704700781761L;
    private String name;
    private double distance;
    private double angle;
    private double energy;
    private double heading;
    private double headingRadians;
    private double velocity;

    public ScannedRobotMessage(ScannedRobotEvent sre, Robot reference) {
        super(sre.getTime());
        this.init(sre, reference);
    }

    private void init(ScannedRobotEvent sre, Robot reference) {
        this.name = sre.getName();
        this.distance = sre.getDistance();
        this.angle = reference.getHeading() + sre.getBearing();
        this.energy = sre.getEnergy();
        this.heading = sre.getHeading();
        this.headingRadians = sre.getHeadingRadians();
        this.velocity = sre.getVelocity();
    }

    public double getDistance() {
        return this.distance;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getHeadingRadians() {
        return this.headingRadians;
    }

    public String getName() {
        return this.name;
    }

    public double getVelocity() {
        return this.velocity;
    }
}

