/*
 * Decompiled with CFR 0.152.
 */
package kid.targeting;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import kid.data.pattern.FoldedEntry;
import kid.data.pattern.PatternMatcher;
import kid.data.pattern.Polar;
import kid.graphics.Colors;
import kid.info.RobotInfo;
import kid.robot.RobotData;
import kid.targeting.Targeting;
import kid.utils.Utils;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.Rules;

public class PatternMatchingTargeting
extends Targeting {
    private static final long serialVersionUID = 6581499402431094042L;
    public static final int MAX_MATCH_LENGTH = 500;
    private PatternMatcher<Polar> matcher;

    public PatternMatchingTargeting(Robot myRobot, PatternMatcher<Polar> matcher) {
        super(myRobot);
        this.init(matcher);
    }

    public PatternMatchingTargeting(PatternMatchingTargeting targeting) {
        super(targeting);
        this.init(targeting.matcher);
    }

    private void init(PatternMatcher<Polar> matcher) {
        this.matcher = matcher;
    }

    @Override
    public double getAngle(RobotData target, double firePower) {
        if (target == null || target.isDead()) {
            return Utils.relative(this.gunInfo.getHeading() + this.gunInfo.getHeading());
        }
        if (target.getEnergy() == 0.0) {
            return this.gunInfo.angle(target);
        }
        FoldedEntry<Polar> movement = this.matcher.getMatch(target.getName());
        firePower = Math.min(this.robot.getEnergy(), firePower);
        firePower = Utils.limit(0.1, firePower, 3.0);
        double bulletVelocity = Rules.getBulletSpeed((double)firePower);
        double MWD = RobotInfo.MIN_WALL_DIST - 1.0;
        Rectangle2D.Double battleField = new Rectangle2D.Double(MWD, MWD, this.gunInfo.getBattleFieldWidth() - 2.0 * MWD, this.gunInfo.getBattleFieldHeight() - 2.0 * MWD);
        double myX = this.robot.getX();
        double myY = this.robot.getY();
        double prodictedX = target.getX();
        double prodictedY = target.getY();
        double enemyHeading = target.getHeading();
        int t = -1;
        while (this.goodNext(movement) && Utils.sqr((double)t * bulletVelocity) < Utils.distSq(myX, myY, prodictedX, prodictedY)) {
            Polar p = (movement = movement.next()).item();
            double enemyVelocity = p.getVelocity();
            if (!battleField.contains(prodictedX += Utils.getX(0.0, enemyVelocity, enemyHeading += p.getDeltaHeading()), prodictedY += Utils.getY(0.0, enemyVelocity, enemyHeading))) {
                prodictedX -= Utils.getX(0.0, enemyVelocity, enemyHeading);
                prodictedY -= Utils.getY(0.0, enemyVelocity, enemyHeading);
                break;
            }
            if (!this.goodNext(movement)) {
                movement = this.matcher.getMatch(target.getName());
            }
            ++t;
        }
        return this.gunInfo.angle(prodictedX, prodictedY);
    }

    private boolean goodNext(FoldedEntry<Polar> entry) {
        return entry != null && entry.next() != null && entry.next().item() != Polar.DUMMY_PATTERN;
    }

    @Override
    public Color getColor() {
        return Colors.WHITE;
    }

    @Override
    public String getName() {
        return new String("Pattern Matching Targeting");
    }

    @Override
    public String getType() {
        return new String("Log");
    }

    @Override
    public void print(PrintStream console) {
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    public void debug(PrintStream console) {
    }

    public void debug(RobocodeFileOutputStream output) {
    }

    public Object clone() {
        return new PatternMatchingTargeting(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PatternMatchingTargeting) {
            PatternMatchingTargeting targeting = (PatternMatchingTargeting)obj;
            if (targeting.robot != null && targeting.robot.getName() != null && this.robot != null) {
                return targeting.robot.getName().equals(this.robot.getName());
            }
        }
        return false;
    }

    public String toString() {
        return new String();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }
}

