/*
 * Decompiled with CFR 0.152.
 */
package mb.movement;

import java.util.ArrayList;
import java.util.List;
import mb.MBRobot;
import mb.movement.Movement;
import mb.movement.MovementComponent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class MovementHandler
extends MovementComponent {
    protected List<Movement> movements = new ArrayList<Movement>();

    public MovementHandler(MBRobot me) {
        super(me);
    }

    public void add(Movement movement) {
        if (this.isTypeAlreadyAdded(movement)) {
            return;
        }
        this.movements.add(movement);
    }

    public void remove(Class type) {
        for (Movement movement : this.movements) {
            if (movement.getClass() != type) continue;
            this.movements.remove(movement);
            return;
        }
    }

    @Override
    public void onCustomEvent(CustomEvent event) {
        for (Movement movement : this.movements) {
            movement.onCustomEvent(event);
        }
        super.onCustomEvent(event);
    }

    @Override
    public void run() {
        for (Movement movement : this.movements) {
            movement.run();
        }
        super.run();
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        for (Movement movement : this.movements) {
            movement.onScannedRobot(event);
        }
        super.onScannedRobot(event);
    }

    @Override
    public void onDeath(DeathEvent event) {
        for (Movement movement : this.movements) {
            movement.onDeath(event);
        }
        super.onDeath(event);
    }

    @Override
    public void onRobotDeath(RobotDeathEvent event) {
        for (Movement movement : this.movements) {
            movement.onRobotDeath(event);
        }
        super.onRobotDeath(event);
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        for (Movement movement : this.movements) {
            movement.onHitByBullet(event);
        }
        super.onHitByBullet(event);
    }

    @Override
    public void onRobotFired(ScannedRobotEvent event) {
        for (Movement movement : this.movements) {
            movement.onRobotFired(event);
        }
        super.onRobotFired(event);
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
        for (Movement movement : this.movements) {
            movement.onHitRobot(event);
        }
        super.onHitRobot(event);
    }

    public void printMovements() {
        for (Movement movement : this.movements) {
            System.out.println(movement);
        }
    }

    private boolean isTypeAlreadyAdded(Movement newMovement) {
        for (Movement movement : this.movements) {
            if (movement.getClass() != newMovement.getClass()) continue;
            return true;
        }
        return false;
    }
}

