/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot;

import java.awt.geom.Point2D;
import lazarecki.robot.ModularRobot;
import lazarecki.util.RoboUtils;
import lazarecki.wave.Wave;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class RobotInfo {
    private Point2D position;
    private double absHeading;
    private double velocity;
    private double energy;
    private long time;
    private double battleFieldWidth;
    private double battleFieldHeight;

    public RobotInfo(Point2D position, double absHeading, double velocity, double energy, long time, double battleFieldWidth, double battleFieldHeight) {
        this.position = (Point2D)position.clone();
        this.absHeading = absHeading;
        this.velocity = velocity;
        this.energy = energy;
        this.time = time;
        this.battleFieldWidth = battleFieldWidth;
        this.battleFieldHeight = battleFieldHeight;
    }

    public RobotInfo(ModularRobot robot) {
        this((Point2D)robot.getPosition().clone(), robot.getHeadingRadians(), robot.getVelocity(), robot.getEnergy(), robot.getTime(), robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
    }

    public RobotInfo(ScannedRobotEvent event, ModularRobot robot) {
        this(RoboUtils.projectPoint((Point2D)robot.getPosition().clone(), robot.getHeadingRadians() + event.getBearingRadians(), event.getDistance()), event.getHeadingRadians(), event.getVelocity(), event.getEnergy(), event.getTime() - 1L, robot.getBattleFieldWidth(), robot.getBattleFieldHeight());
    }

    public Point2D getPosition() {
        return this.position;
    }

    public double getHeadingRadians() {
        return this.absHeading;
    }

    public double getHeadingDegrees() {
        return 180.0 * (this.getHeadingRadians() / Math.PI);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public long getTime() {
        return this.time;
    }

    public double getBattleFieldWidth() {
        return this.battleFieldWidth;
    }

    public double getBattleFieldHeight() {
        return this.battleFieldHeight;
    }

    public Point2D projectPoint(double relativeAngle, double distance) {
        return RoboUtils.projectPoint(this.getPosition(), Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + relativeAngle)), distance);
    }

    public double absoluteAngle(Point2D point) {
        return RoboUtils.projectAbsoluteAngle(this.getPosition(), point);
    }

    public double absoluteAngle(RobotInfo info) {
        return this.absoluteAngle(info.getPosition());
    }

    public double distance(Point2D point) {
        return point.distance(this.getPosition());
    }

    public double distance(RobotInfo info) {
        return this.distance(info.getPosition());
    }

    public Wave.ClockDirection clockDirection(RobotInfo info) {
        return Utils.normalRelativeAngle((double)(info.getHeadingRadians() - info.absoluteAngle(this))) * info.getVelocity() >= 0.0 ? Wave.ClockDirection.Counterclockwise : Wave.ClockDirection.Clockwise;
    }

    public Object clone() throws CloneNotSupportedException {
        return new RobotInfo(this.getPosition(), this.getHeadingRadians(), this.getVelocity(), this.getEnergy(), this.getTime(), this.getBattleFieldWidth(), this.getBattleFieldHeight());
    }
}

