/*
 * Decompiled with CFR 0.152.
 */
package oog.nano;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Caligula
extends AdvancedRobot {
    static double enemyEnergy;
    static double dir;
    static int mode;

    public void run() {
        dir = 0.0015;
        this.setAllColors(Color.LIGHT_GRAY);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double d;
        double absBearing = e.getBearingRadians();
        double latVel = e.getDistance();
        this.setTurnRightRadians(Math.cos(absBearing) + dir * (160.0 - latVel));
        this.setFire(latVel < 100.0 ? 3 : 2);
        this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
        double d2 = enemyEnergy;
        enemyEnergy = e.getEnergy();
        if (d2 > d && mode >= 2) {
            dir = -dir;
        }
        this.setAhead(dir * Double.POSITIVE_INFINITY);
        latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - (absBearing + this.getHeadingRadians()));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + this.getHeadingRadians() - this.getGunHeadingRadians() + latVel / 14.0)));
        if (mode >= 4) {
            this.setAhead(Math.cos(absBearing) * Double.POSITIVE_INFINITY);
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)(absBearing + (Math.abs(absBearing) < 1.5707963267948966 ? 0.0 : Math.PI))) + latVel / 8.0);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        enemyEnergy -= 10.0;
    }

    public void onDeath(DeathEvent e) {
        ++mode;
    }

    public void onHitWall(HitWallEvent e) {
        dir = -dir;
    }
}

