/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot;

import cbot.cbot.Bot;
import cbot.cbot.CBot;
import cbot.cbot.CU;
import cbot.cbot.Point;
import cbot.cbot.gun.Pattern;
import cbot.cbot.gun.VirtualBulletManager;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.ScannedRobotEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Pray
implements Bot {
    private static Pattern pattern;
    private static int totFired;
    private static int totFired_short;
    private static int totFired_middle;
    private static int totFired_long;
    private static int totHit;
    private static int totHit_short;
    private static int totHit_middle;
    private static int totHit_long;
    public VirtualBulletManager virtualBulletManager;
    private ArrayList bullets;
    private double bearing;
    private double bearingDelta;
    private double heading;
    private double headingDelta;
    private double velocity;
    private double velocityDelta;
    private double distance;
    private double energy;
    private String name;
    private Point cordinate;
    private CBot robot;
    private int timeDelta;
    private long time;
    private double lostEnergy;
    private double gainedEnergy;
    private double lastFirePower;

    public void update(ScannedRobotEvent sre, AdvancedRobot r) {
        this.bearingDelta = sre.getBearing() - this.bearing;
        this.bearing = sre.getBearing();
        this.headingDelta = sre.getHeading() - this.heading;
        this.heading = sre.getHeading();
        this.velocityDelta = sre.getVelocity() - this.velocity;
        this.velocity = sre.getVelocity();
        this.distance = sre.getDistance();
        this.cordinate = this.getPoint(this.robot, sre);
        this.timeDelta = (int)(r.getTime() - this.time);
        this.time = r.getTime();
        this.logMove();
        this.isFiring(sre.getEnergy() - this.energy);
        this.energy = sre.getEnergy();
    }

    public void gotHitByBullet(Bullet bullet) {
        this.lostEnergy = CU.getLostEnergyByBullet(bullet.getPower());
    }

    public void hitRobotWithBullet(Bullet bullet) {
        this.gainedEnergy = CU.getGainedEnergyByBullet(bullet.getPower());
        ++totHit;
        this.checkBullets();
    }

    public double[] getDistanceHittingRates() {
        double[] arr = new double[]{100.0 * ((double)totHit_short / (double)totFired_short), 100.0 * ((double)totHit_middle / (double)totFired_middle), 100.0 * ((double)totHit_long / (double)totFired_long)};
        return arr;
    }

    public String getHittingRates() {
        String str = this.name + ": [" + totHit + '/' + totFired + "] " + CU.formatNumber((double)totHit / (double)totFired * 100.0) + "%\n";
        str = str + "L=[" + totHit_long + '/' + totFired_long + "] " + CU.formatNumber(100.0 * ((double)totHit_long / (double)totFired_long)) + '\n';
        str = str + "M=[" + totHit_middle + '/' + totFired_middle + "] " + CU.formatNumber(100.0 * ((double)totHit_middle / (double)totFired_middle)) + '\n';
        str = str + "S=[" + totHit_short + '/' + totFired_short + "] " + CU.formatNumber(100.0 * ((double)totHit_short / (double)totFired_short)) + '\n';
        return str;
    }

    private final void isFiring(double energyDelta) {
        this.lastFirePower = energyDelta + this.lostEnergy - this.gainedEnergy;
        this.gainedEnergy = 0.0;
        this.lostEnergy = 0.0;
        if (this.lastFirePower < -0.001 && this.lastFirePower >= -3.0) {
            this.robot.driver.handleBeingFiredAt(this, Math.abs(this.lastFirePower), this.time);
            ++totFired;
            double distance = this.robot.getCordinate().getDistance(this.cordinate);
            this.bullets.add(new PrayBullet(this.robot, this.cordinate, this.lastFirePower));
            if (distance < CU.DISTANCE_SHORT) {
                ++totFired_short;
            } else if (distance < CU.DISTANCE_MIDDLE) {
                ++totFired_middle;
            } else {
                ++totFired_long;
            }
        }
        this.lastFirePower = 0.0;
    }

    private final void logMove() {
        if (this.robot.getTime() > 30L) {
            pattern.log(this.time, CU.normalRelativeAngle(this.headingDelta), this.velocity, this.velocityDelta);
        }
    }

    private final Point getPoint(CBot robot, ScannedRobotEvent sre) {
        Point reference = robot.getCordinate();
        double prayAbsBearing = sre.getBearingRadians() + robot.getHeadingRadians() - Math.PI * 2;
        return Point.getNewPoint(reference, this.distance, prayAbsBearing);
    }

    private final void checkBullets() {
        double minDiff = 100.0;
        double currentDistance = -1.0;
        int i = 0;
        while (i < this.bullets.size()) {
            PrayBullet pb = (PrayBullet)this.bullets.get(i);
            double diff = pb.getTravelDiff();
            if (diff < Math.abs(minDiff)) {
                minDiff = Math.abs(diff);
                currentDistance = pb.fireDistance;
            }
            if (diff > 20.0) {
                this.bullets.remove(pb);
            }
            ++i;
        }
        if (currentDistance < CU.DISTANCE_SHORT) {
            ++totHit_short;
        } else if (currentDistance < CU.DISTANCE_MIDDLE) {
            ++totHit_middle;
        } else {
            ++totHit_long;
        }
    }

    public boolean isDisabled() {
        boolean bl = false;
        if (this.energy == 0.0) {
            bl = true;
        }
        return bl;
    }

    public Pattern getPattern() {
        return pattern;
    }

    public double getFirePower(Bot bot) {
        return this.lastFirePower;
    }

    public long getTime() {
        return this.time;
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getName() {
        return this.name;
    }

    public Point getCordinate() {
        return this.cordinate;
    }

    public double getBearingDelta() {
        return this.bearingDelta;
    }

    public long getTimeDelta() {
        return this.timeDelta;
    }

    public double getHeadingDelta() {
        return this.headingDelta;
    }

    public VirtualBulletManager getVirtualBulletManager() {
        return this.virtualBulletManager;
    }

    private final /* synthetic */ void this() {
        this.bullets = new ArrayList(5);
        this.lostEnergy = 0.0;
        this.gainedEnergy = 0.0;
        this.lastFirePower = 0.0;
    }

    public Pray(ScannedRobotEvent pray, CBot r) {
        this.this();
        this.bearing = pray.getBearing();
        this.heading = pray.getHeading();
        this.velocity = pray.getVelocity();
        this.distance = pray.getDistance();
        this.energy = pray.getEnergy();
        this.name = pray.getName();
        this.robot = r;
        this.cordinate = this.getPoint(this.robot, pray);
        this.time = r.getTime();
        if (pattern == null) {
            pattern = new Pattern();
        }
        this.virtualBulletManager = new VirtualBulletManager(this.robot, this, CBot.gun.strategys);
    }

    static {
        totFired = 0;
        totFired_short = 0;
        totFired_middle = 0;
        totFired_long = 0;
        totHit = 0;
        totHit_short = 0;
        totHit_middle = 0;
        totHit_long = 0;
    }

    class PrayBullet {
        double fireDistance;
        Point fireCord;
        long fireTime;
        double firePower;

        public double getTravelDiff() {
            double distance = Pray.this.robot.getCordinate().getDistance(this.fireCord);
            double travelTime = distance / CU.getBulletVelocity(this.firePower);
            double elapsedTime = Pray.this.robot.getTime() - this.fireTime;
            return CU.diff(travelTime, elapsedTime);
        }

        public PrayBullet(CBot r, Point fc, double fp) {
            this.fireDistance = Pray.this.distance;
            this.fireCord = fc;
            this.fireTime = r.getTime();
            this.firePower = fp;
        }
    }
}

