/*
 * Decompiled with CFR 0.152.
 */
package cuoq.movement;

import cuoq.Component;
import cuoq.Utils;
import cuoq.movement.MovementWave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class NewWaveSurfingMovement
extends Component {
    private static final int BOT_WIDTH = 36;
    private static final int GF_BINS = 151;
    private static final int GF_MIDDLE = 75;
    private static double[] movementStats = new double[151];
    private ArrayList<MovementWave> movementWaves = new ArrayList();
    private ArrayList<Point2D.Double> predictedPositions = new ArrayList();
    private double enemyEnergy = 100.0;
    private Point2D.Double currentPosition;
    private Point2D.Double previousPosition = new Point2D.Double();
    private Point2D.Double enemyPosition = new Point2D.Double();
    private double lastLateralVelocity = 0.0;
    private static Rectangle2D.Double BATTLEFIELD;
    private static boolean isInitialized;

    static {
        isInitialized = false;
    }

    public NewWaveSurfingMovement(AdvancedRobot robot) {
        super(robot);
        if (!isInitialized) {
            BATTLEFIELD = new Rectangle2D.Double(18.0, 18.0, robot.getBattleFieldWidth() - 36.0, robot.getBattleFieldHeight() - 36.0);
            isInitialized = true;
        }
        this.currentPosition = new Point2D.Double(robot.getX(), robot.getY());
    }

    @Override
    public void onPaint(Graphics2D g) {
        long time = this.robot.getTime();
        double dangerRange = 0.0;
        double lowestDanger = 9.99999999E8;
        double highestDanger = 0.0;
        int i = 0;
        while (i < movementStats.length) {
            double danger = movementStats[i];
            if (danger < lowestDanger) {
                lowestDanger = danger;
            }
            if (danger > highestDanger) {
                highestDanger = danger;
            }
            ++i;
        }
        dangerRange = highestDanger - lowestDanger;
        MovementWave closestWave = null;
        double closestDistance = 9999999.0;
        for (MovementWave w : this.movementWaves) {
            g.setColor(Color.ORANGE);
            double distance = w.getDistance(time);
            double distanceDifference = this.currentPosition.distance(w.origin) - 50.0 - distance;
            if (distanceDifference > 0.0 && distanceDifference < closestDistance) {
                closestWave = w;
                closestDistance = distanceDifference;
            }
            Point2D.Double headsOnPosition = Utils.project(w.origin, w.headsOnHeading, distance);
            g.drawLine((int)w.origin.x, (int)w.origin.y, (int)headsOnPosition.x, (int)headsOnPosition.y);
            g.drawString(String.format("%.1f @ %.1f", distance, w.headsOnHeading / Math.PI * 180.0), (int)headsOnPosition.x + 5, (int)headsOnPosition.y + 5);
            double mea = Utils.getMaximumEscapeArea(Rules.getBulletSpeed((double)w.bulletPower));
            int i2 = 0;
            while (i2 < 151) {
                double guessFactor = ((double)i2 - 75.0) / 75.0 * (double)w.direction;
                float dangerFactor = (float)((movementStats[i2] - lowestDanger) / dangerRange);
                g.setColor(new Color(dangerFactor, 1.0f - dangerFactor, 0.1f));
                Point2D.Double gfPoint = Utils.project(w.origin, w.headsOnHeading + mea * guessFactor, distance);
                g.fillOval((int)(gfPoint.x - 2.0), (int)(gfPoint.y - 2.0), 4, 4);
                ++i2;
            }
        }
        for (Point2D.Double p : this.predictedPositions) {
            g.setColor(Color.RED);
            g.drawOval((int)p.x - 3, (int)p.y - 3, 6, 6);
            g.setColor(Color.WHITE);
            if (closestWave == null) continue;
            g.drawString(String.format("%.1f", this.getDanger(p, closestWave, 1)), (int)p.x + 10, (int)p.y + 10);
        }
    }

    @Override
    public void onIdle() {
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        this.enemyEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        this.enemyEnergy -= 1.2;
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        this.enemyEnergy += Rules.getBulletHitBonus((double)e.getBullet().getPower());
        Point2D.Double eventLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        this.logEvent(eventLocation, e.getBullet().getPower(), e.getTime());
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double eventLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        this.logEvent(eventLocation, e.getBullet().getPower(), e.getTime());
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        double absoluteBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
        double lateralVelocity = Math.sin(e.getBearingRadians()) * this.robot.getVelocity();
        long fireTime = e.getTime();
        double bulletPower = this.enemyEnergy - e.getEnergy();
        if (bulletPower > 0.0 && bulletPower <= 3.0) {
            MovementWave mw = new MovementWave((Point2D.Double)this.enemyPosition.clone(), (Point2D.Double)this.previousPosition.clone(), this.lastLateralVelocity, bulletPower, fireTime, this.lastLateralVelocity > 0.0 ? 1 : -1);
            mw.velocity = this.lastLateralVelocity;
            mw.fireTime = fireTime;
            mw.headsOnHeading = Utils.angleBetweenPoints(mw.origin, mw.destination);
            this.movementWaves.add(mw);
        }
        this.lastLateralVelocity = lateralVelocity;
        this.previousPosition = (Point2D.Double)this.currentPosition.clone();
        this.enemyEnergy = e.getEnergy();
        this.enemyPosition.setLocation(Math.sin(absoluteBearing) * e.getDistance() + this.robot.getX(), Math.cos(absoluteBearing) * e.getDistance() + this.robot.getY());
        this.currentPosition.setLocation(this.robot.getX(), this.robot.getY());
        Iterator<MovementWave> waveIterator = this.movementWaves.iterator();
        MovementWave closestWave = null;
        double closestDistance = 999999.0;
        while (waveIterator.hasNext()) {
            double distanceBetween;
            MovementWave w = waveIterator.next();
            double distanceTravelled = w.getDistance(fireTime);
            if (distanceTravelled > (distanceBetween = this.currentPosition.distance(w.origin)) + 50.0) {
                waveIterator.remove();
                continue;
            }
            double distanceDifference = distanceBetween - distanceTravelled - 50.0;
            if (!(distanceDifference < closestDistance) || !(distanceDifference > 0.0)) continue;
            closestWave = w;
            closestDistance = distanceDifference;
        }
        if (closestWave != null) {
            this.predictedPositions.clear();
            ArrayList<Point2D.Double> positionsBack = this.predictPositions(closestWave, fireTime, -1);
            ArrayList<Point2D.Double> positionsForward = this.predictPositions(closestWave, fireTime, 1);
            this.predictedPositions.add(positionsBack.get(positionsBack.size() - 1));
            this.predictedPositions.add(positionsForward.get(positionsForward.size() - 1));
            double dangerBack = this.getDanger(positionsBack.get(positionsBack.size() - 1), closestWave, -1);
            double dangerForward = this.getDanger(positionsForward.get(positionsForward.size() - 1), closestWave, 1);
            double directAngle = Utils.angleBetweenPoints(closestWave.origin, this.currentPosition);
            double goAngle = dangerBack < dangerForward ? Utils.wallSmoothing(BATTLEFIELD, this.currentPosition, directAngle - 1.5707963267948966, -1) : (dangerBack == dangerForward ? Utils.wallSmoothing(BATTLEFIELD, this.currentPosition, directAngle - 1.5707963267948966, lateralVelocity > 0.0 ? 1 : -1) : Utils.wallSmoothing(BATTLEFIELD, this.currentPosition, directAngle + 1.5707963267948966, 1));
            goAngle = Utils.normalRelativeAngle(goAngle - this.robot.getHeadingRadians());
            if (Math.abs(goAngle) > 1.5707963267948966) {
                if (goAngle < 0.0) {
                    this.robot.setTurnRightRadians(Math.PI + goAngle);
                } else {
                    this.robot.setTurnLeftRadians(Math.PI - goAngle);
                }
                this.robot.setBack(100.0);
            } else {
                this.robot.setTurnRightRadians(goAngle);
                this.robot.setAhead(100.0);
            }
        }
    }

    private ArrayList<Point2D.Double> predictPositions(MovementWave wave, long time, int direction) {
        ArrayList<Point2D.Double> positionList = new ArrayList<Point2D.Double>();
        Point2D.Double predictedPosition = (Point2D.Double)this.currentPosition.clone();
        double heading = this.robot.getHeadingRadians();
        double velocity = this.robot.getVelocity();
        int count = 0;
        boolean hitWave = false;
        do {
            double headingDelta = Utils.wallSmoothing(BATTLEFIELD, predictedPosition, Utils.angleBetweenPoints(wave.origin, predictedPosition) + 1.5707963267948966 * (double)direction, direction) - heading;
            int moveDir = 1;
            if (Math.cos(headingDelta) < 0.0) {
                headingDelta += Math.PI;
                moveDir = -1;
            }
            headingDelta = Utils.normalRelativeAngle(headingDelta);
            double maxTurnRate = Rules.getTurnRate((double)velocity);
            heading = Utils.normalRelativeAngle(heading + Utils.limit(-maxTurnRate, headingDelta, maxTurnRate));
            velocity += (double)(velocity * (double)moveDir < 0.0 ? 2 * moveDir : moveDir);
            velocity = Utils.limit(-8.0, velocity, 8.0);
            predictedPosition = Utils.project(predictedPosition, heading, velocity);
            ++count;
            if (predictedPosition.distance(wave.origin) < wave.getDistance(time + (long)count) + Rules.getBulletSpeed((double)wave.bulletPower)) {
                hitWave = true;
            }
            positionList.add((Point2D.Double)predictedPosition.clone());
        } while (!hitWave && count < 50);
        return positionList;
    }

    private double getDanger(Point2D.Double position, MovementWave wave, int direction) {
        double distance = position.distance(wave.origin);
        double angleRange = Math.tan(36.0 / distance);
        double directAngle = Utils.angleBetweenPoints(wave.origin, position);
        double startAngle = directAngle - wave.headsOnHeading - angleRange / 2.0;
        double endAngle = directAngle - wave.headsOnHeading + angleRange / 2.0;
        double mea = Utils.getMaximumEscapeArea(Rules.getBulletSpeed((double)wave.bulletPower));
        int startBin = Utils.GFToBin(151, startAngle / mea * (double)wave.direction);
        int endBin = Utils.GFToBin(151, endAngle / mea * (double)wave.direction);
        double danger = 0.0;
        if (startBin > endBin) {
            int i = endBin;
            while (i <= startBin) {
                danger += movementStats[i];
                ++i;
            }
        } else {
            int i = startBin;
            while (i <= endBin) {
                danger += movementStats[i];
                ++i;
            }
        }
        return danger;
    }

    private void logEvent(Point2D.Double position, double bulletPower, long time) {
        Iterator<MovementWave> waveIterator = this.movementWaves.iterator();
        while (waveIterator.hasNext()) {
            int endBin;
            MovementWave w = waveIterator.next();
            double distance = position.distance(w.origin);
            if (!(Math.abs(distance - w.getDistance(time)) < 25.0) || !(Math.abs(bulletPower - w.bulletPower) < 0.5)) continue;
            double angleRange = Math.tan(36.0 / distance);
            double directAngle = Utils.angleBetweenPoints(w.origin, position);
            double startAngle = directAngle - w.headsOnHeading - angleRange / 2.0;
            double endAngle = directAngle - w.headsOnHeading + angleRange / 2.0;
            double mea = Utils.getMaximumEscapeArea(Rules.getBulletSpeed((double)w.bulletPower));
            int startBin = Utils.GFToBin(151, startAngle / mea * (double)w.direction);
            if (startBin > (endBin = Utils.GFToBin(151, endAngle / mea * (double)w.direction))) {
                int i = endBin;
                while (i <= startBin) {
                    this.logHit(i);
                    ++i;
                }
            } else {
                int i = startBin;
                while (i <= endBin) {
                    this.logHit(i);
                    ++i;
                }
            }
            waveIterator.remove();
            break;
        }
    }

    private void logHit(int bin) {
        int i = 0;
        while (i < 151) {
            double addAmount = 1.0 / (Math.pow(bin - i, 2.0) + 1.0);
            NewWaveSurfingMovement.movementStats[i] = (movementStats[i] * 99.0 + addAmount) / 100.0;
            ++i;
        }
    }
}

