/*
 * Decompiled with CFR 0.152.
 */
package areb;

import areb.Union;
import areb.Util;

public class EnemyWave {
    private int mDist;
    private int mVel;
    private int mAccel;
    private int bPower;
    private double waveVel;
    private double waveDist;
    private double fireX;
    private double fireY;
    private double myInitX;
    private double myInitY;
    private double myInitBearing;
    private double myInitHeading;
    private double projectedAngle;
    private double[] goalGuess;
    private double waveTime = 0.0;
    private int myDir;
    private static int ID = 0;
    private int waveID = 0;

    public EnemyWave(int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double[] dArray, int n5) {
        this.mDist = n;
        this.mVel = n2;
        this.mAccel = n3;
        this.bPower = n4;
        this.waveVel = d;
        this.fireX = d2;
        this.fireY = d3;
        this.myInitX = d4;
        this.myInitY = d5;
        this.myInitBearing = d6;
        this.myInitHeading = d7;
        this.projectedAngle = d8;
        this.goalGuess = dArray;
        this.myDir = n5;
        this.waveID = ++ID;
    }

    public EnemyWave(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n) {
        this.waveVel = d;
        this.fireX = d2;
        this.fireY = d3;
        this.myInitX = d4;
        this.myInitY = d5;
        this.myInitBearing = d6;
        this.myInitHeading = d7;
        this.projectedAngle = d8;
        this.myDir = n;
        this.waveID = -1;
    }

    public int getMDist() {
        return this.mDist;
    }

    public int getMVel() {
        return this.mVel;
    }

    public int getMAccel() {
        return this.mAccel;
    }

    public int getBPower() {
        return this.bPower;
    }

    public double[] getGoalGuess() {
        return this.goalGuess;
    }

    public double getWaveDist() {
        return this.waveDist;
    }

    public double getFireX() {
        return this.fireX;
    }

    public double getFireY() {
        return this.fireY;
    }

    public double getInitX() {
        return this.myInitX;
    }

    public double getInitY() {
        return this.myInitY;
    }

    public double getWavePower() {
        return (this.waveVel - 20.0) / -3.0;
    }

    public double getWaveVel() {
        return this.waveVel;
    }

    public double getInitHeading() {
        return this.myInitHeading;
    }

    public int getMyDir() {
        return this.myDir;
    }

    public int getWaveID() {
        return this.waveID;
    }

    public double getDistanceFrom(double d, double d2) {
        double d3 = Util.distance(d, d2, this.fireX, this.fireY);
        return d3 - this.waveDist;
    }

    public boolean hasIntersected(double d, double d2) {
        return Util.distance(this.fireX, this.fireY, d, d2) + 18.0 <= this.waveDist;
    }

    public void advanceWave() {
        this.waveDist += this.waveVel;
        this.waveTime += 1.0;
    }

    public void flipDir() {
        this.myDir *= -1;
    }

    public double getAngle(double d, double d2) {
        double d3 = Util.distance(this.fireX, this.fireY, this.myInitX, this.myInitY);
        double d4 = Util.distance(this.fireX, this.fireY, d, d2);
        double d5 = Util.getBearing(this.fireX, this.fireY, d, d2);
        double d6 = Math.abs(Util.getRelativeAngle(this.myInitBearing, d5));
        double d7 = Util.getBearing(this.myInitX, this.myInitY, d, d2);
        double d8 = this.myInitHeading;
        if (this.myDir == -1) {
            d8 = Util.correctLargeAngle(d8 + 180.0);
        }
        double d9 = Math.abs(d6 / this.projectedAngle);
        if (Math.abs(Util.getRelativeAngle(d7, d8)) > 90.0) {
            d9 *= -1.0;
        }
        return d9;
    }

    public double[] getMaximumExtent(double d, double d2, double d3, double d4) {
        double d5 = this.waveDist;
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        double d9 = this.myInitHeading;
        if (this.myDir == -1) {
            d9 = Util.correctLargeAngle(d9 + 180.0);
        }
        double d10 = d4;
        if (d3 < 0.0) {
            d10 = Util.correctLargeAngle(d10 + 180.0);
            d8 *= -1.0;
        }
        double d11 = d10;
        if (Math.abs(Util.getRelativeAngle(d10, d9)) > 90.0) {
            d11 = d10 = Util.correctLargeAngle(d10 + 180.0);
            d8 *= -1.0;
        }
        boolean bl = false;
        double d12 = Math.sin(Math.toRadians(d11));
        double d13 = Math.cos(Math.toRadians(d11));
        double d14 = d8 * d12;
        double d15 = d8 * d13;
        int n = 0;
        while (Util.distance(this.fireX, this.fireY, d6, d7) - 18.0 > d5 && d6 < Union.battleFieldWidth - Union.wallCushion && d6 > Union.wallCushion && d7 < Union.battleFieldHeight - Union.wallCushion && d7 > Union.wallCushion) {
            if (d8 < 8.0) {
                d8 = d8 < 0.0 ? (d8 += 2.0) : (d8 += 1.0);
                d14 = d8 * d12;
                d15 = d8 * d13;
            }
            d6 += d14;
            d7 += d15;
            d5 += this.waveVel;
            if (++n <= 100) continue;
            System.out.println("RED ALERT!!! " + d14 + "," + d15 + ", " + this.waveVel + ", " + d5);
            break;
        }
        double[] dArray = new double[]{this.getAngle(d6, d7), Util.distance(d, d2, d6, d7)};
        return dArray;
    }

    public double[] getMinimumExtent(double d, double d2, double d3, double d4) {
        double d5 = this.waveDist;
        double d6 = d;
        double d7 = d2;
        double d8 = d3;
        double d9 = this.myInitHeading;
        if (this.myDir == -1) {
            d9 = Util.correctLargeAngle(d9 + 180.0);
        }
        double d10 = d4;
        if (d3 < 0.0) {
            d10 = Util.correctLargeAngle(d10 + 180.0);
            d8 *= -1.0;
        }
        double d11 = d10;
        if (Math.abs(Util.getRelativeAngle(d10, d9)) < 90.0) {
            d11 = d10 = Util.correctLargeAngle(d10 + 180.0);
            d8 *= -1.0;
        }
        boolean bl = false;
        double d12 = Math.sin(Math.toRadians(d11));
        double d13 = Math.cos(Math.toRadians(d11));
        double d14 = d8 * d12;
        double d15 = d8 * d13;
        int n = 0;
        while (Util.distance(this.fireX, this.fireY, d6, d7) - 18.0 > d5 && d6 < Union.battleFieldWidth - Union.wallCushion && d6 > Union.wallCushion && d7 < Union.battleFieldHeight - Union.wallCushion && d7 > Union.wallCushion) {
            if (d8 < 8.0) {
                d8 = d8 < 0.0 ? (d8 += 2.0) : (d8 += 1.0);
                d14 = d8 * d12;
                d15 = d8 * d13;
            }
            d6 += d14;
            d7 += d15;
            d5 += this.waveVel;
            if (++n <= 100) continue;
            System.out.println("RED ALERT!!! " + d14 + "," + d15 + ", " + d6 + ", " + d7 + ", " + this.waveVel + ", " + d5);
            break;
        }
        double[] dArray = new double[]{this.getAngle(d6, d7), Util.distance(d, d2, d6, d7)};
        return dArray;
    }
}

