/*
 * Decompiled with CFR 0.152.
 */
package jcz.linio.util;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class LUtils {
    public static double decelDistance(double vel) {
        int intVel = (int)Math.ceil(vel);
        switch (intVel) {
            case 8: {
                return 12.0;
            }
            case 7: {
                return 9.0;
            }
            case 6: {
                return 6.0;
            }
            case 5: {
                return 4.0;
            }
            case 4: {
                return 2.0;
            }
            case 3: {
                return 1.0;
            }
            case 0: 
            case 1: 
            case 2: {
                return 0.0;
            }
        }
        return 12.0;
    }

    public static int getIndex(double[] slices, double value) {
        int index = 0;
        while (index < slices.length && value >= slices[index]) {
            ++index;
        }
        return index;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public static int sqr(int x) {
        return x * x;
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static double angle(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }
}

