/*
 * Decompiled with CFR 0.152.
 */
package nic;

import java.util.Enumeration;
import nic.Enemy;
import nic.GravPoint;
import nic.MovementStrategy;
import nic.Nicator;

public class AntiGravityMove
implements MovementStrategy {
    Nicator rob;
    double midpointstrength = 0.0;
    int midpointcount = 0;

    public AntiGravityMove(Nicator pRob) {
        this.rob = pRob;
    }

    public double goodness() {
        return 1.0;
    }

    public void maintenance() {
    }

    public boolean subjectToVA() {
        return true;
    }

    public void move() {
        double xforce = 0.0;
        double yforce = 0.0;
        Enumeration e = this.rob.targets.elements();
        while (e.hasMoreElements()) {
            Enemy en = (Enemy)e.nextElement();
            if (!en.live) continue;
            GravPoint p = new GravPoint(en.x, en.y, -1000.0);
            double force = p.power / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), p.x, p.y), 2.0);
            double ang = this.rob.hf.normaliseBearing(1.5707963267948966 - Math.atan2(this.rob.getY() - p.y, this.rob.getX() - p.x));
            xforce += Math.sin(ang) * force;
            yforce += Math.cos(ang) * force;
        }
        xforce += 5000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), this.rob.getBattleFieldWidth(), this.rob.getY()), 3.0);
        yforce += 5000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), this.rob.getX(), this.rob.getBattleFieldHeight()), 3.0);
        this.rob.mm.goTo(this.rob.getX() - (xforce -= 5000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), 0.0, this.rob.getY()), 3.0)), this.rob.getY() - (yforce -= 5000.0 / Math.pow(this.rob.hf.getRange(this.rob.getX(), this.rob.getY(), this.rob.getX(), 0.0), 3.0)));
    }
}

