/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.connection.Connection;
import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.FractionStat;
import dmonner.xlbp.stat.MeanVarStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class ConnectionStat
extends AbstractStat {
    private final MeanVarStat weights = new MeanVarStat("Weights");
    private final FractionStat connections = new FractionStat("Connections");

    public ConnectionStat() {
    }

    public ConnectionStat(Connection conn) {
        this();
        float[][] w;
        float[][] arr$ = w = conn.toMatrix();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            float[] row;
            for (float wt : row = arr$[i$]) {
                this.weights.add(Math.abs(wt));
            }
        }
        this.connections.add(conn.nWeights(), conn.nWeightsPossible());
        this.analyze();
    }

    public void add(ConnectionStat that) {
        this.weights.add(that.weights);
        this.connections.add(that.connections);
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof ConnectionStat)) {
            throw new IllegalArgumentException("Can only add in ConnectionStats.");
        }
        this.add((ConnectionStat)that);
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        this.weights.addTo(prefix, map);
        this.connections.addTo(prefix, map);
    }

    @Override
    public void analyze() {
        this.weights.analyze();
        this.connections.analyze();
    }

    @Override
    public void clear() {
        this.weights.clear();
        this.connections.clear();
    }

    public FractionStat getConnections() {
        return this.connections;
    }

    public MeanVarStat getWeights() {
        return this.weights;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        this.weights.saveData(out);
        this.connections.saveData(out);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        this.weights.saveHeader(prefix, out);
        this.connections.saveHeader(prefix, out);
    }

    @Override
    public String toString(String prefix) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.weights.toString(prefix));
        sb.append(this.connections.toString(prefix));
        return sb.toString();
    }
}

