/*
 * Decompiled with CFR 0.152.
 */
package zezinho;

import dmonner.xlbp.Network;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.compound.InputCompound;
import dmonner.xlbp.compound.MemoryCellCompound;
import dmonner.xlbp.compound.XEntropyTargetCompound;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;
import zezinho.CircularQueueArray;
import zezinho.Moviment.Movement;
import zezinho.Moviment.State;
import zezinho.virtualGuns.Averager;
import zezinho.virtualGuns.VirtualBullet;
import zezinho.virtualGuns.VirtualGun;

public class QuerMePegarKKKK
extends AdvancedRobot {
    final int HIST_SIZE = 5;
    int NUM_FEATURES = 0;
    final int LOOK_AHEAD_NUM_STEPS = 60;
    final int LOOK_AHEAD_STEP = 1;
    double bulletPower = 2.0;
    double aimDelta;
    int fired;
    static double fieldXMid;
    static double fieldYMid;
    final boolean INCLUDE_FIRED = true;
    final boolean INCLUDE_DISTANCE = true;
    final boolean INCLUDE_HEADING = true;
    final boolean INCLUDE_BEARING = true;
    final boolean INCLUDE_VELOCITY = true;
    final boolean INCLUDE_WALLDISTANCE = false;
    final boolean INCLUDE_LOCATION = false;
    final boolean INCLUDE_LOCATION_DIFF = false;
    static int bulletHits;
    static int bulletMisses;
    static int bulletFired;
    int victories = 0;
    int losts = 0;
    static Network neural_network;
    public int enemyDirection = 1;
    public double direction = 1.0;
    public static double _oppEnergy;
    EnemyData targetEnemy;
    ArrayList<EnemyData> enemies = new ArrayList();
    double MAX_GUESSFACTOR = 1.0;
    double MAX_ENERGY = 100.0;
    double MAX_DISTANCE;
    double MAX_BEARING = 360.0;
    double MAX_HEADING = 360.0;
    double MAX_VELOCITY = 8.0;
    double MAX_TIME = 2000.0;
    double MAX_POSITION_VARIATION = 8.0;
    double MAX_BULLET_POWER = 3.0;
    double expectedNeuralNetOutput;
    static String botname;
    State state = new State();
    Movement mov = new Movement(this.state);
    static final int NUMBERGUNS = 3;
    static int currGun;
    static VirtualGun[] virtGunsRay;
    long fireTime = 0L;
    final boolean USE_RAMMING = true;
    int lastBulletWhenRammed;
    int bulletOnUs = 0;
    int timeSinceShot = 0;
    boolean isTrueRamming = false;
    static Averager ramming_avg;
    final boolean USE_CIRCULAR_TARGETING = true;
    double oldEnemyHeading = 0.0;
    final boolean USE_PATTERN_MATCH = true;
    static final int GUN_BINS = 230;
    static final int MAX_MATCHES = 50;
    public static int pattenNumber;
    static StringBuilder gunData;
    static double lastLatVel;
    final boolean USE_BULLET_SHIELD = true;
    private double[][] aimAngles = new double[3][127];
    private int unknownShots;
    private double enemyLastEnergy;
    private static Point2D.Double enemyLastLocation;
    private static Point2D.Double enemySecondLastLocation;
    private double enemyLastAbsoluteBearing;
    private double btPower;
    private double turnAngle;
    private int ticker;
    private double gunAngle;
    private int timeSinceFire;
    private double enemySecondLastAbsoluteBearing;
    private static double btMoveAhead;
    private int moveDirection = 240;
    private static int lastELatV;
    private int aim;
    private int[][][][][][] aimFactors = new int[5][9][9][5][2][25];
    private int timeSinceDeccel;
    private boolean failLock;
    static Averager bullet_avg;
    static boolean canIDoWithoutBulletShield;
    private boolean voluntaryUnlock;
    private double bearingDirection;
    private double enemySecondLastHeading;
    private double enemyLastHeading;
    private double enemySecondLastVelocity;
    private static double enemyLastVelocity;

    void initRound() {
        this.mov.oppWaves.clear();
        this.mov.surfDirections.clear();
        this.mov.surfAbsBearings.clear();
    }

    public void run() {
        this.InitializeBot();
        if (bullet_avg.recordedEntries() > 0 && bullet_avg.recentAverage() < 10.0 || canIDoWithoutBulletShield) {
            this.failLock = true;
            System.err.println("Not using bullet shield !");
            System.err.println("I will not do bullet shield with average:" + bullet_avg.recentAverage());
        } else {
            this.failLock = false;
            System.err.println("I will do bullet shield with average:" + bullet_avg.recentAverage());
        }
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        while (true) {
            if (this.getRadarTurnRemainingRadians() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            this.scan();
            this.execute();
        }
    }

    private void InitializeBot() {
        this.MAX_DISTANCE = this.getBattleFieldWidth();
        if (ramming_avg == null) {
            ramming_avg = new Averager(6);
            ramming_avg.addEntry(1.1);
        }
        if (bullet_avg == null) {
            bullet_avg = new Averager(6);
            bullet_avg.addEntry(15.0);
        }
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        if (virtGunsRay == null) {
            VirtualGun.initialize(10, this.getBattleFieldWidth(), this.getBattleFieldHeight());
            virtGunsRay = new VirtualGun[3];
            QuerMePegarKKKK.virtGunsRay[0] = new VirtualGun();
            QuerMePegarKKKK.virtGunsRay[1] = new VirtualGun();
            QuerMePegarKKKK.virtGunsRay[2] = new VirtualGun();
        }
        ++this.NUM_FEATURES;
        ++this.NUM_FEATURES;
        ++this.NUM_FEATURES;
        ++this.NUM_FEATURES;
        ++this.NUM_FEATURES;
        this.fired = 0;
        fieldYMid = this.getBattleFieldHeight() / 2.0;
        fieldXMid = this.getBattleFieldWidth() / 2.0;
        this.InitializeNeuralNet(false);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double predictedY;
        double predictedX;
        boolean isRamming;
        double surfAngle;
        block27: {
            EnemyData enemy;
            botname = this.getBotClass(e.getName());
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians() - this.getRadarHeadingRadians())) * 1.9);
            this.targetEnemy = enemy = this.FindEnemy(e.getName());
            enemy.bearing = e.getBearing();
            enemy.bearingRads = e.getBearingRadians();
            enemy.absBearing = this.getHeadingRadians() + e.getBearingRadians();
            enemy.distance = e.getDistance();
            enemy.energy = e.getEnergy();
            enemy.heading = e.getHeading();
            enemy.velocity = e.getVelocity();
            enemy.scanTime = e.getTime();
            double absBearing = e.getBearingRadians() + this.getHeadingRadians();
            enemy.location = new Point2D.Double(this.getX() + e.getDistance() * Math.sin(absBearing), this.getY() + e.getDistance() * Math.cos(absBearing));
            HistoricalData data = new HistoricalData();
            data.distance = e.getDistance();
            data.heading = e.getHeading();
            data.headingRad = e.getHeadingRadians();
            data.velocity = e.getVelocity();
            data.location = enemy.location;
            data.fired = this.fired;
            data.myLocation = new Point2D.Double(this.getX(), this.getY());
            data.processed = false;
            data.bearing = e.getBearing();
            this.fired = 0;
            HistoricalData previous = enemy.historicalData.getLastInserted();
            if (previous == null || enemy.historicalData.isEmpty()) {
                data.xDiff = 0.0;
                data.yDiff = 0.0;
            } else {
                data.xDiff = (double)Math.round((data.location.getX() - previous.location.getX()) * 100.0) / 100.0;
                data.yDiff = (double)Math.round((data.location.getY() - previous.location.getY()) * 100.0) / 100.0;
            }
            if (e.getVelocity() != 0.0) {
                this.direction = Math.sin(e.getHeadingRadians() - absBearing) * e.getVelocity() < 0.0 ? -1.0 : 1.0;
            }
            double cornerX = enemy.location.getX() > fieldXMid ? this.getBattleFieldWidth() : 0.0;
            double cornerY = enemy.location.getY() > fieldYMid ? this.getBattleFieldHeight() : 0.0;
            data.wallDistanceTopBottom = enemy.location.getX() - cornerX;
            data.wallDistanceSides = enemy.location.getY() - cornerY;
            this.processBulletPower();
            data.myBulletPower = this.bulletPower;
            while (enemy.historicalData.size() >= 65) {
                enemy.historicalData.dequeue();
            }
            enemy.historicalData.enqueue(data);
            this.state.updateState(this, e);
            surfAngle = this.mov.onScannedRobot(false);
            _oppEnergy = e.getEnergy();
            this.TrainNeuralNet();
            double bestHitSum = 0.0;
            int bestGun = 0;
            for (int i = 0; i < virtGunsRay.length; ++i) {
                if (!(virtGunsRay[i].getHitRate() > bestHitSum)) continue;
                bestHitSum = virtGunsRay[i].getHitRate();
                bestGun = i;
            }
            if (currGun != bestGun) {
                String gun = null;
                if (bestGun == 0) {
                    gun = "Circular";
                } else if (bestGun == 1) {
                    gun = "Pattern";
                } else if (bestGun == 2) {
                    gun = "ANN";
                }
                if (currGun < 3) {
                    System.err.println("I'm switching gun to: " + gun);
                }
                currGun = bestGun;
            }
            if (this.fireTime == this.getTime() && this.getGunTurnRemaining() == 0.0 && e.getEnergy() > QuerMePegarKKKK.calcBulletDamage(this.bulletPower)) {
                this.setFire(this.bulletPower);
                this.fired = 1;
                ++bulletFired;
            }
            if (isRamming = this.Ramming(e)) {
                if (e.getDistance() < 50.0) {
                    currGun = 4;
                }
            } else if (!this.failLock) {
                currGun = 3;
            }
            double myX = this.getX();
            double myY = this.getY();
            double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
            double enemyX = this.getX() + e.getDistance() * Math.sin(absoluteBearing);
            double enemyY = this.getY() + e.getDistance() * Math.cos(absoluteBearing);
            double enemyHeading = e.getHeadingRadians();
            double enemyHeadingChange = enemyHeading - this.oldEnemyHeading;
            double enemyVelocity = e.getVelocity();
            this.oldEnemyHeading = enemyHeading;
            double deltaTime = 0.0;
            double battleFieldHeight = this.getBattleFieldHeight();
            double battleFieldWidth = this.getBattleFieldWidth();
            predictedX = enemyX;
            predictedY = enemyY;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * (20.0 - 3.0 * this.bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY))) break block27;
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getX(), predictedY - this.getY()));
        if (currGun == 0) {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        }
        if (this.getGunHeat() == 0.0 && this.getEnergy() > this.bulletPower) {
            if (currGun == 0) {
                this.fireTime = this.getTime() + 1L;
                ++bulletFired;
            }
            virtGunsRay[0].fire(this.bulletPower, Utils.normalRelativeAngle((double)theta));
        }
        double absBearingPattern = e.getBearingRadians();
        double latVel = this.getVelocity() * Math.sin(absBearingPattern);
        double eDistance = e.getDistance();
        ++pattenNumber;
        latVel = e.getHeadingRadians() - (absBearingPattern += this.getHeadingRadians());
        gunData.insert(0, (char)((int)Math.round(e.getVelocity() * Math.sin(latVel)) << 8 | 0xFF & (byte)(e.getVelocity() * Math.cos(latVel))));
        if (currGun == 1) {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearingPattern + 0.005 + QuerMePegarKKKK.getGunAngle(Math.min(66, Math.min(gunData.length(), pattenNumber)), eDistance, this.bulletPower) - this.getGunHeadingRadians())));
        }
        if (this.getGunHeat() == 0.0 && this.getEnergy() > this.bulletPower) {
            if (currGun == 1) {
                this.fireTime = this.getTime() + 1L;
            }
            virtGunsRay[1].fire(this.bulletPower, absBearingPattern + 0.005 + QuerMePegarKKKK.getGunAngle(Math.min(66, Math.min(gunData.length(), pattenNumber)), eDistance, this.bulletPower));
        }
        this.BulletFire();
        Rectangle2D.Double botRect = new Rectangle2D.Double(this.targetEnemy.location.getX() - 18.0, this.targetEnemy.location.getY() - 18.0, 36.0, 36.0);
        for (int i = 0; i < virtGunsRay.length; ++i) {
            virtGunsRay[i].nextTurn(botRect, this.getX(), this.getY());
        }
        if (currGun == 3) {
            this.BulletShield(e);
            return;
        }
        if (!isRamming && this.mov.surfWave != null) {
            Movement.setTurnTo(this, surfAngle);
        }
    }

    public static double getGunAngle(int keyLength, double distance, double bulletPower) {
        int indexSize = 0;
        int[] index = new int[50];
        int tempIndex = 0;
        int[] bins = new int[230];
        while (true) {
            char comboChar;
            double d;
            if (tempIndex < 0) {
                keyLength = keyLength * 3 / 4;
            }
            if (((tempIndex = gunData.indexOf(gunData.substring(0, keyLength), tempIndex + 2)) < 0 || Arrays.binarySearch(index, tempIndex) >= 0) && keyLength > 0) continue;
            if (keyLength == 0) break;
            int iterateIndex = index[0] = tempIndex;
            Arrays.sort(index);
            double tempDist = distance;
            double absBearing = 0.0;
            double db = 0.0;
            do {
                comboChar = gunData.charAt(iterateIndex--);
                absBearing += (double)((byte)(comboChar >> 8)) / tempDist;
                db += Rules.getBulletSpeed((double)bulletPower);
            } while (d < (tempDist += (double)((byte)(comboChar & 0xFF))) && iterateIndex > 0);
            int n = (int)(Utils.normalAbsoluteAngle((double)absBearing) * 36.44648196804403);
            bins[n] = bins[n] + keyLength;
            if (++indexSize >= 50) break;
        }
        keyLength = 229;
        tempIndex = 0;
        do {
            if (bins[keyLength] <= bins[tempIndex]) continue;
            tempIndex = keyLength;
        } while (keyLength-- > 0);
        return (double)tempIndex * 0.027437490424365007;
    }

    boolean Ramming(ScannedRobotEvent e) {
        double bulletPowerSurf = _oppEnergy - e.getEnergy();
        if (bulletPowerSurf < 0.09) {
            ++this.timeSinceShot;
        } else if (bulletPowerSurf < 3.01 && bulletPowerSurf > 0.09) {
            this.timeSinceShot = 0;
        }
        boolean willRam = false;
        if (!this.failLock && this.timeSinceShot > 300) {
            willRam = true;
        }
        if (!this.failLock && this.timeSinceShot > 250) {
            willRam = true;
        }
        if (this.failLock && this.timeSinceShot > 200) {
            willRam = true;
        }
        if (e.getEnergy() < 2.0 && this.getEnergy() > 5.0) {
            willRam = true;
        }
        if (e.getEnergy() < 0.2 && this.getEnergy() > 1.0) {
            willRam = true;
        }
        if (e.getEnergy() <= 0.0) {
            willRam = true;
        }
        if (this.getEnergy() - e.getEnergy() > 60.0) {
            willRam = true;
        }
        if (ramming_avg.recentAverage() > 0.5) {
            willRam = true;
            this.isTrueRamming = true;
        }
        if (!willRam) {
            return false;
        }
        if (!this.failLock) {
            this.failLock = true;
            System.err.println("I'm volluntary unlocking bullet shield");
            bullet_avg.addEntry(this.getEnergy() - e.getEnergy());
        }
        double headOnAngle = this.getHeadingRadians() + e.getBearingRadians();
        double linearAngle = headOnAngle + Math.asin(e.getVelocity() / Rules.getBulletSpeed((double)this.bulletPower) * Math.sin(e.getHeadingRadians() - headOnAngle));
        if (e.getDistance() < 50.0) {
            this.setFire(this.MAX_BULLET_POWER);
            this.fireTime = this.getTime() - 1L;
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(linearAngle - this.getGunHeadingRadians())));
        }
        double turn = linearAngle - this.getHeadingRadians();
        this.setAhead(Double.POSITIVE_INFINITY);
        if (Math.cos(turn) < 0.0) {
            turn -= Math.PI;
            this.setAhead(Double.NEGATIVE_INFINITY);
        }
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)turn));
        if (e.getDistance() > 50.0) {
            double surfAngle = this.mov.onScannedRobot(true);
            if (this.mov.surfWave != null) {
                double angCorrect = surfAngle;
                Movement.setTurnTo(this, angCorrect);
            }
        }
        this.lastBulletWhenRammed = this.bulletOnUs;
        return true;
    }

    public static double calcBulletDamage(double firepower) {
        return 4.0 * firepower + (firepower > 1.0 ? 2.0 * (firepower - 1.0) : 0.0);
    }

    void processBulletPower() {
        int shottedBullets = Math.max(1, bulletFired - 4);
        double ratio = (double)(bulletHits + 2) / (double)(bulletMisses + shottedBullets);
        this.bulletPower = 1.999;
        int minDist = (int)this.targetEnemy.distance;
        if (minDist < 250) {
            this.bulletPower = 2.499;
        }
        if (minDist < 150) {
            this.bulletPower = 2.999;
        }
        if (minDist > 700) {
            this.bulletPower = 1.499;
        }
        if (this.getEnergy() < this.targetEnemy.energy - 5.0 && this.getEnergy() < 25.0 && minDist > 400) {
            this.bulletPower = Math.min(this.bulletPower, 2.0 - (25.0 - this.getEnergy()) / 11.0);
        } else if (this.getEnergy() < 25.0 && minDist > 250) {
            this.bulletPower = Math.min(this.bulletPower, 2.0 - (25.0 - this.getEnergy()) / 12.0);
        }
        this.bulletPower = Math.min(this.bulletPower, this.targetEnemy.energy / 6.0);
        this.bulletPower = Math.min(this.bulletPower, this.getEnergy());
        this.bulletPower = Math.min(this.bulletPower, 3.0);
        this.bulletPower = Math.max(this.bulletPower, 0.1);
    }

    static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    private EnemyData FindEnemy(String enemyName) {
        EnemyData enemy = null;
        for (int enemyIndex = 0; enemyIndex < this.enemies.size(); ++enemyIndex) {
            enemy = this.enemies.get(enemyIndex);
            if (enemy.name == null ? enemyName == null : enemy.name.equals(enemyName)) break;
        }
        if (enemy == null) {
            enemy = new EnemyData();
            this.enemies.add(enemy);
        }
        return enemy;
    }

    private Point2D GetAbsolutePosition(double bearing, double distance) {
        Point2D.Double myLocation = new Point2D.Double(this.getX(), this.getY());
        double myHeading = this.getHeading();
        double absoluteBearing = myHeading + bearing;
        Point2D.Double result = new Point2D.Double(((Point2D)myLocation).getX() + Math.sin(Math.toRadians(absoluteBearing)) * distance, ((Point2D)myLocation).getY() + Math.cos(Math.toRadians(absoluteBearing)) * distance);
        return result;
    }

    double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return bearing;
    }

    double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    private static double NormalRelativeAngle(double angle) {
        return (angle + Math.PI * 5) % (Math.PI * 2) - Math.PI;
    }

    private float GetNormalizedValueForNN(double value, double max) {
        return this.GetNormalizedValueForNN(value, max, 0.0);
    }

    private float GetReversedNormalizedValue(double value, double max) {
        return this.GetReversedNormalizedValue(value, max, 0.0);
    }

    private float GetNormalizedValueForNN(double value, double max, double min) {
        float result = (float)((value - min) / (max - min));
        if (result < 0.0f) {
            result = 0.0f;
        } else if (result > 1.0f) {
            result = 1.0f;
        }
        return result;
    }

    private float GetReversedNormalizedValue(double value, double max, double min) {
        return (float)(min + value * (max - min));
    }

    public static double getBulletTravelTime(double distanceToEnemy, double bulletPower) {
        return Math.ceil(distanceToEnemy / (20.0 - 3.0 * bulletPower));
    }

    private double Aim() {
        double headsonBearing = this.absoluteBearing(this.getX(), this.getY(), this.targetEnemy.location.getX(), this.targetEnemy.location.getY());
        double prediction = this.GetReversedNormalizedValue(this.GetNeuralNetPrediction(), this.MAX_GUESSFACTOR, -this.MAX_GUESSFACTOR);
        double turnAng = this.normalizeBearing(headsonBearing + prediction - this.getGunHeading());
        double guessfactor = prediction;
        double angleOffset = this.direction * guessfactor * QuerMePegarKKKK.maxEscapeAngle(this.getBulletSpeed(this.bulletPower));
        double gunAdjust = Utils.normalRelativeAngle((double)(this.targetEnemy.absBearing - this.getGunHeadingRadians() + angleOffset));
        return gunAdjust;
    }

    private void BulletFire() {
        this.aimDelta = this.Aim();
        if (currGun == 2) {
            this.setTurnGunRightRadians(this.aimDelta);
        }
        if (this.getGunHeat() == 0.0 && this.getEnergy() > this.bulletPower) {
            if (currGun == 2) {
                this.fireTime = this.getTime() + 1L;
            }
            virtGunsRay[2].fire(this.bulletPower, Utils.normalRelativeAngle((double)(this.aimDelta + this.getGunHeadingRadians())));
        }
    }

    private void InitializeNeuralNet(boolean force) {
        if (neural_network != null) {
            return;
        }
        int memSize = 10;
        String memType = "IO";
        neural_network = new Network("SeqParityNet");
        neural_network.setWeightUpdaterType(WeightUpdaterType.basic(0.7f));
        InputCompound bit = new InputCompound("Bit", 5 * this.NUM_FEATURES);
        MemoryCellCompound mem = new MemoryCellCompound("Mem", 10, "IO");
        XEntropyTargetCompound ans = new XEntropyTargetCompound("Ans", 1);
        ans.addUpstreamWeights(mem);
        mem.addUpstreamWeights(bit);
        neural_network.add(bit);
        neural_network.add(mem);
        neural_network.add(ans);
        neural_network.optimize();
        neural_network.build();
    }

    public void onWin(WinEvent event) {
        ++this.victories;
        double ratio = (double)(bulletHits + 2) / (double)(bulletMisses + bulletFired);
        System.err.println("Bullet hit: " + bulletHits + " Bullet Missses: " + bulletMisses + " Ratio: " + ratio);
        if (this.isTrueRamming) {
            ramming_avg.addEntry(1.0);
        }
    }

    public void onDeath(DeathEvent e) {
        ++this.losts;
        double ratio = (double)(bulletHits + 2) / (double)(bulletMisses + bulletFired);
        System.err.println("Bullet hit: " + bulletHits + " Bullet Missses: " + bulletMisses + " Ratio: " + ratio);
        if (this.isTrueRamming) {
            ramming_avg.addEntry(0.0);
        } else if (canIDoWithoutBulletShield) {
            canIDoWithoutBulletShield = false;
            System.err.println("I cant do without bullet shield");
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ++bulletHits;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.mov.onBulletHitBullet(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        ++bulletMisses;
    }

    public double getBulletSpeed(double power) {
        return 20.0 - power * 3.0;
    }

    private Training getSimulations() {
        int size = this.targetEnemy.historicalData.size();
        Training train = new Training();
        train.input = null;
        train.output = null;
        for (int index = 0; index < size; ++index) {
            HistoricalData predicted;
            HistoricalData actual = this.targetEnemy.historicalData.get(index);
            double distanceTraveled = 0.0;
            if (index - 5 < 0 || actual.processed.booleanValue()) continue;
            int bestPos = index;
            boolean found = false;
            for (int k = index; k < size; ++k) {
                predicted = this.targetEnemy.historicalData.get(k);
                Point2D location = predicted.location;
                if (!(actual.myLocation.distance(location) <= (double)(k - index) * this.getBulletSpeed(this.bulletPower))) continue;
                bestPos = k;
                found = true;
                break;
            }
            if (!found) continue;
            int futurePos = bestPos;
            predicted = this.targetEnemy.historicalData.get(futurePos);
            double desiredDirection = Math.atan2(predicted.location.getX() - actual.myLocation.getX(), predicted.location.getY() - actual.myLocation.getY());
            double startBearing = Math.atan2(actual.location.getX() - actual.myLocation.getX(), actual.location.getY() - actual.myLocation.getY());
            double angleOffset = Utils.normalRelativeAngle((double)(desiredDirection - startBearing));
            double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / QuerMePegarKKKK.maxEscapeAngle(this.getBulletSpeed(actual.myBulletPower)))) * this.direction;
            train.input = new float[5 * this.NUM_FEATURES];
            train.output = new float[1];
            for (int i = 0; i < 5; ++i) {
                int num = 0;
                train.input[i * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)(index - i)).fired, 1.0);
                train.input[i * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)(index - i)).distance, this.MAX_DISTANCE);
                train.input[i * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)(index - i)).heading, this.MAX_HEADING);
                train.input[i * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)(index - i)).velocity, this.MAX_VELOCITY);
                train.input[i * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)(index - i)).bearing, 180.0, -180.0);
            }
            actual.processed = true;
            train.output[0] = this.GetNormalizedValueForNN(guessFactor, this.MAX_GUESSFACTOR, -this.MAX_GUESSFACTOR);
            return train;
        }
        return train;
    }

    private void TrainNeuralNet() {
        Training train = this.getSimulations();
        while (train.input != null) {
            neural_network.getInputLayer().setInput(train.input);
            neural_network.activateTrain();
            neural_network.updateEligibilities();
            neural_network.getTargetLayer().setTarget(train.output);
            neural_network.updateResponsibilities();
            neural_network.updateWeights();
            train = this.getSimulations();
        }
    }

    private float GetNeuralNetPrediction() {
        float answer = 0.0f;
        float[] input_dlb = this.CreateInputArray(true);
        neural_network.getInputLayer().setInput(input_dlb);
        neural_network.activateTest();
        answer = neural_network.getTargetLayer().getActivations()[0];
        return answer;
    }

    private float[] CreateInputArray(boolean present) {
        float[] input = new float[5 * this.NUM_FEATURES];
        int featSize = present ? this.targetEnemy.historicalData.size() : this.targetEnemy.historicalData.size() - 60;
        int start = 0;
        if (featSize > 5) {
            start = featSize - 5;
        }
        for (int i = start; i < featSize; ++i) {
            int num = 0;
            input[(i - start) * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)i).fired, 1.0);
            input[(i - start) * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)i).distance, this.MAX_DISTANCE);
            input[(i - start) * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)i).heading, this.MAX_HEADING);
            input[(i - start) * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)i).velocity, this.MAX_VELOCITY);
            input[(i - start) * this.NUM_FEATURES + num++] = this.GetNormalizedValueForNN(this.targetEnemy.historicalData.get((int)i).bearing, 180.0, -180.0);
        }
        return input;
    }

    private String getBotClass(String name) {
        String n = name;
        int low = name.indexOf(" ");
        if (low >= 0) {
            n = name.substring(0, low);
        }
        return n;
    }

    public void onPaint(Graphics2D g) {
        for (int i = 0; i < virtGunsRay.length; ++i) {
            Vector currActiveBullets = virtGunsRay[i].getActiveBullets();
            if (i == 0) {
                g.setColor(new Color(0, 200, 0));
            } else if (i == 1) {
                g.setColor(new Color(200, 0, 0));
            } else {
                g.setColor(new Color(200, 0, 200));
            }
            for (int j = 0; j < currActiveBullets.size(); ++j) {
                VirtualBullet currActiveBullet = (VirtualBullet)currActiveBullets.get(j);
                g.drawOval((int)(currActiveBullet.getX() - 5.0), (int)(currActiveBullet.getY() - 5.0), 10, 10);
            }
        }
        g.setColor(Color.blue);
    }

    public void processHitByBulletForBulletShield(HitByBulletEvent e) {
        this.timeSinceShot = 0;
        if (!this.failLock) {
            if (++this.unknownShots >= 2) {
                this.failLock = true;
                bullet_avg.addEntry(this.getEnergy() - _oppEnergy);
            }
            boolean flag = this.isNearHeadingRadians(this.aimAngles[1], e);
            boolean flag1 = this.isNearHeadingRadians(this.aimAngles[2], e);
            if (this.isNearHeadingRadians(this.aimAngles[0], e)) {
                if (!flag && !flag1) {
                    this.aim = 0;
                    return;
                }
            } else if (flag) {
                if (this.aim != 2) {
                    this.aim = 1;
                    return;
                }
            } else {
                if (flag1) {
                    this.aim = 2;
                    return;
                }
                if (this.getRoundNum() > 5 && ++this.unknownShots % 5 == 0) {
                    this.failLock = true;
                    bullet_avg.addEntry(this.getEnergy() - _oppEnergy);
                }
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.processHitByBulletForBulletShield(e);
        this.mov.onHitByBullet(e);
        ++this.bulletOnUs;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void BulletShield(ScannedRobotEvent paramScannedRobotEvent) {
        double d4;
        double d2;
        Point2D.Double localDouble1;
        Wave localWave = new Wave();
        this.addCustomEvent(localWave);
        Point2D.Double localDouble2 = new Point2D.Double();
        try {
            localDouble2 = QuerMePegarKKKK.project(enemySecondLastLocation, this.enemySecondLastHeading, this.enemySecondLastVelocity);
        }
        catch (Exception localException1) {
            // empty catch block
        }
        Point2D.Double localDouble3 = enemySecondLastLocation = enemyLastLocation;
        localWave.wGunLocation = localDouble1 = new Point2D.Double(this.getX(), this.getY());
        localWave.wBearing = d2 = paramScannedRobotEvent.getBearingRadians() + this.getHeadingRadians();
        double d1 = paramScannedRobotEvent.getDistance();
        enemyLastLocation = QuerMePegarKKKK.project(localDouble1, d2, d1);
        this.enemySecondLastVelocity = enemyLastVelocity;
        enemyLastVelocity = paramScannedRobotEvent.getVelocity();
        double d3 = enemyLastVelocity * Math.sin(paramScannedRobotEvent.getHeadingRadians() - d2);
        if (d3 != 0.0) {
            this.bearingDirection = Math.copySign(0.05791666666666667, d3);
        }
        int[][][][] nArray = this.aimFactors[(int)(d1 / 191.0)][lastELatV];
        lastELatV = Math.abs((int)d3);
        localWave.wAimFactors = nArray[lastELatV][Math.min(4, this.timeSinceDeccel++ / 11)][1];
        int[] arrayOfInt = localWave.wAimFactors;
        int i = --this.ticker;
        if (this.ticker <= -5) {
            this.gunAngle = d2;
            this.turnAngle = d2 + 3.0;
            ++this.timeSinceFire;
        }
        if (i == 1) {
            this.setFire(this.btPower);
        }
        if (i == 0) {
            this.setAhead(-btMoveAhead);
        }
        double d5 = d4 = this.enemySecondLastAbsoluteBearing + Math.PI;
        double d6 = d4 + this.enemyLastHeading - this.enemySecondLastHeading;
        i = this.aim;
        if (i == 1) {
            d5 = d6;
        }
        double d7 = QuerMePegarKKKK.absoluteBearing(localDouble2, localDouble1);
        if (i == 2) {
            d5 = d7;
        }
        this.enemySecondLastHeading = this.enemyLastHeading;
        this.enemyLastHeading = paramScannedRobotEvent.getHeadingRadians();
        double d8 = paramScannedRobotEvent.getEnergy();
        double d9 = Math.min(this.getEnergy() / 16.0, Math.min(d8 / 5.0, 2.0));
        localWave.wBulletSpeed = Rules.getBulletSpeed((double)d9);
        this.failLock = this.failLock || d8 < 8.0 || this.timeSinceFire > 40;
        double d10 = Math.max(this.enemyLastEnergy - d8, 0.0);
        this.enemyLastEnergy = d8;
        if (d10 > 0.099999) {
            if (d10 > 0.99999 && !this.failLock) {
                this.timeSinceFire = 0;
                double d11 = Rules.getBulletSpeed((double)d10);
                int j = (int)((localDouble1.distance(localDouble3) - 18.0) / d11);
                try {
                    i = (int)(this.getTime() + (long)j) % 127;
                    this.aimAngles[0][i] = d4;
                    this.aimAngles[1][i] = d6;
                    this.aimAngles[2][i] = d7;
                }
                catch (Exception localException2) {
                    // empty catch block
                }
                double d12 = d5;
                double d13 = 5.0;
                for (i = -8; i <= 8; ++i) {
                    int k = 2;
                    for (int m = 1; m <= 5; m += 2) {
                        if (Math.abs(i) <= m) continue;
                        ++k;
                    }
                    if (!((double)k <= d13)) continue;
                    Point2D.Double localObject = QuerMePegarKKKK.project(localDouble3, d12, (double)k * d11);
                    Point2D.Double localDouble4 = QuerMePegarKKKK.project(localDouble1, this.turnAngle, (double)i);
                    for (int n = 0; n < j - 1 - k; ++n) {
                        Point2D.Double localDouble5 = QuerMePegarKKKK.project(localObject, d12, d11 / 2.0);
                        double d14 = QuerMePegarKKKK.absoluteBearing(localDouble4, localDouble5);
                        double d15 = localDouble4.distance(localDouble5);
                        localDouble5 = QuerMePegarKKKK.project(localDouble5, d12, d11 / 2.0);
                        double d16 = 10.0;
                        for (int i1 = 0; i1 < 5; ++i1) {
                            double d;
                            double d17 = 0.1 + 0.03 * (double)i1;
                            double d18 = Rules.getBulletSpeed((double)d17);
                            Point2D.Double localDouble6 = QuerMePegarKKKK.project(localDouble4, d14, (double)n * d18);
                            double d19 = Math.abs(localDouble4.distance(QuerMePegarKKKK.project(localDouble6, d14, d18 / 2.0)) - d15);
                            if (!(d < d16) || !new Line2D.Double(localObject, localDouble5).intersectsLine(new Line2D.Double(localDouble6, QuerMePegarKKKK.project(localDouble6, d14, d18)))) continue;
                            d13 = k;
                            d16 = d19;
                            this.ticker = k;
                            btMoveAhead = i;
                            this.setAhead(btMoveAhead);
                            this.btPower = d17;
                            this.gunAngle = d14;
                        }
                        localObject = localDouble5;
                    }
                }
            } else {
                this.failLock = true;
            }
        }
        if (this.failLock) {
            bullet_avg.addEntry(this.getEnergy() - _oppEnergy);
        }
        this.enemySecondLastAbsoluteBearing = this.enemyLastAbsoluteBearing;
        this.enemyLastAbsoluteBearing = d2;
        boolean i2 = d1 < 112.0;
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(this.turnAngle - this.getHeadingRadians())));
        if (this.failLock || i2) {
            i = 12;
            int i3 = 25;
            do {
                if (arrayOfInt[--i3] <= arrayOfInt[i]) continue;
                i = i3;
            } while (i3 > 0);
            this.gunAngle = d2 + (paramScannedRobotEvent.getEnergy() == 0.0 ? 0.0 : this.bearingDirection * (double)(i - 12));
            if (Math.random() > 0.8) {
                this.moveDirection = -this.moveDirection;
            }
            if (d10 > 0.09999) {
                this.setAhead((double)this.moveDirection * (Math.random() + 0.15));
            }
            this.setTurnRightRadians(Math.cos(paramScannedRobotEvent.getBearingRadians() - (d1 - 160.0) * (double)this.moveDirection / 108000.0));
            if (i2) {
                d9 = 3.0;
                this.setAhead(127.0);
            }
            this.setFire(d9);
        }
        this.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)(d2 - this.getRadarHeadingRadians())));
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.gunAngle - this.getGunHeadingRadians())));
    }

    private boolean isNearHeadingRadians(double[] angle, HitByBulletEvent e) {
        return Utils.isNear((double)angle[(int)this.getTime() % 127], (double)e.getHeadingRadians());
    }

    static {
        bulletHits = 0;
        bulletMisses = 0;
        bulletFired = 0;
        _oppEnergy = 100.0;
        currGun = 0;
        pattenNumber = 0;
        gunData = new StringBuilder();
        canIDoWithoutBulletShield = true;
    }

    class Wave
    extends Condition {
        double wBulletSpeed;
        Point2D.Double wGunLocation;
        double wBearing;
        double wBearingDirection;
        int[] wAimFactors;
        private double wDistance;

        Wave() {
        }

        public final boolean test() {
            double d;
            this.wDistance += this.wBulletSpeed;
            if (d > this.wGunLocation.distance(enemyLastLocation) - 18.0) {
                try {
                    int n = (int)Math.round(Utils.normalRelativeAngle((double)(QuerMePegarKKKK.absoluteBearing(this.wGunLocation, enemyLastLocation) - this.wBearing)) / this.wBearingDirection + 12.0);
                    this.wAimFactors[n] = this.wAimFactors[n] + 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                QuerMePegarKKKK.this.removeCustomEvent(this);
            }
            return false;
        }
    }

    private class EnemyData {
        String name;
        double energy;
        double distance;
        double bearing;
        double bearingRads;
        double absBearing;
        double heading;
        double velocity;
        double scanTime;
        Point2D location = new Point2D.Double();
        CircularQueueArray<HistoricalData> historicalData = new CircularQueueArray(65);

        private EnemyData() {
        }
    }

    private class HistoricalData {
        double distance;
        double heading;
        double headingRad;
        double velocity;
        double xDiff;
        double yDiff;
        double bearing;
        double wallDistanceTopBottom;
        double wallDistanceSides;
        int fired;
        Point2D location;
        Point2D myLocation;
        double myBulletPower;
        Boolean processed;

        private HistoricalData() {
        }
    }

    private class Training {
        float[] input;
        float[] output;

        private Training() {
        }
    }
}

