/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.movement;

import gf.Centaur.Data;
import gf.Centaur.movement.MoveToPoint;
import gf.Centaur.movement.Movement;
import gf.Centaur.movement.PrecisePrediction;
import gf.Centaur.movement.PredictionRobot;
import gf.Centaur.utils.ExecutingRobot;
import gf.Centaur.utils.Tools;
import gf.Centaur.utils.VirtualRobot;
import gf.Centaur.utils.Wave;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitWallEvent;

public class WaveSurfingMovement
extends Movement {
    private static final int NO_WAVE_MAX_DIST = 100;
    private static final int NO_WAVE_MAX_TIME = 15;
    private static final int DIST_STEP = 20;
    private static final double ANGLE_STEP = Math.toRadians(30.0);
    private static final double MAX_ANGLE = 2.0943951023931953;
    private static final int MAX_DIST = 200;
    private static final double HIT_WALL_WEIGHT = 1000.0;
    private static final double ENEMIE_DIST_WEIGHT = 0.1;
    private static final double WALL_WEIGHT = 0.02;
    private static final double CENTER_WEIGHT = 0.005;
    private static final double DIST_DIVISOR = 1500.0;
    private final double battleFieldWidth;
    private final double battleFieldHeight;
    private Wave lastWave = null;
    private long alarmTime = -1L;
    protected final Condition MyTimeAlarmCondition = new Condition("MyTimeAlarmCondition"){

        public boolean test() {
            if (WaveSurfingMovement.this.robot.getTime() == WaveSurfingMovement.this.alarmTime) {
                WaveSurfingMovement.this.alarmTime = -1L;
                return true;
            }
            return false;
        }
    };

    public WaveSurfingMovement(AdvancedRobot robot, Data data) {
        super(robot, data);
        this.battleFieldWidth = robot.getBattleFieldWidth();
        this.battleFieldHeight = robot.getBattleFieldHeight();
        robot.addCustomEvent(this.MyTimeAlarmCondition);
        System.out.println("Neue Bewegungssteuerung: WaveSurfingMovement");
    }

    @Override
    public void start() {
        this.nextMove();
    }

    public void nextMove() {
        this.alarmTime = -1L;
        PrecisePrediction pp = new PrecisePrediction(new ExecutingRobot(this.robot));
        Point2D.Double robotPos = new Point2D.Double(this.robot.getX(), this.robot.getY());
        Wave nearestWave = null;
        for (Wave wave : this.data.getWaves()) {
            if (nearestWave == null) {
                nearestWave = wave;
                continue;
            }
            if (!(robotPos.distance(wave.getPoint()) - wave.getRadius(this.robot.getTime()) < robotPos.distance(nearestWave.getPoint()) - nearestWave.getRadius(this.robot.getTime()))) continue;
            nearestWave = wave;
        }
        this.lastWave = nearestWave;
        this.shapes.clear();
        double maxDist = nearestWave == null ? 100 : 200;
        MoveToPoint bestMove = null;
        double bestRisk = Double.POSITIVE_INFINITY;
        double angle = -2.0943951023931953;
        while (angle <= 2.0943951023931953) {
            double dist = Double.NEGATIVE_INFINITY;
            while (dist < Double.POSITIVE_INFINITY) {
                if (dist + 20.0 > maxDist) {
                    dist = Double.POSITIVE_INFINITY;
                } else if (dist != Double.NEGATIVE_INFINITY) {
                    dist += 20.0;
                }
                PredictionRobot rob = nearestWave == null ? pp.getPrediction(15L, dist, angle) : pp.getPredictionWave(dist, angle, nearestWave);
                MoveToPoint move = new MoveToPoint(rob, dist, angle);
                double risk = this.getRisk(move, nearestWave);
                double redValue = Tools.range(risk, 0.0, 3.0) / 3.0;
                Color paint = new Color((float)redValue, 0.0f, (float)(1.0 - redValue));
                this.shapes.put(new Ellipse2D.Double(rob.getX() - 2.0, rob.getY() - 2.0, 4.0, 4.0), paint);
                if (bestMove == null || risk < bestRisk) {
                    bestMove = move;
                    bestRisk = risk;
                }
                if (dist != Double.NEGATIVE_INFINITY) continue;
                dist = -maxDist;
            }
            angle += ANGLE_STEP;
        }
        if (nearestWave == null) {
            this.alarmTime = this.robot.getTime() + 15L;
        }
        if (bestMove.getDistance() == 0.0) {
            this.robot.setStop();
        } else {
            this.robot.setAhead(bestMove.getDistance());
            this.robot.setTurnRightRadians(bestMove.getTurn());
        }
        this.isMoving = true;
        this.isTurning = true;
    }

    private double getRisk(MoveToPoint move, Wave wave) {
        double risk = 0.0;
        Point2D.Double pos = move.getPosition();
        if (wave != null) {
            double angleFromPoint = Math.atan2(pos.getX() - wave.getX(), pos.getY() - wave.getY());
            double danger = wave.getDanger(angleFromPoint, this.data.getEnemieGuessFactors().get(wave.getExecName()));
            risk += danger;
        }
        if (move.hasHitWall()) {
            risk += 1000.0;
        }
        risk += 1.0 / (pos.x / 1500.0) * 0.02;
        risk += 1.0 / (pos.y / 1500.0) * 0.02;
        risk += 1.0 / ((this.battleFieldWidth - pos.x) / 1500.0) * 0.02;
        risk += 1.0 / ((this.battleFieldHeight - pos.y) / 1500.0) * 0.02;
        risk += 1.0 / (pos.distance(new Point2D.Double(this.battleFieldWidth / 2.0, this.battleFieldHeight / 2.0)) / 1500.0) * 0.005;
        for (VirtualRobot enemie : this.data.getEnemies().values()) {
            risk += 1.0 / (pos.distance(enemie.getPosition()) / 1500.0) * 0.1;
        }
        return risk;
    }

    @Override
    public void onHitWall(HitWallEvent e) {
        this.nextMove();
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
        Condition c = e.getCondition();
        if (c == this.MyMoveCompleteCondition || c == this.MyTimeAlarmCondition || c == this.data.WaveBreakCondition && this.data.getLastBreakedWave() == this.lastWave) {
            this.nextMove();
        }
    }
}

