/*
 * Decompiled with CFR 0.152.
 */
package jdw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Arrays;
import jdw.hurricane.Enemy;
import jdw.hurricane.GlobalData;
import jdw.hurricane.engine.Engine;
import jdw.hurricane.gun.Gun;
import jdw.hurricane.radar.Radar;
import jdw.util.FastTrig;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class Hurricane
extends AdvancedRobot {
    private static Gun gun;
    private static Radar radar;
    private static Engine engine;
    private boolean first_scan;

    public void run() {
        this.setBodyColor(Color.black);
        this.setGunColor(Color.blue);
        this.setRadarColor(Color.white);
        this.setScanColor(Color.white);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setEventPriority("RobotDeathEvent", 5);
        if (this.getRoundNum() == 0) {
            FastTrig.init();
            GlobalData.init(this);
            gun = new Gun();
            radar = new Radar();
            engine = new Engine();
        }
        GlobalData.static_init_round();
        GlobalData.painter.init_round();
        int i = 0;
        while (i < GlobalData.num_enemies) {
            GlobalData.enemies[i].init_round();
            ++i;
        }
        radar.init_round();
        gun.init_round();
        engine.init_round();
        while (true) {
            GlobalData.static_tick();
            GlobalData.painter.tick();
            double deactivate_ticks = GlobalData.ticks - 20;
            Arrays.sort(GlobalData.sorted_enemies);
            i = 0;
            while (i < GlobalData.num_enemies) {
                GlobalData.enemies[i].tick(deactivate_ticks);
                ++i;
            }
            gun.tick();
            engine.tick();
            radar.tick();
            this.setMaxVelocity(Math.abs(GlobalData.targ_vel));
            this.setAhead(GlobalData.targ_vel * Double.POSITIVE_INFINITY);
            this.setTurnRightRadians(GlobalData.steer);
            this.setTurnGunRightRadians(GlobalData.rot_gun);
            if (GlobalData.fire_gun > 0.05) {
                this.setFire(GlobalData.fire_gun);
                GlobalData.fire_gun = 0.0;
            }
            this.setTurnRadarRightRadians(GlobalData.rot_radar);
            ++GlobalData.ticks;
            this.first_scan = true;
            this.execute();
        }
    }

    public Integer get_robot_id(String name) {
        Integer id = GlobalData.robot_ids.get(name);
        if (id == null) {
            id = GlobalData.num_enemies_found++;
            GlobalData.robot_ids.put(name, id);
        }
        return id;
    }

    public void onPaint(Graphics2D g) {
        GlobalData.painter.paint(g);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.first_scan) {
            GlobalData.pos_x = this.getX();
            GlobalData.pos_y = this.getY();
            GlobalData.energy = this.getEnergy();
            GlobalData.heading = this.getHeadingRadians();
            GlobalData.veloctiy = this.getVelocity();
            GlobalData.gun_heading = this.getGunHeadingRadians();
            GlobalData.gun_fire_ticks = (int)Math.round(this.getGunHeat() / this.getGunCoolingRate());
            GlobalData.radar_heading = this.getRadarHeadingRadians();
            GlobalData.pos_x_history[GlobalData.pos_history_i] = this.getX();
            GlobalData.pos_y_history[GlobalData.pos_history_i] = this.getY();
            if (++GlobalData.pos_history_i == 10) {
                GlobalData.pos_history_i = 0;
            }
            this.first_scan = false;
        }
        double dist = e.getDistance();
        double ang = this.getHeadingRadians() + e.getBearingRadians();
        double x_pos = GlobalData.pos_x + Math.sin(ang) * dist;
        double y_pos = GlobalData.pos_y + Math.cos(ang) * dist;
        double energy = e.getEnergy();
        double heading = e.getHeadingRadians();
        double vel = e.getVelocity();
        int id = this.get_robot_id(e.getName());
        GlobalData.enemies[id].update(x_pos, y_pos, dist, energy, heading, vel);
        if (dist > GlobalData.max_enemy_dist || id == GlobalData.max_enemy_id) {
            GlobalData.max_enemy_dist = dist;
            GlobalData.max_enemy_id = id;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Enemy robot = GlobalData.enemies[this.get_robot_id(e.getName())];
        double damage = e.getPower() * 3.0;
        robot.last_energy += damage;
        robot.danger += damage;
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = power * 4.0;
        if (power > 1.0) {
            damage += (power - 1.0) * 2.0;
        }
        Enemy robot = GlobalData.enemies[this.get_robot_id(e.getName())];
        robot.last_energy -= damage;
        robot.damage += damage;
        GlobalData.bullet_result(power, true);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        GlobalData.bullet_result(e.getBullet().getPower(), false);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        GlobalData.bullet_result(e.getBullet().getPower(), false);
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("Hit Wall!");
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy enemy = GlobalData.enemies[this.get_robot_id(e.getName())];
        enemy.alive = false;
        enemy.active = false;
        --GlobalData.num_enemies_alive;
    }

    public void onDeath(DeathEvent e) {
    }

    public void onBattleEnded(BattleEndedEvent e) {
    }
}

