/*
 * Decompiled with CFR 0.152.
 */
package jdw.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

public class Painter {
    private List<int[]> lines = new ArrayList<int[]>();
    private List<int[]> circles = new ArrayList<int[]>();

    public void init_round() {
    }

    public void tick() {
        this.lines.clear();
        this.circles.clear();
    }

    public void paint_line(double x1, double y1, double x2, double y2) {
        this.lines.add(new int[]{(int)Math.round(x1), (int)Math.round(y1), (int)Math.round(x2), (int)Math.round(y2)});
    }

    public void paint_polar_line(double x, double y, double ang, double len) {
        this.paint_line(x, y, x + Math.sin(ang) * len, y + Math.cos(ang) * len);
    }

    public void paint_circle(double x, double y, double rad, double weight) {
        int int_weight = (int)(weight * 256.0);
        this.circles.add(new int[]{(int)Math.round(x - rad), (int)Math.round(y - rad), (int)Math.round(rad * 2.0), int_weight});
    }

    public void paint(Graphics2D g) {
        g.setColor(Color.RED);
        for (int[] target : this.lines) {
            g.drawLine(target[0], target[1], target[2], target[3]);
        }
        for (int[] target : this.circles) {
            g.setColor(new Color(Math.max(0.0f, Math.min((float)target[3] / 256.0f, 1.0f)), 0.0f, 0.0f));
            g.drawOval(target[0], target[1], target[2], target[2]);
        }
    }
}

