/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.drive;

import xander.core.Resources;
import xander.core.drive.Drive;
import xander.core.drive.DriveSelector;
import xander.core.track.GunStats;
import xander.core.track.Snapshot;

public class HighPerformanceDriveSelector
implements DriveSelector {
    private Drive defaultDrive;
    private int defaultDriveIndex;
    private int shotsForAccuracy;
    private double highPerformanceHitRatio;
    private GunStats gunStats;

    public HighPerformanceDriveSelector(Drive defaultDrive, int shotsForAccuracy, double highPerformanceHitRatio) {
        this.defaultDrive = defaultDrive;
        this.shotsForAccuracy = shotsForAccuracy;
        this.highPerformanceHitRatio = highPerformanceHitRatio;
        this.gunStats = Resources.getGunStats();
    }

    public HighPerformanceDriveSelector(int shotsForAccuracy) {
        this(null, shotsForAccuracy, 1.0);
    }

    @Override
    public int selectDrive(Drive[] drives, Snapshot snapshot) {
        int bestIndex = -1;
        double bestScore = 1.0;
        int i = 0;
        while (i < drives.length) {
            int shotsAgainstDrive;
            double confidenceMultiplier;
            Drive drive = drives[i];
            double hitRatioAgainstDrive = this.gunStats.getOpponentHitRatioAgainstDrive(drive.getName());
            double weightedScore = hitRatioAgainstDrive * (confidenceMultiplier = Math.min(1.0, Math.pow((double)(shotsAgainstDrive = this.gunStats.getShotsAgainstDrive(drive.getName())) / (double)this.shotsForAccuracy, 2.0)));
            if (weightedScore <= this.highPerformanceHitRatio && weightedScore < bestScore) {
                bestIndex = i;
                bestScore = weightedScore;
            }
            if (drive == this.defaultDrive) {
                this.defaultDriveIndex = i;
            }
            ++i;
        }
        return bestIndex < 0 ? this.defaultDriveIndex : bestIndex;
    }
}

