/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws;

import java.awt.geom.Point2D;
import xander.core.Resources;
import xander.core.drive.Direction;
import xander.core.drive.DistancingEquation;
import xander.core.drive.DriveController;
import xander.core.drive.DrivePrediction;
import xander.core.drive.OrbitalDrivePredictor;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.gfws.FactorIndexer;
import xander.gfws.FactorRange;
import xander.gfws.RelativeAngleRange;

public class OrbitalFactorArrays {
    public static FactorRange getReachableFactorRange(double bulletVelocity, Snapshot initialAttackerSnapshot, Snapshot initialDefenderSnapshot, long time, int numFactors, boolean diveProtect, DistancingEquation distancingEquation, OrbitalDrivePredictor orbitalDrivePaths, double[] velocityConstraints) {
        double bulletPower = RCPhysics.getBulletPower(bulletVelocity);
        Wave wave = Resources.getWaveHistory().createWave(initialDefenderSnapshot, initialAttackerSnapshot, bulletPower, initialAttackerSnapshot.getTime(), false, false);
        return OrbitalFactorArrays.getReachableFactorRange(wave, initialAttackerSnapshot, initialDefenderSnapshot, time, numFactors, diveProtect, distancingEquation, orbitalDrivePaths, velocityConstraints);
    }

    public static FactorRange getReachableFactorRange(Wave wave, Snapshot attackerSnapshot, Snapshot defenderSnapshot, long time, int numFactors, boolean diveProtect, DistancingEquation distancingEquation, OrbitalDrivePredictor orbitalDrivePaths, double[] velocityConstraints) {
        double pointFactorAngle;
        double pointAngle;
        Point2D.Double point;
        double ccwAngleOffset;
        double cwAngleOffset;
        FactorIndexer factorIndexer = wave.getFactorIndexer();
        FactorRange rfr = new FactorRange();
        double currentAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), defenderSnapshot.getX(), defenderSnapshot.getY());
        double divisionAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), currentAngle);
        double currentDistance = Double.POSITIVE_INFINITY;
        if (attackerSnapshot != null) {
            currentDistance = attackerSnapshot.getDistance();
        }
        DrivePrediction cwDrivePrediction = orbitalDrivePaths.predictMaxPathBeforeBulletHit(defenderSnapshot, Direction.CLOCKWISE, wave.getOriginX(), wave.getOriginY(), time - wave.getOriginTime(), wave.getBulletVelocity(), currentDistance, distancingEquation, velocityConstraints);
        Point2D.Double cwPosition = cwDrivePrediction.getFinalDriveState().getPosition();
        double cwAngleFromOrigin = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), cwPosition.x, cwPosition.y);
        double maxClockwiseFactorAngle = cwAngleOffset = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), cwAngleFromOrigin);
        rfr.clockwisePath = cwDrivePrediction.getDrivePath();
        rfr.clockwiseDistances = new double[rfr.clockwisePath.size()];
        rfr.clockwiseFactorIndexes = new double[rfr.clockwisePath.size()];
        double[] attackerDelta = attackerSnapshot.getXYShift();
        DrivePrediction ccwDrivePrediction = orbitalDrivePaths.predictMaxPathBeforeBulletHit(defenderSnapshot, Direction.COUNTER_CLOCKWISE, wave.getOriginX(), wave.getOriginY(), time - wave.getOriginTime(), wave.getBulletVelocity(), currentDistance, distancingEquation, velocityConstraints);
        Point2D.Double ccwPosition = ccwDrivePrediction.getFinalDriveState().getPosition();
        double ccwAngleFromOrigin = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), ccwPosition.x, ccwPosition.y);
        double maxCounterClockwiseFactorAngle = ccwAngleOffset = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), ccwAngleFromOrigin);
        rfr.counterClockwisePath = ccwDrivePrediction.getDrivePath();
        rfr.counterClockwiseDistances = new double[rfr.counterClockwisePath.size()];
        rfr.counterClockwiseFactorIndexes = new double[rfr.counterClockwisePath.size()];
        rfr.mea = new RelativeAngleRange(maxCounterClockwiseFactorAngle, maxClockwiseFactorAngle, "OrbitalFactorArrays");
        int cwDivisionIndex = 0;
        int ccwDivisionIndex = 0;
        cwDivisionIndex = factorIndexer.getFactorIndex(cwAngleOffset, numFactors, wave.getSurfDirection(), wave.getInitialMEA());
        ccwDivisionIndex = factorIndexer.getFactorIndex(ccwAngleOffset, numFactors, wave.getSurfDirection(), wave.getInitialMEA());
        rfr.currentDefenderIndex = factorIndexer.getFactorIndex(divisionAngle, numFactors, wave.getSurfDirection(), wave.getInitialMEA());
        rfr.maxClockwiseIndex = cwDivisionIndex;
        rfr.maxCounterClockwiseIndex = ccwDivisionIndex;
        Point2D.Double attackerPos = new Point2D.Double(attackerSnapshot.getX(), attackerSnapshot.getY());
        int i = 0;
        while (i < rfr.clockwiseDistances.length) {
            point = rfr.clockwisePath.get(i);
            rfr.clockwiseDistances[i] = RCMath.getDistanceBetweenPoints(point.x, point.y, attackerPos.x, attackerPos.y);
            pointAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), point.x, point.y);
            pointFactorAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), pointAngle);
            rfr.clockwiseFactorIndexes[i] = factorIndexer.getPreciseFactorIndex(pointFactorAngle, numFactors, wave.getSurfDirection(), wave.getInitialMEA());
            attackerPos.x += attackerDelta[0];
            attackerPos.y += attackerDelta[1];
            ++i;
        }
        attackerPos = new Point2D.Double(attackerSnapshot.getX(), attackerSnapshot.getY());
        i = 0;
        while (i < rfr.counterClockwiseDistances.length) {
            point = rfr.counterClockwisePath.get(i);
            rfr.counterClockwiseDistances[i] = RCMath.getDistanceBetweenPoints(point.x, point.y, attackerPos.x, attackerPos.y);
            pointAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), point.x, point.y);
            pointFactorAngle = RCMath.getTurnAngle(wave.getInitialDefenderBearing(), pointAngle);
            rfr.counterClockwiseFactorIndexes[i] = factorIndexer.getPreciseFactorIndex(pointFactorAngle, numFactors, wave.getSurfDirection(), wave.getInitialMEA());
            attackerPos.x += attackerDelta[0];
            attackerPos.y += attackerDelta[1];
            ++i;
        }
        double cwDistance = rfr.clockwiseDistances[rfr.clockwiseDistances.length - 1];
        double ccwDistance = rfr.counterClockwiseDistances[rfr.counterClockwiseDistances.length - 1];
        if (diveProtect && currentDistance < (distancingEquation.getOptimalDistance() + distancingEquation.getMaxRetreatDistance()) / 2.0) {
            if ((ccwDistance < currentDistance - 35.0 || ccwDistance < 70.0) && cwDistance >= currentDistance) {
                ccwDivisionIndex = Math.min(rfr.currentDefenderIndex, cwDivisionIndex);
                rfr.diveProtected = true;
            } else if ((cwDistance < currentDistance - 35.0 || cwDistance < 70.0) && ccwDistance >= currentDistance) {
                cwDivisionIndex = Math.max(rfr.currentDefenderIndex, ccwDivisionIndex);
                rfr.diveProtected = true;
            }
        }
        if (ccwDivisionIndex > cwDivisionIndex) {
            rfr.beginIndex = Math.max(0, cwDivisionIndex);
            rfr.endIndex = Math.min(numFactors - 1, ccwDivisionIndex);
        } else {
            rfr.beginIndex = Math.max(0, ccwDivisionIndex);
            rfr.endIndex = Math.min(numFactors - 1, cwDivisionIndex);
        }
        return rfr;
    }

    public static void driveToFactor(Wave wave, double factorAngle, double x, double y, double opponentDistance, DistancingEquation distancingEquation, OrbitalDrivePredictor orbitalDrivePaths, DriveController driveController) {
        double facing = RCMath.getRobocodeAngle(wave.getOriginX() - x, wave.getOriginY() - y);
        double opposingAngle = RCMath.normalizeDegrees(facing + 180.0);
        double turnAngle = RCMath.getTurnAngle(opposingAngle, wave.getInitialDefenderBearing() + factorAngle);
        Direction direction = turnAngle < 0.0 ? Direction.COUNTER_CLOCKWISE : Direction.CLOCKWISE;
        double targetHeadingFromOrigin = RCMath.normalizeDegrees(wave.getInitialDefenderBearing() + factorAngle);
        boolean isOvershoot = orbitalDrivePaths.isOvershoot(wave.getOrigin(), opponentDistance, direction, targetHeadingFromOrigin, wave, distancingEquation);
        double speed = isOvershoot ? 0.0 : 8.0;
        VelocityVector driveVector = orbitalDrivePaths.getSmoothedOrbitAngle(wave.getOrigin(), opponentDistance, direction, distancingEquation, speed);
        driveController.drive(driveVector.getRoboAngle(), driveVector.getMagnitude());
    }
}

