/*
 * Decompiled with CFR 0.152.
 */
package labg.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import labg.util.EvolvableValue;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;

public class EvolutionManager
implements Serializable {
    HashMap evolVars = new HashMap();
    int HOWOFTEN = 2;
    int HOWMANYVALUES = 8;
    transient AdvancedRobot myBot;
    int upTo = 0;
    int timesEvolved = 0;
    double cycles = 0.0;
    double cumScore = 0.0;
    int roundsOfEvo = 0;
    boolean useStartVals = true;
    boolean enabled = true;

    public void setValues(boolean enabled, int howOften, int howManyValues) {
        this.enabled = enabled;
        this.HOWOFTEN = howOften;
        this.HOWMANYVALUES = howManyValues;
    }

    public void printRoundsPerEvo() {
        System.out.println(String.valueOf(this.HOWOFTEN * this.HOWMANYVALUES * this.evolVars.size()) + " rounds per evolution");
    }

    public void setBot(AdvancedRobot myBot) {
        this.myBot = myBot;
    }

    public void addVariable(String name, double startVal, double lower, double upper) {
        if (this.evolVars.get(name) == null) {
            EvolvableValue tmp = new EvolvableValue(name, startVal, lower, upper);
            tmp.setHowManyValues(this.HOWMANYVALUES);
            this.evolVars.put(name, tmp);
        }
    }

    public double getVariable(String varName) {
        if (this.useStartVals) {
            return ((EvolvableValue)this.evolVars.get(varName)).getStartValue();
        }
        if (this.enabled) {
            return ((EvolvableValue)this.evolVars.get(varName)).getEvolvedValue();
        }
        return ((EvolvableValue)this.evolVars.get((Object)varName)).statEvolvedVal;
    }

    public void doEvolution() {
        if (this.enabled && this.myBot.getRoundNum() % this.HOWOFTEN == 0) {
            EvolvableValue[] evolArray = this.evolVars.values().toArray(new EvolvableValue[1]);
            if (evolArray[this.upTo].isOptimized()) {
                PrintStream w;
                this.cumScore = 0.0;
                this.cycles = 0.0;
                evolArray[this.upTo].currentlyEvolving = false;
                System.out.println(String.valueOf(evolArray[this.upTo].name) + " has been optimized");
                try {
                    w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.myBot.getDataFile("evolution.dat").getAbsolutePath(), true));
                    evolArray[this.upTo].print(w);
                    w.close();
                }
                catch (Exception e) {
                    System.out.println("IOException trying to write: " + e);
                }
                if (this.upTo < evolArray.length - 1) {
                    ++this.upTo;
                } else {
                    this.upTo = 0;
                    System.out.println("Finished Round of Evolution");
                    ++this.roundsOfEvo;
                    try {
                        w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.myBot.getDataFile("evolution.dat").getAbsolutePath(), true));
                        w.println("Round " + this.roundsOfEvo + " of Evolution:");
                        w.close();
                    }
                    catch (Exception e) {
                        System.out.println(e);
                    }
                    int i = 0;
                    while (i < evolArray.length) {
                        evolArray[i].reset();
                        ++i;
                    }
                }
            } else {
                evolArray[this.upTo].currentlyEvolving = true;
                evolArray[this.upTo].addResult(this.cumScore / this.cycles);
                evolArray[this.upTo].doEvolution();
            }
        }
    }

    public void addRoundResult(double score) {
        this.cumScore += score;
        this.cycles += 1.0;
    }
}

