/*
 * Decompiled with CFR 0.152.
 */
package rdt.Targeting;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import rdt.AgentSmith.AgentSmith;
import rdt.AgentSmith.Setup;
import rdt.Debug.DebugGraph;
import rdt.RobotData.RobotData;
import rdt.RobotData.RobotDataModification;
import rdt.RobotData.RobotDataSnapshot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;

public class Targeting {
    public static int MaxSnapshotDepth = 5;
    private static RobotData _currentTarget = null;
    private static ArrayList<RobotData> _targets = null;
    private static ArrayList<DebugGraph> _graphs = null;

    public static RobotData GetCurrentTarget() {
        return _currentTarget;
    }

    public static void InitTargeting() {
        if (_targets == null) {
            _targets = new ArrayList(AgentSmith.Instance().getOthers());
        }
        _currentTarget = null;
        int count = 0;
        while (count < _targets.size()) {
            RobotData target = _targets.get(count);
            if (target != null) {
                RobotDataModification.Reset(target);
            }
            ++count;
        }
        if (Setup.Instance.EnableTargetDebug) {
            _graphs = new ArrayList();
            _graphs.add(new DebugGraph(100, -8.0, 8.0, new Point2D.Double(-180.0, 550.0), new Point2D.Double(-20.0, 600.0)));
            _graphs.add(new DebugGraph(100, -2.0, 2.0, new Point2D.Double(-180.0, 500.0), new Point2D.Double(-20.0, 550.0)));
            _graphs.add(new DebugGraph(100, -1.0, 1.0, new Point2D.Double(-180.0, 450.0), new Point2D.Double(-20.0, 500.0)));
        }
    }

    public static void UpdateTargeting() {
        if (_currentTarget == null && _targets.size() > 0) {
            RobotData target;
            _currentTarget = target = _targets.get(0);
        }
        if (Setup.Instance.EnableTargetDebug) {
            Targeting.UpdateGraphing();
        }
    }

    public static void OnScannedRobot(ScannedRobotEvent event) {
        RobotData target = Targeting.GetTargetByName(event.getName());
        if (target == null) {
            target = new RobotData(event.getName(), MaxSnapshotDepth);
            _targets.add(target);
        }
        RobotDataSnapshot ourData = AgentSmith.Instance().GetLatestSnapshot();
        double absoluteAngle = ourData.AbsoluteHeading + event.getBearingRadians();
        double x = ourData.LocationX + event.getDistance() * Math.sin(absoluteAngle);
        double y = ourData.LocationY + event.getDistance() * Math.cos(absoluteAngle);
        RobotDataModification.UpdateSnapshot(target, x, y, event.getHeadingRadians(), event.getVelocity(), event.getEnergy(), ourData.LocationX, ourData.LocationY, absoluteAngle);
    }

    public static void OnHitByBulletEvent(HitByBulletEvent event) {
        RobotData target = Targeting.GetTargetByName(event.getName());
        if (target == null) {
            return;
        }
        RobotDataSnapshot latestSnapshot = target.Snapshots.get(0);
        double energyGainedFromHit = event.getPower() * 3.0;
        latestSnapshot.Energy += energyGainedFromHit;
    }

    public static void OnBulletHitEvent(BulletHitEvent event) {
        RobotData target = Targeting.GetTargetByName(event.getName());
        if (target == null) {
            target = new RobotData(event.getName(), MaxSnapshotDepth);
            _targets.add(target);
        }
        double firepower = event.getBullet().getPower();
        double energyLost = firepower * 4.0;
        if (firepower > 1.0) {
            energyLost += 2.0 * (firepower - 1.0);
        }
        RobotDataSnapshot latestSnapshot = target.Snapshots.get(0);
        latestSnapshot.Energy -= energyLost;
        if (latestSnapshot.Energy != event.getEnergy()) {
            latestSnapshot.BulletFirepower = RobotDataModification.DetectBulletFirepower(latestSnapshot.Energy, event.getEnergy(), latestSnapshot.LastFiredFirepower, latestSnapshot.SnapshotTick, latestSnapshot.LastFiredTick);
            if (latestSnapshot.BulletFirepower > 0.0) {
                latestSnapshot.LastFiredTick = latestSnapshot.SnapshotTick;
                latestSnapshot.LastFiredFirepower = latestSnapshot.BulletFirepower;
            }
        }
    }

    protected static RobotData GetTargetByName(String name) {
        int count = 0;
        while (count < _targets.size()) {
            RobotData target = _targets.get(count);
            if (target != null && target.Name.equals(name)) {
                return target;
            }
            ++count;
        }
        return null;
    }

    private static void UpdateGraphing() {
        if (_graphs != null) {
            RobotData target = Targeting.GetCurrentTarget();
            if (target == null || !target.Valid || target.NumSnapshots < 1) {
                return;
            }
            RobotDataSnapshot snapshot = target.Snapshots.get(0);
            _graphs.get(0).AddPoint(snapshot.VelocityAlongHeading);
            _graphs.get(1).AddPoint(snapshot.AccelerationAlongHeading);
            _graphs.get(2).AddPoint(snapshot.RotationDirectionToTarget);
        }
    }

    public static void DebugDraw(Graphics2D gfx) {
        if (_graphs == null) {
            return;
        }
        if (!Setup.Instance.EnableTargetDebug) {
            return;
        }
        int index = 0;
        while (index < _graphs.size()) {
            _graphs.get(index).Draw(gfx);
            ++index;
        }
    }
}

