/*
 * Decompiled with CFR 0.152.
 */
package rdt.Utils;

import java.util.Comparator;
import java.util.TreeSet;

public class FixedSizePriorityQueue<E>
extends TreeSet<E> {
    private int elementsLeft;

    public FixedSizePriorityQueue(int maxSize, Comparator<E> comparator) {
        super(comparator);
        this.elementsLeft = maxSize;
    }

    @Override
    public boolean add(E e) {
        if (this.elementsLeft > 0) {
            boolean added = super.add(e);
            if (added) {
                --this.elementsLeft;
            }
            return added;
        }
        int compared = super.comparator().compare(e, this.first());
        if (compared == 1) {
            this.pollFirst();
            super.add(e);
            return true;
        }
        return false;
    }
}

