/*
 * Decompiled with CFR 0.152.
 */
package rdt.Waves;

import java.awt.Color;
import java.awt.Graphics2D;
import rdt.AgentSmith.AgentSmith;
import rdt.RobotData.RobotDataSnapshot;
import rdt.Utils.RuleUtils;
import rdt.Waves.WaveData;

public class WaveDataUtils {
    public static double GetWaveDistance(WaveData wave, long currentTick) {
        long waveDeltaTick = currentTick - wave.VirtualGunData.TickFired;
        waveDeltaTick = Math.max(waveDeltaTick, 0L);
        waveDeltaTick = Math.min(waveDeltaTick, (long)(WaveData.WaveSnapshotCount - 1));
        return wave.WaveDistance[(int)waveDeltaTick];
    }

    public static double GetWaveDistanceSqToSnapshot(WaveData wave, RobotDataSnapshot snapshot) {
        double dX = snapshot.LocationX - wave.VirtualGunData.FiringLocationX;
        double dY = snapshot.LocationY - wave.VirtualGunData.FiringLocationY;
        return dX * dX + dY * dY;
    }

    public static void SetInitialWaveData(WaveData wave) {
        wave.NumWaveAngles = 0;
        double velocity = wave.VirtualGunData.BulletVelocity;
        int tick = 0;
        while (tick < WaveData.WaveSnapshotCount) {
            double distanceTravelledAtTick;
            wave.WaveDistance[tick] = distanceTravelledAtTick = velocity * (double)tick;
            ++tick;
        }
    }

    public static void AddAngle(WaveData wave, double absAngle) {
        int angleIndex = wave.NumWaveAngles;
        double dX = Math.sin(absAngle);
        double dY = Math.cos(absAngle);
        double battlefieldWidth = AgentSmith.Instance().getBattleFieldWidth();
        double battlefieldHeight = AgentSmith.Instance().getBattleFieldHeight();
        int lowestTickOutsideBattlefield = Integer.MAX_VALUE;
        int tick = 0;
        while (tick < WaveData.WaveSnapshotCount) {
            double distance = wave.WaveDistance[tick];
            WaveData.WaveAngleSnapshotData data = wave.AngleSnapshots[angleIndex][tick];
            data.CurrentLocationX = wave.VirtualGunData.FiringLocationX + dX * distance;
            data.CurrentLocationY = wave.VirtualGunData.FiringLocationY + dY * distance;
            if (lowestTickOutsideBattlefield == Integer.MAX_VALUE && RuleUtils.IsOutsideBattlefield(data.CurrentLocationX, data.CurrentLocationY, 0.0, battlefieldWidth, battlefieldHeight)) {
                lowestTickOutsideBattlefield = tick;
            }
            ++tick;
        }
        ++wave.NumWaveAngles;
        wave.AbsTickAngleSnapshotsOutsideBattlefield = Math.max(wave.AbsTickAngleSnapshotsOutsideBattlefield, AgentSmith.Instance().getTime() + (long)lowestTickOutsideBattlefield);
    }

    public static void DebugDraw(Graphics2D gfx, WaveData wave, Color colour, long tick) {
        gfx.setColor(colour);
        long waveDeltaTick = tick - wave.VirtualGunData.TickFired;
        double currentDistance = wave.WaveDistance[(int)waveDeltaTick];
        double doubleCurrentDistance = currentDistance * 2.0;
        gfx.drawOval((int)(wave.VirtualGunData.FiringLocationX - currentDistance), (int)(wave.VirtualGunData.FiringLocationY - currentDistance), (int)doubleCurrentDistance, (int)doubleCurrentDistance);
        int boxWidth = 5;
        int boxOffset = 2;
        int index = 0;
        while (index < wave.NumWaveAngles) {
            gfx.setColor(colour);
            if (index == 0) {
                gfx.setColor(Color.white);
            }
            WaveData.WaveAngleSnapshotData data = wave.AngleSnapshots[index][(int)waveDeltaTick];
            gfx.drawRect((int)data.CurrentLocationX - boxOffset, (int)data.CurrentLocationY - boxOffset, boxWidth, boxWidth);
            ++index;
        }
    }
}

