/*
 * Decompiled with CFR 0.152.
 */
package rdt199.gun;

import rdt199.gun.GunMode;
import rdt199.tracking.VirtualBullet;
import rdt199.util.BotFuncs;
import rdt199.util.FileHandler;
import rdt199.util.Location;
import rdt199.util.RobotLog;
import rdt199.util.RobotSnapshot;

public class VelocityFactorMode
extends GunMode {
    protected double[] m_dVirtualAverages = new double[TOTAL_VELOCITY_FACTORS];
    protected static int TOTAL_VELOCITY_FACTORS = 11;

    public VelocityFactorMode(RobotLog log, String prefix) {
        super(log, prefix);
        int iCount = 0;
        while (iCount < TOTAL_VELOCITY_FACTORS) {
            this.m_dVirtualAverages[iCount] = 0.5;
            ++iCount;
        }
        this.loadData(String.valueOf(this.m_Prefix) + "vf");
    }

    public double getScore() {
        double dHighestScore = 0.0;
        int iCount = 0;
        while (iCount < TOTAL_VELOCITY_FACTORS) {
            double dCurrentScore = this.m_dVirtualAverages[iCount];
            if (dCurrentScore > dHighestScore) {
                dHighestScore = dCurrentScore;
            }
            ++iCount;
        }
        return dHighestScore;
    }

    public void close() {
        this.saveData(String.valueOf(this.m_Prefix) + "vf");
    }

    public void setVirtualHit(VirtualBullet bullet) {
        double dHit = 0.0;
        if (bullet.hitTarget()) {
            dHit = 1.0;
        }
        int iIndex = this.translate(bullet.getVelocityFactor());
        this.m_dVirtualAverages[iIndex] = (this.m_dVirtualAverages[iIndex] * GunMode.N + dHit * bullet.getFirepower()) / (GunMode.N + bullet.getFirepower());
    }

    public void fireVirtualBullet(Location loc) {
        double dDistance = BotFuncs.getDistanceBetween(loc, this.m_Log.get((int)0).m_Location);
        double dFirepower = BotFuncs.getFirepower(dDistance);
        if (dFirepower < 0.0) {
            return;
        }
        long lTime = this.getBulletTimeToImpact(dFirepower, dDistance);
        int iCount = 0;
        while (iCount < TOTAL_VELOCITY_FACTORS) {
            double dVelFactor = this.translate(iCount);
            Location PredictedLoc = this.getGuess(lTime, dVelFactor);
            if (PredictedLoc != null && this.readyToFire(this.m_PredictedLocation) && BotFuncs.isInBattlefield(this.m_PredictedLocation)) {
                double dAngle = Math.toDegrees(BotFuncs.getAbsBearing(PredictedLoc, loc));
                VirtualBullet virtualBullet = new VirtualBullet(dAngle, dFirepower, loc, BotFuncs.getTarget(), this, dVelFactor);
            }
            ++iCount;
        }
    }

    protected void loadData(String element) {
        super.loadData(element);
        FileHandler FH = this.m_Log.getFileHandler();
        int iCount = 0;
        while (iCount < TOTAL_VELOCITY_FACTORS) {
            String FactorAverage = FH.getItem(element, "vf" + iCount);
            if (FactorAverage != null) {
                this.m_dVirtualAverages[iCount] = Double.valueOf(FactorAverage);
            }
            ++iCount;
        }
    }

    protected void saveData(String element) {
        super.saveData(element);
        FileHandler FH = this.m_Log.getFileHandler();
        int iCount = 0;
        while (iCount < TOTAL_VELOCITY_FACTORS) {
            String ElementName = "vf" + iCount;
            FH.addItem(element, ElementName, String.valueOf(this.m_dVirtualAverages[iCount]));
            ++iCount;
        }
    }

    protected Location getPrediction(long time) {
        double dHighestScore = 0.0;
        int iBestGuessFactor = 0;
        int iCount = 0;
        while (iCount < TOTAL_VELOCITY_FACTORS) {
            double dCurrentScore = this.m_dVirtualAverages[iCount];
            if (dCurrentScore > dHighestScore) {
                dHighestScore = dCurrentScore;
                iBestGuessFactor = iCount;
            }
            ++iCount;
        }
        return this.getGuess(time, this.translate(iBestGuessFactor));
    }

    protected Location getGuess(long time, double guessfactor) {
        RobotSnapshot Snap = this.m_Log.get(0);
        if (Snap != null) {
            double dDeltaX = 0.0;
            double dDeltaY = 0.0;
            double dHeading = Snap.m_dAngle;
            double dAverageVelocity = 0.0;
            int iLookBack = Math.min(30, this.m_Log.getSnapshotSize());
            int iCount = 0;
            while (iCount < iLookBack) {
                dAverageVelocity += this.m_Log.get((int)iCount).m_dVelocity;
                ++iCount;
            }
            dAverageVelocity /= (double)iLookBack;
            dAverageVelocity *= guessfactor;
            iCount = 0;
            while (iCount < (int)time) {
                dDeltaX += dAverageVelocity * Math.sin(Math.toRadians(dHeading += Snap.m_dDeltaAngle));
                dDeltaY += dAverageVelocity * Math.cos(Math.toRadians(dHeading));
                ++iCount;
            }
            return new Location(Snap.m_Location.getX() + dDeltaX, Snap.m_Location.getY() + dDeltaY);
        }
        return null;
    }

    protected int translate(double velfactor) {
        if (velfactor == -1.0) {
            return 0;
        }
        if (velfactor == -0.8) {
            return 1;
        }
        if (velfactor == -0.6) {
            return 2;
        }
        if (velfactor == -0.4) {
            return 3;
        }
        if (velfactor == -0.2) {
            return 4;
        }
        if (velfactor == 0.0) {
            return 5;
        }
        if (velfactor == 0.2) {
            return 6;
        }
        if (velfactor == 0.4) {
            return 7;
        }
        if (velfactor == 0.6) {
            return 8;
        }
        if (velfactor == 0.8) {
            return 9;
        }
        if (velfactor == 1.0) {
            return 10;
        }
        return 0;
    }

    protected double translate(int arrayindex) {
        switch (arrayindex) {
            case 0: {
                return -1.0;
            }
            case 1: {
                return -0.8;
            }
            case 2: {
                return -0.6;
            }
            case 3: {
                return -0.4;
            }
            case 4: {
                return -0.2;
            }
            case 5: {
                return 0.0;
            }
            case 6: {
                return 0.2;
            }
            case 7: {
                return 0.4;
            }
            case 8: {
                return 0.6;
            }
            case 9: {
                return 0.8;
            }
            case 10: {
                return 1.0;
            }
        }
        return 0.0;
    }
}

