/*
 * Decompiled with CFR 0.152.
 */
package catcat20.jewel.iolite.utils.ags.utils.dataStructures;

import catcat20.jewel.iolite.utils.ags.utils.dataStructures.MaxHeap;
import catcat20.jewel.iolite.utils.ags.utils.dataStructures.MinHeap;
import java.util.Arrays;

public abstract class BinaryHeap<T> {
    protected static final int defaultCapacity = 64;
    private final int direction;
    private Object[] data;
    private double[] keys;
    private int capacity;
    private int size;

    protected BinaryHeap(int capacity, int direction) {
        this.direction = direction;
        this.data = new Object[capacity];
        this.keys = new double[capacity];
        this.capacity = capacity;
        this.size = 0;
    }

    public void offer(double key, T value) {
        if (this.size >= this.capacity) {
            this.capacity *= 2;
            this.data = Arrays.copyOf(this.data, this.capacity);
            this.keys = Arrays.copyOf(this.keys, this.capacity);
        }
        this.data[this.size] = value;
        this.keys[this.size] = key;
        this.siftUp(this.size);
        ++this.size;
    }

    protected void removeTip() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        --this.size;
        this.data[0] = this.data[this.size];
        this.keys[0] = this.keys[this.size];
        this.data[this.size] = null;
        this.siftDown(0);
    }

    protected void replaceTip(double key, T value) {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        this.data[0] = value;
        this.keys[0] = key;
        this.siftDown(0);
    }

    protected T getTip() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        return (T)this.data[0];
    }

    protected double getTipKey() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        return this.keys[0];
    }

    private void siftUp(int c) {
        int p = (c - 1) / 2;
        while (c != 0 && (double)this.direction * this.keys[c] > (double)this.direction * this.keys[p]) {
            Object pData = this.data[p];
            double pDist = this.keys[p];
            this.data[p] = this.data[c];
            this.keys[p] = this.keys[c];
            this.data[c] = pData;
            this.keys[c] = pDist;
            c = p;
            p = (c - 1) / 2;
        }
    }

    private void siftDown(int p) {
        int c = p * 2 + 1;
        while (c < this.size) {
            if (c + 1 < this.size && (double)this.direction * this.keys[c] < (double)this.direction * this.keys[c + 1]) {
                ++c;
            }
            if (!((double)this.direction * this.keys[p] < (double)this.direction * this.keys[c])) break;
            Object pData = this.data[p];
            double pDist = this.keys[p];
            this.data[p] = this.data[c];
            this.keys[p] = this.keys[c];
            this.data[c] = pData;
            this.keys[c] = pDist;
            p = c;
            c = p * 2 + 1;
        }
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public static final class Min<T>
    extends BinaryHeap<T>
    implements MinHeap<T> {
        public Min() {
            super(64, -1);
        }

        public Min(int capacity) {
            super(capacity, -1);
        }

        @Override
        public void removeMin() {
            this.removeTip();
        }

        @Override
        public void replaceMin(double key, T value) {
            this.replaceTip(key, value);
        }

        @Override
        public T getMin() {
            return this.getTip();
        }

        @Override
        public double getMinKey() {
            return this.getTipKey();
        }
    }

    public static final class Max<T>
    extends BinaryHeap<T>
    implements MaxHeap<T> {
        public Max() {
            super(64, 1);
        }

        public Max(int capacity) {
            super(capacity, 1);
        }

        @Override
        public void removeMax() {
            this.removeTip();
        }

        @Override
        public void replaceMax(double key, T value) {
            this.replaceTip(key, value);
        }

        @Override
        public T getMax() {
            return this.getTip();
        }

        @Override
        public double getMaxKey() {
            return this.getTipKey();
        }
    }
}

