/*
 * Decompiled with CFR 0.152.
 */
package voidious.utils;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.util.Utils;
import voidious.utils.DiaUtils;
import voidious.utils.RobotState;

public class DiaWave {
    public static final Point2D.Double ORIGIN = new Point2D.Double(0.0, 0.0);
    public static final double MAX_GUESSFACTOR = 1.0;
    public static final int CLOCKWISE = 1;
    public static final int COUNTERCLOCKWISE = -1;
    public static final boolean FIRING_WAVE = true;
    public static final boolean SURFABLE_WAVE = true;
    public static final boolean ANY_WAVE = false;
    public static final boolean POSITIVE_GUESSFACTOR = true;
    public static final boolean NEGATIVE_GUESSFACTOR = false;
    public static final double NO_CACHED_ESCAPE_ANGLE = -1.0;
    public static final double ANY_BULLET_POWER = -1.0;
    protected static final double BOT_HALF_WIDTH = 18.0;
    protected static final double MAX_WAVE_INTERCEPT_OFFSET = 18.0 / Math.cos(0.7853981633974483);
    public long fireTime;
    public Point2D.Double sourceLocation;
    public Point2D.Double targetLocation;
    public double absBearing;
    public double bulletPower;
    public double bulletSpeed;
    public int orbitDirection;
    public boolean processedBulletHit;
    public boolean processedPassed;
    public boolean processedWaveBreak;
    public boolean firingWave;
    public String botName;
    public double targetHeading;
    public double targetRelativeHeading;
    public double targetVelocity;
    public double targetAccel;
    public int targetVelocitySign;
    public double targetDistance;
    public double targetDistNearest;
    public double targetDchangeTime;
    public double targetVchangeTime;
    public double targetWallDistance;
    public double targetRevWallDistance;
    public double targetDl8t;
    public double targetDl20t;
    public double targetDl40t;
    public double targetAgHeading;
    public double targetAgForce;
    public double targetCornerDistance;
    public double targetCornerBearing;
    public double targetEnergy;
    public double sourceEnergy;
    public double gunHeat;
    public long lastBulletFiredTime;
    public int enemiesAlive;
    protected Point2D.Double waveBreakLocation;
    protected long waveBreakTime;
    public double waveBreakDistance;
    public Point2D.Double prevLocation;
    public long prevLocationTime;
    public boolean altWave;
    public ArrayList<RobotState> waveBreakStates;
    public boolean interceptStarted;
    protected Rectangle2D.Double _fieldRect;
    protected double _fieldWidth;
    protected double _fieldHeight;
    public int id;
    public int lastSeenId;
    protected double _cachedPositiveEscapeAngle = -1.0;
    protected double _cachedNegativeEscapeAngle = -1.0;
    public boolean usedNegativeSmoothingMea = false;
    public boolean usedPositiveSmoothingMea = false;

    public DiaWave() {
    }

    public DiaWave(Point2D.Double source, Point2D.Double target, Point2D.Double orbitLocation, long time, double power, String name, double heading, double velocity, double accel, int vSign, double distance, double dtnb, double dChange, double vChange, double wallDist1, double wallDist2, double dl8t, double dl20t, double dl40t, double agh, double agf, double cd, double cb, double energy, double sEnergy, int alive, double gh, long lastBulletFiredTime, Rectangle2D.Double field, double width, double height) {
        this.sourceLocation = source;
        this.targetLocation = target;
        this.fireTime = time;
        this.setBulletPower(power);
        this.absBearing = DiaUtils.absoluteBearing(source, target);
        this.botName = name;
        this.targetHeading = heading;
        this.targetVelocity = velocity;
        this.targetAccel = accel;
        this.targetVelocitySign = vSign;
        this.targetDistance = distance;
        this.targetDistNearest = dtnb;
        this.targetDchangeTime = dChange;
        this.targetVchangeTime = vChange;
        this.targetDl8t = dl8t;
        this.targetDl20t = dl20t;
        this.targetDl40t = dl40t;
        this.targetAgForce = agf;
        this.targetCornerDistance = cd;
        this.targetEnergy = energy;
        this.sourceEnergy = sEnergy;
        this.enemiesAlive = alive;
        this.gunHeat = gh;
        this.lastBulletFiredTime = lastBulletFiredTime;
        double orbitRelativeHeading = Utils.normalRelativeAngle((double)(this.effectiveHeading() - DiaUtils.absoluteBearing(orbitLocation, this.targetLocation)));
        this.orbitDirection = orbitRelativeHeading < 0.0 ? -1 : 1;
        this.targetRelativeHeading = Math.abs(orbitRelativeHeading);
        this.targetAgHeading = Utils.normalRelativeAngle((double)(agh - this.effectiveHeading())) * (double)this.orbitDirection;
        this.targetCornerBearing = Utils.normalRelativeAngle((double)(cb - this.effectiveHeading())) * (double)this.orbitDirection;
        this.setWallDistance(this.sourceLocation, wallDist1, wallDist2);
        this._fieldRect = field;
        this._fieldWidth = width;
        this._fieldHeight = height;
        this.processedBulletHit = false;
        this.processedPassed = false;
        this.processedWaveBreak = false;
        this.waveBreakLocation = null;
        this.prevLocation = this.targetLocation;
        this.prevLocationTime = this.fireTime;
        this.firingWave = false;
        this.altWave = false;
        this.waveBreakStates = new ArrayList();
        this.interceptStarted = false;
    }

    public void setBulletPower(double power) {
        this.bulletPower = power;
        this.bulletSpeed = 20.0 - 3.0 * power;
    }

    public void setWallDistance(Point2D.Double orbitLocation, double wallDist1, double wallDist2) {
        if (this.orbitDirection == -1 && this.enemiesAlive == 1) {
            this.targetWallDistance = wallDist2;
            this.targetRevWallDistance = wallDist1;
        } else {
            this.targetWallDistance = wallDist1;
            this.targetRevWallDistance = wallDist2;
        }
    }

    public boolean wavePassedInterpolate(Point2D.Double lastScanLocation, long lastScanTime, long currentTime) {
        return this.wavePassedInterpolate(lastScanLocation, lastScanTime, currentTime, 0);
    }

    public boolean wavePassedInterpolate(Point2D.Double lastScanLocation, long lastScanTime, long currentTime, int offset) {
        if (this.processedPassed) {
            return true;
        }
        if (lastScanTime == currentTime) {
            if (this.interceptStarted || this.pastFrontBumper(lastScanLocation, currentTime, offset)) {
                this.interceptStarted = true;
                if (currentTime - this.prevLocationTime > 1L) {
                    double deltaDistance = lastScanLocation.distance(this.prevLocation) / (double)(currentTime - this.prevLocationTime);
                    double deltaBearing = DiaUtils.absoluteBearing(this.prevLocation, lastScanLocation);
                    double dbSin = Math.sin(deltaBearing);
                    double dbCos = Math.cos(deltaBearing);
                    for (long x = this.prevLocationTime + 1L; x < currentTime; ++x) {
                        long interpoTime = x - this.prevLocationTime;
                        Point2D.Double interpoLocation = DiaUtils.project(this.prevLocation, dbSin, dbCos, (double)interpoTime * deltaDistance);
                        if (!this.pastFrontBumper(interpoLocation, x, offset)) continue;
                        if (this.waveGone(interpoLocation, x)) {
                            int medianBreakIndex = Math.min(this.waveBreakStates.size() / 2 + this.waveBreakStates.size() % 2, this.waveBreakStates.size() - 1);
                            RobotState waveBreakState = this.waveBreakStates.get(medianBreakIndex);
                            this.waveBreakLocation = waveBreakState.location;
                            this.waveBreakTime = waveBreakState.time;
                            this.processedPassed = true;
                            break;
                        }
                        this.waveBreakStates.add(new RobotState(interpoLocation, 0.0, 0.0, x));
                    }
                }
                if (this.processedPassed || this.waveGone(lastScanLocation, currentTime)) {
                    if (this.waveBreakStates.isEmpty()) {
                        System.out.println("WARNING: Anomaly in wave break interpolation - no wave break states.");
                        System.out.println("  lastScanTime = currentTime = " + currentTime);
                        System.out.println("  prevLocation: " + DiaUtils.round(this.prevLocation.x, 1) + ", " + DiaUtils.round(this.prevLocation.y, 1));
                        System.out.println("  prevLocationTime: " + this.prevLocationTime);
                    }
                    if (this.waveBreakStates.size() > 21) {
                        System.out.println("WARNING: Too many wave break states: " + this.waveBreakStates.size() + " @ " + currentTime + " (bullet speed: " + DiaUtils.round(this.bulletSpeed, 2) + ")");
                        for (RobotState state : this.waveBreakStates) {
                            for (RobotState state2 : this.waveBreakStates) {
                                if (state.time != state2.time || state == state2) continue;
                                System.out.println("  Duplicate time: " + state.time);
                            }
                            if (!this.pastFrontBumper(state.location, state.time, 0)) {
                                System.out.println("  Not there yet @ " + state.time);
                            }
                            if (this.waveGone(state.location, state.time)) {
                                System.out.println("  Already gone @ " + state.time);
                            }
                            double bulletDistance = this.bulletSpeed * (double)(state.time - this.fireTime);
                            double botDistance = this.sourceLocation.distance(state.location);
                            System.out.println("  " + state.time + ": " + DiaUtils.round(bulletDistance, 2) + " vs " + DiaUtils.round(botDistance, 2) + ", diff: " + DiaUtils.round(botDistance - bulletDistance, 2) + ", bumper: " + DiaUtils.round(DiaUtils.preciseFrontBumperOffset(this.sourceLocation, state.location), 2));
                        }
                    }
                    this.processedPassed = true;
                } else {
                    this.waveBreakStates.add(new RobotState(lastScanLocation, 0.0, 0.0, lastScanTime));
                }
            }
            this.prevLocation = lastScanLocation;
            this.prevLocationTime = lastScanTime;
        }
        return this.processedPassed;
    }

    public boolean pastFrontBumper(Point2D.Double lastScanLocation, long currentTime, int offset) {
        double bulletDistance;
        double enemyDistSq = this.sourceLocation.distanceSq(lastScanLocation);
        return enemyDistSq < DiaUtils.square((double)offset + (bulletDistance = this.bulletSpeed * (double)(currentTime - this.fireTime + 1L)) + MAX_WAVE_INTERCEPT_OFFSET) && enemyDistSq < DiaUtils.square((double)offset + bulletDistance + DiaUtils.preciseFrontBumperOffset(this.sourceLocation, lastScanLocation));
    }

    public boolean wavePassed(Point2D.Double enemyLocation, long currentTime, double interceptOffset) {
        double threshold = this.bulletSpeed * (double)(currentTime - this.fireTime) + interceptOffset;
        return threshold > 0.0 && enemyLocation.distanceSq(this.sourceLocation) < DiaUtils.square(threshold);
    }

    public boolean waveGone(Point2D.Double enemyLocation, long currentTime) {
        double bulletDistanceTraveledSq = DiaUtils.square(this.bulletSpeed * (double)(currentTime - this.fireTime));
        ArrayList<Point2D.Double> corners = DiaUtils.botCorners(enemyLocation);
        for (Point2D.Double corner : corners) {
            if (!(corner.distanceSq(this.sourceLocation) > bulletDistanceTraveledSq)) continue;
            return false;
        }
        return true;
    }

    public Point2D.Double waveBreakLocation() {
        if (this.waveBreakLocation == null) {
            return this.prevLocation;
        }
        return this.waveBreakLocation;
    }

    public long waveBreakTime() {
        if (this.waveBreakLocation == null) {
            return this.prevLocationTime;
        }
        return this.waveBreakTime;
    }

    public long waveBreakBulletTicks() {
        return this.waveBreakBulletTicks(this.waveBreakTime());
    }

    public long waveBreakBulletTicks(long waveBreakTime) {
        return waveBreakTime - this.fireTime;
    }

    public double effectiveHeading() {
        return Utils.normalAbsoluteAngle((double)(this.targetHeading + (this.targetVelocitySign == 1 ? 0.0 : Math.PI)));
    }

    public Point2D.Double displacementVector() {
        return this.displacementVector(this.waveBreakLocation(), this.waveBreakTime());
    }

    public Point2D.Double displacementVector(Point2D.Double botLocation, long time) {
        double vectorBearing = Utils.normalRelativeAngle((double)(DiaUtils.absoluteBearing(this.targetLocation, botLocation) - this.effectiveHeading()));
        double vectorDistance = this.targetLocation.distance(botLocation) / (double)this.waveBreakBulletTicks(time);
        return DiaUtils.project(ORIGIN, vectorBearing * (double)this.orbitDirection, vectorDistance);
    }

    public double firingAngleFromDisplacementVector(Point2D.Double dispVector) {
        return Utils.normalAbsoluteAngle((double)DiaUtils.absoluteBearing(this.sourceLocation, this.projectLocation(dispVector)));
    }

    public double firingAngleFromTargetLocation(Point2D.Double firingTarget) {
        return Utils.normalAbsoluteAngle((double)DiaUtils.absoluteBearing(this.sourceLocation, firingTarget));
    }

    public Point2D.Double projectLocationBlind(Point2D.Double myNextLocation, Point2D.Double dispVector, long currentTime) {
        return this.projectLocation(myNextLocation, dispVector, currentTime - this.fireTime + 1L);
    }

    public Point2D.Double projectLocation(Point2D.Double dispVector) {
        return this.projectLocation(this.sourceLocation, dispVector, 0L);
    }

    public Point2D.Double projectLocation(Point2D.Double firingLocation, Point2D.Double dispVector, long extraTicks) {
        Point2D.Double projectedLocation;
        double dispAngle = this.effectiveHeading() + DiaUtils.absoluteBearing(ORIGIN, dispVector) * (double)this.orbitDirection;
        double dispDistance = ORIGIN.distance(dispVector);
        long bulletTicks = DiaUtils.bulletTicksFromSpeed(firingLocation.distance(this.targetLocation), this.bulletSpeed) - 1;
        long prevBulletTicks = 0L;
        int sanityCounter = 0;
        double daSin = Math.sin(dispAngle);
        double daCos = Math.cos(dispAngle);
        do {
            projectedLocation = DiaUtils.project(this.targetLocation, daSin, daCos, (double)(bulletTicks + extraTicks) * dispDistance);
            long prevPrevBulletTicks = prevBulletTicks;
            prevBulletTicks = bulletTicks;
            bulletTicks = DiaUtils.bulletTicksFromSpeed(firingLocation.distance(projectedLocation), this.bulletSpeed) - 1;
            if (bulletTicks != prevPrevBulletTicks) continue;
            projectedLocation = DiaUtils.project(this.targetLocation, daSin, daCos, ((double)(bulletTicks + prevBulletTicks) / 2.0 + (double)extraTicks) * dispDistance);
            break;
        } while (bulletTicks != prevBulletTicks && sanityCounter++ < 20);
        return projectedLocation;
    }

    public double distanceTraveled(long currentTime) {
        return (double)(currentTime - this.fireTime) * this.bulletSpeed;
    }

    public double guessFactor(Point2D.Double targetLocation) {
        double bearingToTarget = DiaUtils.absoluteBearing(this.sourceLocation, targetLocation);
        return this.guessFactor(bearingToTarget);
    }

    public double guessFactor(double bearingToTarget) {
        double guessAngle = (double)this.orbitDirection * Utils.normalRelativeAngle((double)(bearingToTarget - this.absBearing));
        double maxEscapeAngle = Math.asin(8.0 / this.bulletSpeed);
        return guessAngle / maxEscapeAngle;
    }

    public double guessFactorPrecise(Point2D.Double targetLocation) {
        double newBearingToTarget = DiaUtils.absoluteBearing(this.sourceLocation, targetLocation);
        return this.guessFactorPrecise(newBearingToTarget);
    }

    public double guessFactorPrecise(double newBearingToTarget) {
        double guessAngle = (double)this.orbitDirection * Utils.normalRelativeAngle((double)(newBearingToTarget - this.absBearing));
        double maxEscapeAngle = this.preciseEscapeAngle(guessAngle >= 0.0);
        return guessAngle / maxEscapeAngle;
    }

    public double lateralVelocity() {
        return Math.sin(this.targetRelativeHeading) * Math.abs(this.targetVelocity);
    }

    public double escapeAngleRange() {
        return this.preciseEscapeAngle(true) + this.preciseEscapeAngle(false);
    }

    public double preciseEscapeAngle(boolean positiveGuessFactor) {
        if (positiveGuessFactor) {
            if (this._cachedPositiveEscapeAngle == -1.0) {
                this._cachedPositiveEscapeAngle = this.uncachedPreciseEscapeAngle(positiveGuessFactor) * 1.0;
            }
            return this._cachedPositiveEscapeAngle;
        }
        if (this._cachedNegativeEscapeAngle == -1.0) {
            this._cachedNegativeEscapeAngle = this.uncachedPreciseEscapeAngle(positiveGuessFactor) * 1.0;
        }
        return this._cachedNegativeEscapeAngle;
    }

    public double firingAngle(double guessFactor) {
        return this.absBearing + guessFactor * (double)this.orbitDirection * Math.asin(8.0 / this.bulletSpeed);
    }

    public double virtuality() {
        long timeSinceLastBullet = this.fireTime - this.lastBulletFiredTime;
        long timeToNextBullet = Math.round(Math.ceil(this.gunHeat * 10.0));
        if (this.firingWave) {
            return 0.0;
        }
        if (this.lastBulletFiredTime > 0L) {
            return (double)Math.min(timeSinceLastBullet, timeToNextBullet) / 8.0;
        }
        return Math.min(1.0, (double)timeToNextBullet / 8.0);
    }

    public double uncachedPreciseEscapeAngle(boolean positiveGuessFactor) {
        boolean hitWall = false;
        boolean wavePassed = false;
        RobotState predictedState = new RobotState((Point2D.Double)this.targetLocation.clone(), this.targetHeading, this.targetVelocity);
        long predictedTime = this.fireTime;
        boolean clockwisePrediction = this.orbitDirection == 1 && positiveGuessFactor || this.orbitDirection == -1 && !positiveGuessFactor;
        double noSmoothingEscapeAngle = 0.0;
        double bulletVelocity = this.bulletSpeed;
        do {
            predictedState = DiaUtils.nextPerpendicularLocation(predictedState.location, this.absBearing, predictedState.velocity, predictedState.heading, clockwisePrediction, predictedTime, true);
            predictedTime = predictedState.time;
            if (!this._fieldRect.contains(predictedState.location)) {
                hitWall = true;
                continue;
            }
            if (!this.wavePassed(predictedState.location, predictedTime, bulletVelocity)) continue;
            wavePassed = true;
        } while (!hitWall && !wavePassed);
        noSmoothingEscapeAngle = Math.abs(Utils.normalRelativeAngle((double)(DiaUtils.absoluteBearing(this.sourceLocation, predictedState.location) - this.absBearing)));
        double withSmoothingEscapeAngle = 0.0;
        if (hitWall) {
            double wallSmoothingStick = 80.0;
            double purelyPerpendicularAttackAngle = 0.0;
            double fullVelocity = 8.0;
            double orbitAbsBearing = this.absBearing;
            double bestSmoothingEscapeAngle = 0.0;
            for (int x = 0; x < 3; ++x) {
                wavePassed = false;
                predictedState = new RobotState((Point2D.Double)this.targetLocation.clone(), this.targetHeading, this.targetVelocity);
                predictedTime = this.fireTime;
                do {
                    predictedState = DiaUtils.nextPerpendicularWallSmoothedLocation(predictedState.location, orbitAbsBearing, predictedState.velocity, fullVelocity, predictedState.heading, purelyPerpendicularAttackAngle, clockwisePrediction, predictedTime, this._fieldRect, this._fieldWidth, this._fieldHeight, wallSmoothingStick, false);
                    predictedTime = predictedState.time;
                    if (!this.wavePassed(predictedState.location, predictedTime, bulletVelocity)) continue;
                    wavePassed = true;
                } while (!wavePassed);
                orbitAbsBearing = DiaUtils.absoluteBearing(this.targetLocation, predictedState.location) - (double)(clockwisePrediction ? 1 : -1) * 1.5707963267948966;
                bestSmoothingEscapeAngle = Math.max(bestSmoothingEscapeAngle, Math.abs(Utils.normalRelativeAngle((double)(DiaUtils.absoluteBearing(this.sourceLocation, predictedState.location) - this.absBearing))));
            }
            withSmoothingEscapeAngle = bestSmoothingEscapeAngle;
        }
        return Math.max(noSmoothingEscapeAngle, withSmoothingEscapeAngle);
    }

    public void clearCachedPreciseEscapeAngles() {
        this._cachedPositiveEscapeAngle = -1.0;
        this._cachedNegativeEscapeAngle = -1.0;
    }
}

