/*
 * Decompiled with CFR 0.152.
 */
package catcat20.utils;

import java.awt.geom.Point2D;

public class LUtils {
    private static final double HALF_PI = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;

    private LUtils() {
    }

    public static int bulletTicksFromPower(double distance, double power) {
        return (int)Math.ceil(distance / (20.0 - 3.0 * power));
    }

    public static double bulletPowerFromVelocity(double velocity) {
        return (20.0 - velocity) / 3.0;
    }

    public static double normalizeAngle(double angle, double reference) {
        double normDiff = reference - angle;
        while (Math.abs(normDiff) > Math.PI) {
            normDiff = reference - (angle += Math.signum(normDiff) * (Math.PI * 2));
        }
        return angle;
    }

    public static double maxEscapeAngle(double bulletVelocity) {
        return Math.asin(8.0 / bulletVelocity);
    }

    public static double square(double d) {
        return d * d;
    }

    public static double cube(double d) {
        return d * d * d;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static Point2D.Double projectWithCache(Point2D.Double sourceLocation, double angle, double length, Point2D.Double cache) {
        cache.setLocation(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
        return cache;
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double absoluteBearing(double sx, double sy, double tx, double ty) {
        return Math.atan2(tx - sx, ty - sy);
    }

    public static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int limit(int min, int value, int max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double accel(double velocity, double previousVelocity) {
        double accel = velocity - previousVelocity;
        accel = previousVelocity == 0.0 ? Math.abs(accel) : (accel *= Math.signum(previousVelocity));
        return accel;
    }
}

