/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.Footprint;
import agd.predict.TargetPrediction;
import agd.util.Coord;
import agd.util.RollingAverage;
import java.util.List;
import java.util.ListIterator;

class AverageGridPrediction
extends TargetPrediction {
    private int period = 0;

    public AverageGridPrediction() {
        this(0);
    }

    public AverageGridPrediction(int period) {
        this.period = period;
    }

    public Coord predictTarget(List recentFootprints, long time) {
        Coord predictPos = null;
        if (recentFootprints.size() > 0) {
            double newx;
            ListIterator lit = recentFootprints.listIterator(recentFootprints.size());
            Footprint mostRecentfp = (Footprint)recentFootprints.get(recentFootprints.size() - 1);
            long earliestTime = 0L;
            if (this.period > 0) {
                earliestTime = mostRecentfp.getTime() - (long)this.period;
            }
            RollingAverage xvelocity = new RollingAverage();
            RollingAverage yvelocity = new RollingAverage();
            Footprint fp = null;
            Footprint moreRecentFp = mostRecentfp;
            lit.previous();
            while (lit.hasPrevious()) {
                fp = (Footprint)lit.previous();
                if (fp.getTime() < earliestTime) break;
                double xvel = (moreRecentFp.getPosition().getX() - fp.getPosition().getX()) / (double)(moreRecentFp.getTime() - fp.getTime());
                double yvel = (moreRecentFp.getPosition().getY() - fp.getPosition().getY()) / (double)(moreRecentFp.getTime() - fp.getTime());
                xvelocity.nextValue(xvel);
                yvelocity.nextValue(yvel);
                moreRecentFp = fp;
            }
            double extrapPeriod = time - mostRecentfp.getTime();
            if (Math.abs(xvelocity.getAverage()) > Math.abs(yvelocity.getAverage())) {
                newx = mostRecentfp.getPosition().getX() + xvelocity.getAverage() * extrapPeriod;
                double newy = mostRecentfp.getPosition().getY();
                predictPos = new Coord(newx, newy);
            } else {
                newx = mostRecentfp.getPosition().getX();
                double newy = mostRecentfp.getPosition().getY() + yvelocity.getAverage() * extrapPeriod;
                predictPos = new Coord(newx, newy);
            }
        }
        return predictPos;
    }

    public String toString() {
        return "Av grid(" + this.period + ")";
    }
}

