/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.Footprint;
import agd.predict.TargetPrediction;
import agd.util.Compass;
import agd.util.Coord;
import java.util.List;
import java.util.ListIterator;

class PrevDeltaPrediction
extends TargetPrediction {
    PrevDeltaPrediction() {
    }

    public Coord predictTarget(List recentFootprints, long wantedtime) {
        Coord predPos = null;
        if (recentFootprints.size() >= 1) {
            ListIterator lit = recentFootprints.listIterator(recentFootprints.size());
            Footprint lastFp = (Footprint)lit.previous();
            Compass heading = lastFp.getHeading();
            long lasttime = lastFp.getTime();
            double velocity = lastFp.getVelocity();
            long predTime = lastFp.getTime();
            predPos = lastFp.getPosition();
            Compass predHeading = lastFp.getHeading();
            while (predTime < wantedtime && lit.hasPrevious()) {
                lastFp = (Footprint)lit.previous();
                double deltaBearing = lastFp.getHeading().bearingTo(heading);
                double deltavelocity = (lastFp.getVelocity() + velocity) / 2.0;
                long deltatime = lasttime - lastFp.getTime();
                double deltadistance = deltavelocity * (double)deltatime;
                predHeading = new Compass(predHeading.getDegrees() + deltaBearing);
                predPos = predPos.applyVector(predHeading, deltadistance);
                predTime += deltatime;
                velocity = lastFp.getVelocity();
                heading = lastFp.getHeading();
                lasttime = lastFp.getTime();
            }
        }
        return predPos;
    }

    public String toString() {
        return "Prev d";
    }
}

