/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.decomposition.AbstractDecompositor;
import org.la4j.decomposition.MatrixDecompositor;

public class CholeskyDecompositor
extends AbstractDecompositor
implements MatrixDecompositor {
    public CholeskyDecompositor(Matrix matrix) {
        super(matrix);
    }

    @Override
    public Matrix[] decompose() {
        Matrix l = this.matrix.blankOfShape(this.matrix.rows(), this.matrix.rows());
        for (int j = 0; j < l.rows(); ++j) {
            int k;
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += l.get(k, i) * l.get(j, i);
                }
                s = (this.matrix.get(j, k) - s) / l.get(k, k);
                l.set(j, k, s);
                d += s * s;
            }
            d = this.matrix.get(j, j) - d;
            l.set(j, j, Math.sqrt(Math.max(d, 0.0)));
            for (k = j + 1; k < l.rows(); ++k) {
                l.set(j, k, 0.0);
            }
        }
        return new Matrix[]{l};
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        return matrix.rows() == matrix.columns() && matrix.is(Matrices.SYMMETRIC_MATRIX) && matrix.is(Matrices.POSITIVE_DEFINITE_MATRIX);
    }
}

