/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import java.awt.geom.Point2D;

public class Util {
    public static final int STRING_CENTERED = 0;
    public static final int STRING_LEFT = 1;
    public static final int STRING_RIGHT = 2;
    private static final double HALF_PI = 1.5707963267948966;

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double absoluteBearing(double sourceX, double sourceY, double targetX, double targetY) {
        return Math.atan2(targetX - sourceX, targetY - sourceY);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static String roundString(double number, int places) {
        String s = Double.toString(number);
        if (s.indexOf(".") + places + 1 < s.length()) {
            s = s.substring(0, s.indexOf(".") + places + 1);
        }
        while (s.indexOf(".") + places + 1 > s.length()) {
            s = String.valueOf(s) + "0";
        }
        return s;
    }

    public static String formatNumber(double number, int length) {
        String s = Double.toString(number);
        return Util.padString(s, length, true);
    }

    public static String formatNumber(double number, int length, int places) {
        String s = Util.roundString(number, places);
        return Util.padString(s, length, false);
    }

    public static String formatNumber(long number, int length) {
        String s = Long.toString(number);
        return Util.padString(s, length, false);
    }

    public static String padString(String s, int length, boolean padZeroes) {
        return Util.padString(s, length, padZeroes, 1);
    }

    /*
     * Unable to fully structure code
     */
    public static String padString(String s, int length, boolean padZeroes, int alignment) {
        if (s.length() <= length) ** GOTO lbl15
        return s.substring(0, length);
lbl-1000:
        // 1 sources

        {
            if (padZeroes && s.contains(".")) {
                s = String.valueOf(s) + "0";
                continue;
            }
            switch (alignment) {
                case 1: {
                    s = String.valueOf(s) + " ";
                    break;
                }
                case 0: {
                    s = String.valueOf(s) + " ";
                    if (s.length() == length) continue block5;
                }
                case 2: {
                    s = " " + s;
                }
            }
lbl15:
            // 6 sources

            ** while (s.length() < length)
        }
lbl16:
        // 1 sources

        return s;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static double backAsFrontTurn(double relativeHeading) {
        if (Math.abs(relativeHeading) > 1.5707963267948966) {
            return relativeHeading + (relativeHeading < 0.0 ? Math.PI : -Math.PI);
        }
        return relativeHeading;
    }

    public static int backAsFrontAhead(double relativeHeading) {
        if (Math.abs(relativeHeading) > 1.5707963267948966) {
            return -1;
        }
        return 1;
    }
}

