/*
 * Decompiled with CFR 0.152.
 */
package origin;

import java.awt.geom.Point2D;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import origin.Enemy;
import origin.SleepSiphon;

public class Util {
    private static double[] fieldBounds;
    private static double[] absoluteFieldBounds;

    public static Enemy getOldest(ConcurrentHashMap<String, Enemy> enemies, SleepSiphon self) {
        String oldestName = "";
        long oldestTime = 0L;
        for (Map.Entry<String, Enemy> entry : enemies.entrySet()) {
            long entryTime = entry.getValue().timeSinceUpdate((int)self.getTime());
            if (entryTime <= oldestTime) continue;
            oldestName = entry.getKey();
            oldestTime = entryTime;
        }
        return enemies.get(oldestName);
    }

    public static String getOldestName(ConcurrentHashMap<String, Enemy> enemies, SleepSiphon self) {
        String oldestName = "";
        long oldestTime = 0L;
        for (Map.Entry<String, Enemy> entry : enemies.entrySet()) {
            long entryTime = entry.getValue().timeSinceUpdate((int)self.getTime());
            if (entryTime > oldestTime) {
                oldestName = entry.getKey();
                oldestTime = entryTime;
                continue;
            }
            if (entryTime != oldestTime || enemies.get(oldestName) == null || entry.getValue().getScanOrder() >= enemies.get(oldestName).getScanOrder()) continue;
            oldestName = entry.getKey();
            oldestTime = entryTime;
        }
        return oldestName;
    }

    public static boolean withinTolerance(double expectedValue, double actualValue, double tolerance) {
        return actualValue >= expectedValue - tolerance && actualValue <= expectedValue + tolerance;
    }

    public static boolean withinTolerance(int expectedValue, int actualValue, int tolerance) {
        return actualValue >= expectedValue - tolerance && actualValue <= expectedValue + tolerance;
    }

    public static boolean isPerfectSquare(int x) {
        boolean isPSquare = false;
        int sr = (int)Math.sqrt(x);
        if ((int)Math.pow(sr, 2.0) == x) {
            isPSquare = true;
        }
        return isPSquare;
    }

    public static int baseConvertToDec(int num, int fromBase) {
        int output = 0;
        int numOfDigits = 0;
        int temp = num;
        while (temp >= 10) {
            temp /= 10;
            ++numOfDigits;
        }
        temp = num;
        int i = 0;
        while (i <= numOfDigits) {
            output += temp % 10 * (int)Math.pow(fromBase, i);
            temp /= 10;
            ++i;
        }
        return output;
    }

    public static int currentSection2DUniform(int numSections, int x, int y, int areaWidth, int areaHeight) {
        if (!Util.isPerfectSquare(numSections)) {
            return -1;
        }
        int section = 0;
        int xTest = 0;
        int yTest = 0;
        int xSec = -1;
        int ySec = -1;
        int oneDimSections = (int)Math.sqrt(numSections);
        while (xSec < (int)Math.sqrt(numSections) - 1 && x >= xTest) {
            xTest += areaWidth / oneDimSections;
            ++xSec;
        }
        while (ySec < (int)Math.sqrt(numSections) - 1 && y >= yTest) {
            yTest += areaWidth / oneDimSections;
            ++ySec;
        }
        section = Util.baseConvertToDec(xSec * 10 + ySec, oneDimSections);
        return section;
    }

    public static Point2D.Double predictLocationLinear(Enemy target, int time) {
        double futureX = target.getX() + target.getVelocity() * (double)time * Math.sin(target.getHeading());
        double futureY = target.getY() + target.getVelocity() * (double)time * Math.cos(target.getHeading());
        return new Point2D.Double(futureX, futureY);
    }

    public static Point2D.Double project(Point2D.Double origin, double direction, double velocity, long time) {
        double futureX = origin.getX() + velocity * (double)time * Math.sin(direction);
        double futureY = origin.getY() + velocity * (double)time * Math.cos(direction);
        return new Point2D.Double(futureX, futureY);
    }

    public static Point2D.Double projectVector(Point2D.Double origin, double direction, double magnitude) {
        double futureX = origin.getX() + magnitude * Math.sin(direction);
        double futureY = origin.getY() + magnitude * Math.cos(direction);
        return new Point2D.Double(futureX, futureY);
    }

    public static double limitValueBounds(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    public static Point2D.Double limitCoordinateToMap(Point2D.Double coord) {
        double[] bounds = Util.getFieldBoundsxXyY();
        return new Point2D.Double(Util.limitValueBounds(coord.getX(), bounds[0], bounds[1]), Util.limitValueBounds(coord.getY(), bounds[2], bounds[3]));
    }

    public static Point2D.Double limitCoordinateToMap(double x, double y) {
        double[] bounds = Util.getFieldBoundsxXyY();
        return new Point2D.Double(Util.limitValueBounds(x, bounds[0], bounds[1]), Util.limitValueBounds(y, bounds[2], bounds[3]));
    }

    public static void changeCoordinateToMap(Point2D point) {
        double[] bounds = Util.getFieldBoundsxXyY();
        point.setLocation(Util.limitValueBounds(point.getX(), bounds[0], bounds[1]), Util.limitValueBounds(point.getY(), bounds[2], bounds[3]));
    }

    public static double[] getAbsoluteFieldBoundsxXyY() {
        return absoluteFieldBounds;
    }

    public static double[] getFieldBoundsxXyY() {
        return fieldBounds;
    }

    public static Point2D.Double getFieldCenter() {
        return new Point2D.Double(absoluteFieldBounds[1] / 2.0, absoluteFieldBounds[3] / 2.0);
    }

    public static void setFieldBoundsArray(SleepSiphon self, double buffer) {
        absoluteFieldBounds = new double[]{0.0, self.getBattleFieldWidth(), 0.0, self.getBattleFieldHeight()};
        fieldBounds = new double[]{self.getWidth() / 2.0 + buffer, self.getBattleFieldWidth() - (self.getWidth() / 2.0 + buffer), self.getHeight() / 2.0 + buffer, self.getBattleFieldHeight() - (self.getHeight() / 2.0 + buffer)};
    }
}

