/*
 * Decompiled with CFR 0.152.
 */
package vjik;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import vjik.CombatMode;
import vjik.Direction;
import vjik.EnemyData;
import vjik.Wall;

public class UnViolationBase
extends AdvancedRobot {
    static final double CHANCE_TO_TURN = 0.05;
    static final double TURN_AMOUNT = 0.6283185307179586;
    static final int MAX_ITERS = 50;
    CombatMode combatMode;
    EnemyData nearEnemy;
    EnemyData lockEnemy;
    Set<EnemyData> enemySet;
    boolean turnFlag;
    boolean tgtLock;
    boolean firing;
    double[] impactPos;

    void init() {
        this.enemySet = new HashSet<EnemyData>(this.getOthers() + 1, 1.0f);
        this.lockEnemy = null;
        this.impactPos = new double[2];
        this.combatMode = CombatMode.MELEE;
        if (this.getOthers() == 1) {
            this.combatMode = CombatMode.DUEL;
        }
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnFlag = false;
    }

    protected void doRadar(EnemyData enemyData) {
        double d = this.getRadarHeadingRadians();
        if (enemyData == null || this.getGunHeat() > 1.0 && this.combatMode != CombatMode.DUEL) {
            if (this.getRadarTurnRemainingRadians() == 0.0) {
                this.setTurnRadarRightRadians(Math.PI * 2);
            }
            return;
        }
        if (enemyData != null) {
            this.setTurnRadarRightRadians(0.0);
            double d2 = this.minRightRadians(d, enemyData.getHdg());
            d2 = d2 > 0.0 ? (d2 < 0.39269908169872414 ? (d2 += 0.39269908169872414) : 0.7853981633974483) : (d2 > -0.39269908169872414 ? (d2 -= 0.39269908169872414) : -0.7853981633974483);
            this.setTurnRadarRightRadians(d2);
            this.tgtLock = true;
        }
    }

    protected void doMove(double d) {
        if (this.getDistanceRemaining() >= 0.0) {
            this.setAhead(d);
        }
        this.turnFlag = Math.abs(this.getTurnRemainingRadians()) > 0.0;
        Direction direction = null;
        this.nearEnemy = null;
        if (!this.enemySet.isEmpty()) {
            Iterator<EnemyData> iterator = this.enemySet.iterator();
            while (iterator.hasNext()) {
                EnemyData enemyData = iterator.next();
                enemyData.updateTgt(this.getX(), this.getY(), this.getHeadingRadians(), this.getTime());
                if (this.nearEnemy == null || enemyData.getDist() < this.nearEnemy.getDist()) {
                    this.nearEnemy = enemyData;
                }
                if (this.getTime() - enemyData.getScanTime() <= 16L) continue;
                iterator.remove();
                if (enemyData == this.lockEnemy) {
                    this.lockEnemy = null;
                    this.tgtLock = false;
                }
                if (enemyData != this.nearEnemy) continue;
                this.nearEnemy = null;
            }
        }
        if (this.findCollision(this.nearEnemy)) {
            direction = this.collisionDir(this.nearEnemy);
            if (this.getVelocity() == 0.0) {
                this.setAhead(-100.0);
            }
            if (direction == Direction.RIGHT) {
                this.setTurnRightRadians(5.0 * this.maxTurn());
            } else {
                this.setTurnLeftRadians(5.0 * this.maxTurn());
            }
        }
        Wall wall = this.closestWall();
        Wall wall2 = this.secondClosestWall();
        boolean bl = false;
        double d2 = this.distWall(wall);
        double d3 = this.distWall(wall2);
        double d4 = Math.min(d2 - this.distToClearWall(wall, Direction.RIGHT), d3 - this.distToClearWall(wall2, Direction.RIGHT));
        double d5 = Math.min(d2 - this.distToClearWall(wall, Direction.LEFT), d3 - this.distToClearWall(wall2, Direction.LEFT));
        boolean bl2 = bl = Math.max(d5, d4) < 10.0;
        if (bl) {
            this.turnFlag = false;
            Direction direction2 = direction = d5 > d4 ? Direction.LEFT : Direction.RIGHT;
            if (direction == Direction.RIGHT) {
                this.setTurnRightRadians(5.0 * this.maxTurn());
            } else {
                this.setTurnLeftRadians(5.0 * this.maxTurn());
            }
        } else if (!this.turnFlag && Math.random() < 0.05) {
            direction = Math.random() < 0.5 ? Direction.LEFT : Direction.RIGHT;
            this.turnFlag = true;
            if (direction == Direction.RIGHT) {
                this.setTurnRightRadians((1.0 + Math.random()) * 0.6283185307179586);
            } else {
                this.setTurnLeftRadians((1.0 + Math.random()) * 0.6283185307179586);
            }
        }
    }

    protected void doMove() {
        this.doMove(1000.0);
    }

    public void run() {
        this.init();
        while (true) {
            this.doRadar(this.lockEnemy);
            this.doMove();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        EnemyData enemyData = new EnemyData(scannedRobotEvent, this.getX(), this.getY(), this.getHeadingRadians());
        if (!this.enemySet.add(enemyData)) {
            for (EnemyData enemyData2 : this.enemySet) {
                if (!enemyData2.equals(enemyData)) continue;
                enemyData2.importTgt(scannedRobotEvent, this.getX(), this.getY(), this.getHeadingRadians());
            }
        }
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        Iterator<EnemyData> iterator = this.enemySet.iterator();
        while (iterator.hasNext()) {
            EnemyData enemyData = iterator.next();
            if (!enemyData.getName().equals(bulletHitEvent.getName()) || !(bulletHitEvent.getEnergy() <= 0.0)) continue;
            iterator.remove();
            if (enemyData != this.lockEnemy) continue;
            this.lockEnemy = null;
            this.tgtLock = false;
            System.out.println("Killed " + enemyData.getName() + "; unlocked.");
        }
    }

    private boolean findCollision(EnemyData enemyData) {
        if (enemyData == null) {
            return false;
        }
        if (Math.abs(enemyData.getBrg()) > 1.5707963267948966) {
            return false;
        }
        return enemyData.getDist() < 100.0 && Math.abs(enemyData.getDist() * Math.sin(enemyData.getBrg())) < 80.0;
    }

    private Direction collisionDir(EnemyData enemyData) {
        if (enemyData == null) {
            return null;
        }
        if (enemyData.getBrg() > 0.0) {
            return Direction.LEFT;
        }
        return Direction.RIGHT;
    }

    @Deprecated
    private double wallAheadDistance() {
        double d = this.getX();
        double d2 = this.getY();
        double d3 = this.getHeadingRadians();
        if (d < 80.0 || d2 < 80.0 || this.getBattleFieldWidth() - d < 80.0 || this.getBattleFieldHeight() - d2 < 80.0) {
            return 1.0;
        }
        if (d3 < 1.5707963267948966) {
            double d4 = this.getBattleFieldHeight() - d2;
            double d5 = d4 * Math.tan(d3);
            if (d + d5 < this.getBattleFieldWidth()) {
                return d4 / Math.cos(d3);
            }
            return (this.getBattleFieldWidth() - d) / Math.sin(d3);
        }
        if (d3 < Math.PI) {
            double d6 = this.getBattleFieldWidth() - d;
            double d7 = d6 * Math.tan(d3 - 1.5707963267948966);
            if (d2 - d7 > 0.0) {
                return d6 / Math.cos(d3 - 1.5707963267948966);
            }
            return d2 / Math.sin(d3 - 1.5707963267948966);
        }
        if (d3 < 4.71238898038469) {
            double d8 = d2;
            double d9 = d2 * Math.tan(d3 - Math.PI);
            if (d - d9 > 0.0) {
                return d8 / Math.cos(d3 - Math.PI);
            }
            return d / Math.sin(d3 - Math.PI);
        }
        double d10 = d;
        double d11 = d * Math.tan(d3 - 4.71238898038469);
        if (d2 + d11 < this.getBattleFieldHeight()) {
            return d / Math.cos(d3 - 4.71238898038469);
        }
        return (this.getBattleFieldHeight() - d2) / Math.sin(d3 - 4.71238898038469);
    }

    private Wall closestWall() {
        double d = this.getX();
        double d2 = this.getY();
        double d3 = this.getBattleFieldWidth() - d;
        double d4 = this.getBattleFieldHeight() - d2;
        if (d4 < d2 && d4 < d && d4 < d3) {
            return Wall.TOP;
        }
        if (d3 < d2 && d3 < d && d3 < d4) {
            return Wall.RIGHT;
        }
        if (d2 < d) {
            return Wall.BOTTOM;
        }
        return Wall.LEFT;
    }

    private Wall secondClosestWall() {
        double d = this.getX();
        double d2 = this.getY();
        switch (this.closestWall()) {
            case TOP: 
            case BOTTOM: {
                if (d < this.getBattleFieldWidth() - d) {
                    return Wall.LEFT;
                }
                return Wall.RIGHT;
            }
        }
        if (d2 > this.getBattleFieldHeight() - d2) {
            return Wall.TOP;
        }
        return Wall.BOTTOM;
    }

    private double distWall(Wall wall) {
        switch (wall) {
            case TOP: {
                return this.getBattleFieldHeight() - this.getY() - 18.0;
            }
            case RIGHT: {
                return this.getBattleFieldWidth() - this.getX() - 18.0;
            }
            case BOTTOM: {
                return this.getY() - 18.0;
            }
            case LEFT: {
                return this.getX() - 18.0;
            }
        }
        return -1.0;
    }

    private double distToClearWall(Wall wall, Direction direction) {
        double d;
        double d2 = this.getHeadingRadians();
        switch (wall) {
            case TOP: {
                d = Utils.normalAbsoluteAngle((double)(1.5707963267948966 - d2));
                break;
            }
            case RIGHT: {
                d = Utils.normalAbsoluteAngle((double)(Math.PI - d2));
                break;
            }
            case BOTTOM: {
                d = Utils.normalAbsoluteAngle((double)(4.71238898038469 - d2));
                break;
            }
            case LEFT: {
                d = Utils.normalAbsoluteAngle((double)(Math.PI * 2 - d2));
                break;
            }
            default: {
                return -99.0;
            }
        }
        if (d > Math.PI) {
            return -99.0;
        }
        if (direction == Direction.LEFT) {
            d = Math.PI - d;
        }
        return this.turnRadius() * (1.0 - Math.cos(d));
    }

    protected double[] aimLin(EnemyData enemyData, double d, double d2, double d3) {
        boolean bl = true;
        double d4 = enemyData.getVel();
        double d5 = enemyData.getCrs();
        double d6 = enemyData.getX() + (double)bl * d4 * Math.sin(d5);
        double d7 = enemyData.getY() + (double)bl * d4 * Math.cos(d5);
        double d8 = Math.atan((d6 - d2) / (d7 - d3));
        if (d3 > d7) {
            d8 += Math.PI;
        }
        double d9 = Math.hypot(d6 - d2, d7 - d3);
        double d10 = Utils.normalRelativeAngle((double)(d8 - d5));
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double d11 = d * d - d4 * d4;
        double d12 = 2.0 * d9 * d4 * Math.cos(d10);
        double d13 = -1.0 * d9 * d9;
        dArray = this.solveQdr(d11, d12, d13);
        double d14 = Math.abs(d10) > 1.5707963267948966 ? 1.0 + Math.min(Math.abs(dArray[0]), Math.abs(dArray[1])) : 1.0 + Math.max(Math.abs(dArray[0]), Math.abs(dArray[1]));
        double d15 = d9 * Math.sin(d8) + d14 * d4 * Math.sin(d5);
        double d16 = d9 * Math.cos(d8) + d14 * d4 * Math.cos(d5);
        dArray2[0] = d2 + d15;
        dArray2[1] = d3 + d16;
        return dArray2;
    }

    protected double[] aimCirc(EnemyData enemyData, double d, double d2, double d3) {
        int n = 1;
        double d4 = enemyData.getX();
        double d5 = enemyData.getY();
        double d6 = enemyData.getVel();
        double d7 = enemyData.getAccel();
        double d8 = enemyData.getCrs();
        double d9 = enemyData.getOmega();
        double[] dArray = new double[2];
        boolean bl = false;
        if (d9 == 0.0) {
            double d10 = Math.sin(d8);
            double d11 = Math.cos(d8);
            for (n = 1; !bl && n < 50; ++n) {
                if (Math.abs(d7) > 1.0 && d7 > 0.0 == d6 > 0.0) {
                    double d12 = d7 = d7 > 0.0 ? 1.0 : -1.0;
                }
                if (Math.abs(d6) <= 7.0) {
                    d6 += d7;
                }
                if (!(Math.hypot((d4 += d6 * d10) - d2, (d5 += d6 * d11) - d3) / d - (double)n < 0.5)) continue;
                bl = true;
            }
        } else {
            for (n = 1; !bl && n < 50; ++n) {
                if (Math.abs(d7) > 1.0 && d7 > 0.0 == d6 > 0.0) {
                    double d13 = d7 = d7 > 0.0 ? 1.0 : -1.0;
                }
                if (Math.abs(d6) <= 7.0) {
                    d6 += d7;
                }
                if (!(Math.hypot((d4 += d6 * Math.sin(d8 += d9)) - d2, (d5 += d6 * Math.cos(d8)) - d3) / d - (double)n < 0.5)) continue;
                bl = true;
            }
        }
        dArray[0] = d4;
        dArray[1] = d5;
        return dArray;
    }

    protected double maxTurn() {
        return (10.0 - 0.75 * this.getVelocity()) / 180.0 * Math.PI;
    }

    protected double turnRadius() {
        return this.getVelocity() / this.maxTurn();
    }

    protected double minRightRadians(double d, double d2) {
        return Utils.normalRelativeAngle((double)(d2 - d));
    }

    protected boolean insideField(double[] dArray, double d) {
        return dArray[0] > -1.0 * d && dArray[0] < this.getBattleFieldWidth() + d && dArray[1] > -1.0 * d && dArray[1] < this.getBattleFieldHeight() + d;
    }

    protected double[] solveQdr(double d, double d2, double d3) {
        double[] dArray = new double[2];
        double d4 = d2 > 0.0 ? -0.5 * (d2 + Math.sqrt(d2 * d2 - 4.0 * d * d3)) : -0.5 * (d2 - Math.sqrt(d2 * d2 - 4.0 * d * d3));
        dArray[0] = d4 / d;
        dArray[1] = d3 / d4;
        return dArray;
    }

    protected int sgn(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }
}

