/*
 * Decompiled with CFR 0.152.
 */
package nosteel;

import java.awt.Graphics2D;
import nosteel.AI.Cirrus;
import nosteel.Basics.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Welby
extends AdvancedRobot {
    private Cirrus ai = new Cirrus();
    long fireTime = 0L;
    boolean aimSuccessfull = false;

    public void run() {
        this.ai.setNumberOfEnemies(this.getOthers());
        Vector battleField = new Vector(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.ai.setBattlefieldSize(battleField);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.setTurnRadarRightRadians(this.ai.getRadarAngle(this.getTime(), this.getRadarHeadingRadians()));
            this.ai.startNewTurn(this.getEnergy());
            this.ai.processMovement(new Vector(this.getX(), this.getY()), this.getHeadingRadians());
            this.setTurnRightRadians(this.ai.getMovementAngle());
            this.setAhead(this.ai.getMovementDist());
            this.doGun();
            this.execute();
        }
    }

    void doGun() {
        if (this.ai.getNumberDicoveredOfEnemies() == 0.0) {
            return;
        }
        if (this.fireTime == this.getTime() && this.getGunTurnRemaining() == 0.0 && this.getGunHeat() == 0.0) {
            Bullet b = this.setFireBullet(this.ai.getFirePower());
            this.ai.registerFiredBullet(b);
        }
        Vector myNewPos = new Vector(this.getX(), this.getY());
        this.aimSuccessfull = this.ai.processAiming(myNewPos, this.getTime());
        if (this.aimSuccessfull) {
            double target = this.ai.getTargetDirection();
            this.setTurnGunRight(Utils.normalRelativeAngle((double)(target - this.getGunHeadingRadians())) * 360.0 / (Math.PI * 2));
            this.fireTime = this.getTime() + 1L;
        } else {
            this.fireTime = 0L;
        }
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.ai.attachScan(event, new Vector(this.getX(), this.getY()), this.getHeadingRadians(), this.getTime());
    }

    public void onPaint(Graphics2D g) {
        this.ai.draw(g);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.ai.myBulletHit(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.ai.myBulletMissed(event);
    }

    public void onRoundEnded(RoundEndedEvent event) {
        this.ai.printTotalStatistic();
        this.ai.logTotalStatistic(this.getRoundNum());
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.ai.enemyDied(event);
    }
}

