/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.guns.mellee;

import gre.svman4.enemies.Enemy;
import gre.svman4.guns.GunInformation;
import gre.svman4.guns.mellee.MelleeGun;
import gre.svman4.useful.FieldPoint;
import gre.svman4.useful.RobotState;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.HashMap;

public class AreaTargetingGun
extends MelleeGun {
    private static final int SEGMENT_SIZE = 45;
    private static final int DISTANCE_FOR_PAINTING_POINT = 100;
    private double shootingAngle;
    private final double[] segments = new double[45];

    @Override
    public void onPaint(Graphics2D paint) {
        double segment = Math.PI * 2 / (double)this.segments.length;
        double maxCount = 0.0;
        int i = 0;
        while (i < this.segments.length) {
            if (maxCount <= this.segments[i]) {
                maxCount = this.segments[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.segments.length) {
            FieldPoint temp = this._mineRobot.project(100.0, (double)i * segment);
            paint.setColor(this.getColor(0.0, this.segments[i], maxCount));
            paint.fillOval((int)temp.x - 2, (int)(temp.y - 2.0), 4, 4);
            ++i;
        }
        paint.setColor(Color.RED);
        int xTarget = (int)(this._mineRobot.x + 50.0 * Math.sin(this.shootingAngle));
        int yTarget = (int)(this._mineRobot.y + 50.0 * Math.cos(this.shootingAngle));
        paint.drawLine((int)this._mineRobot.x, (int)this._mineRobot.y, xTarget, yTarget);
    }

    public AreaTargetingGun(RobotState me, HashMap<String, Enemy> enemies) {
        super(me, enemies);
    }

    @Override
    public GunInformation getFiringInformation() {
        int i = 0;
        while (i < 45) {
            this.segments[i] = 0.0;
            ++i;
        }
        for (RobotState enemy : this._enemies.values()) {
            if (!enemy.alive) continue;
            double absBearing = this._mineRobot.getAngleTo(enemy);
            int segmentNumber = (int)(absBearing * 45.0 / (Math.PI * 2));
            segmentNumber = Math.min(segmentNumber, 44);
            int i2 = 0;
            while (i2 < 45) {
                int n = i2;
                this.segments[n] = this.segments[n] + enemy.energy * (1.0 / (1.0 + Math.pow(segmentNumber - i2, 2.0)));
                ++i2;
            }
        }
        int betterSegment = 0;
        int i3 = 1;
        while (i3 < 45) {
            if (this.segments[betterSegment] < this.segments[i3]) {
                betterSegment = i3;
            }
            ++i3;
        }
        this.shootingAngle = 0.06981317007977318 + 0.13962634015954636 * (double)betterSegment;
        GunInformation info = new GunInformation();
        info.shootingAngle = this.shootingAngle;
        info.bulletPower = this.getBulletPower();
        return info;
    }

    @Override
    public String getName() {
        return "AreaTargetingGun";
    }

    private double getBulletPower() {
        return 3.0;
    }
}

