/*
 * Decompiled with CFR 0.152.
 */
package casey;

import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Flee
extends AdvancedRobot {
    static int direction = 100;

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double eEnergy = e.getEnergy();
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        this.setTurnRight(e.getBearing() - 80.0);
        double firePower = 2.5;
        if (eEnergy <= 16.0) {
            firePower = (eEnergy + 2.0) / 6.0;
        }
        if (eEnergy < 4.0) {
            firePower = eEnergy / 4.0;
        }
        if (e.getDistance() < 250.0) {
            firePower = 3.0;
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians() + e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing) / 12.5)));
        if (this.getDistanceRemaining() == 0.0) {
            this.setAhead(Math.random() * (double)direction * Math.random() * 3.0);
        }
        if (Math.random() > 0.45) {
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getGunHeadingRadians())));
            this.onHitWall(null);
        }
        this.setTurnRadarLeftRadians(this.getRadarTurnRemaining());
        this.fire(firePower * Math.signum(eEnergy - 0.2));
    }

    public void onHitWall(HitWallEvent e) {
        direction *= -1;
    }
}

