/*
 * Decompiled with CFR 0.152.
 */
package bjl.move;

import bjl.Area;
import bjl.BattleField;
import bjl.Enemy;
import bjl.EnemyList;
import bjl.MoveDemand;
import bjl.SuperBlip;
import bjl.move.SetTarget;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class MoveStrategy {
    protected MoveStrategy tempMS;
    protected Area area;
    protected Enemy target;
    protected double randomNumber;
    protected double bias;
    public boolean enabled;

    public void changeBias(double biasDelta) {
        this.bias += biasDelta;
        BattleField.println(this + " has bias " + this.bias);
    }

    public MoveDemand getMoveDemand(boolean isCurStrategy, int type) {
        if (this.tempMS != null) {
            if (this.tempMS.getUsefulness(type) < 0.0) {
                this.tempMS = null;
                return new MoveDemand(0.0, 0.0, true, true, 0.0, 0.0, this);
            }
            return this.tempMS.getMoveDemand(isCurStrategy, type);
        }
        return null;
    }

    public abstract double getUsefulness(int var1);

    public abstract boolean isInGroup(String var1);

    public void setData(Object data) {
        if (data instanceof Area) {
            this.area = (Area)data;
        }
        if (data instanceof SetTarget) {
            this.target = EnemyList.getEnemy(((SetTarget)data).target);
        }
    }

    public void reset() {
        this.area.setToBattleField();
        this.target = null;
        this.randomNumber = Math.random() + this.bias;
    }

    public void reInit() {
    }

    public boolean willHitWall() {
        SuperBlip me = BattleField.getMe();
        int sign = me.vel < 0.0 ? -1 : (me.vel > 0.0 ? 1 : 0);
        double xTest = me.pos.x + Math.sin(Math.toRadians(me.head)) * 47.0 * (double)sign;
        double yTest = me.pos.y + Math.cos(Math.toRadians(me.head)) * 47.0 * (double)sign;
        return xTest <= 20.0 || xTest >= BattleField.getWidth() - 20.0 || yTest <= 20.0 || yTest >= BattleField.getHeight() - 20.0;
    }

    public String toString() {
        return "Default MoveStrategy";
    }

    private final /* synthetic */ void this() {
        this.tempMS = null;
    }

    public MoveStrategy() {
        this.this();
        this.area = new Area();
        this.bias = 0.0;
        this.reset();
    }
}

