/*
 * Decompiled with CFR 0.152.
 */
package wcsv.melee;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import robocode.AdvancedRobot;
import wcsv.melee.Gun;
import wcsv.melee.Info;
import wcsv.melee.InfoSet;
import wcsv.melee.SelfOrganizingMap;
import wcsv.melee.Utils;
import wcsv.melee.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MeleeNeuralNetGun
implements Gun {
    public static final double[] offsets;
    private static final double MIN_GUN_TURN = 0.001;
    private static TreeMap networks;
    private static final double[] networkNormalVector;
    private static final double networkSpreadFactor;
    private static AdvancedRobot robot;
    public static long actualBulletHits;
    public static long actualBulletMisses;
    private double bulletPowerToUse;
    private double bulletPower;
    private boolean aim;
    private boolean willFireThisTick;
    private LinkedList waves;

    public void registerScan(InfoSet scan, InfoSet currentTarget) {
        boolean bl = false;
        if (this.aim && Math.abs(robot.getGunTurnRemainingRadians()) < 0.001) {
            bl = this.willFireThisTick = true;
        }
        if (scan != null && scan.enemy.basic.energy > 0.0) {
            this.bulletPower = Math.max(Math.min(1000.0 / scan.enemy.distance, (double)3), 0.1);
            this.bulletPower = Math.min(this.bulletPower, scan.enemy.basic.energy / (double)4);
            if (scan.enemy.basic.name.equals(currentTarget.enemy.basic.name)) {
                this.bulletPowerToUse = this.bulletPower;
                this.waves.add(new Wave(scan.myInfo, scan.enemy, this.bulletPower, (int)robot.getTime() - 1, this.willFireThisTick));
            }
            ListIterator it = this.waves.listIterator();
            while (it.hasNext()) {
                Wave w = (Wave)it.next();
                if (w.radius((int)robot.getTime()) > 1200.0) {
                    it.remove();
                    continue;
                }
                double waveDist = w.distanceToPoint(w.targetReference.basic.location, (int)robot.getTime());
                if (!(waveDist < w.velocity / 1.5)) continue;
                this.update(w.targetReference, w);
                it.remove();
            }
        }
    }

    public boolean operate(InfoSet scan) {
        if (scan == null) {
            return false;
        }
        if (robot.getGunHeat() > robot.getGunCoolingRate()) {
            robot.setTurnGunRightRadians(Utils.relativeAngle(scan.enemy.bearing - robot.getGunHeadingRadians()));
            this.aim = false;
        } else {
            if (this.willFireThisTick && robot.setFireBullet(this.bulletPowerToUse) != null) {
                this.aim = false;
                this.willFireThisTick = false;
                return true;
            }
            robot.setTurnGunRightRadians(Utils.relativeAngle(this.computeFiringAngle(scan) - robot.getGunHeadingRadians()));
            this.aim = true;
        }
        return false;
    }

    public void update(Info t, Wave w) {
        double[] vect = this.createVector(w.target, w);
        SelfOrganizingMap data = (SelfOrganizingMap)networks.get(t.basic.name);
        if (data == null) {
            data = new SelfOrganizingMap(networkNormalVector, networkSpreadFactor);
            networks.put(t.basic.name, data);
        }
        SelfOrganizingMap.Node e = data.add(vect);
        double bearingChange = w.computeCentralBearingChange(t.basic.location) * w.target.lateralDir;
        double maxEscapeAngle = Utils.maxEscapeAngle_Velocity(w.velocity);
        double mid = Utils.getSegment(bearingChange / maxEscapeAngle, offsets);
        data.combine(vect, e, 1.0, 1.0, mid);
    }

    public double computeFiringAngle(InfoSet info) {
        SelfOrganizingMap data = (SelfOrganizingMap)networks.get(info.enemy.basic.name);
        if (data == null || info.enemy.basic.energy <= 0.0) {
            return info.enemy.bearing;
        }
        double[] buffer = data.get(this.createVector(info.enemy, info.myInfo.basic.location, this.bulletPowerToUse));
        if (buffer == null) {
            return info.enemy.bearing;
        }
        int mostIndex = (int)((double)offsets.length / (double)2);
        double mostHits = buffer[mostIndex];
        int i = 0;
        while (i < offsets.length) {
            double hits = buffer[i];
            if (hits > mostHits) {
                mostIndex = i;
                mostHits = hits;
            }
            ++i;
        }
        return Utils.absoluteAngle(info.enemy.bearing + Utils.maxEscapeAngle_Velocity(Utils.bulletPowerToVelocity(this.bulletPowerToUse)) * offsets[mostIndex] * info.enemy.lateralDir);
    }

    public double[] createVector(Info t, Point2D.Double waveCenter, double bp) {
        return new double[]{Math.abs(t.lateralVelocity()), t.basic.velocity, Math.min(900.0, t.distance), Math.min(500.0, this.wallDist(t.basic.location)), Utils.wallCollisionAngle(t, waveCenter, 1.0, 0.7853981633974483), Utils.wallCollisionAngle(t, waveCenter, -1.0, 0.7853981633974483)};
    }

    public double[] createVector(Info t, Wave w) {
        return new double[]{Math.abs(t.lateralVelocity()), t.basic.velocity, Math.min(900.0, t.distance), Math.min(500.0, this.wallDist(t.basic.location)), Utils.wallCollisionAngle(t, w.source.basic.location, 1.0, 0.7853981633974483), Utils.wallCollisionAngle(t, w.source.basic.location, -1.0, 0.7853981633974483)};
    }

    private final double wallDist(Point2D.Double p) {
        return Math.min(Math.min(p.getX(), p.getY()), Math.min(Utils.fWidth - p.getX(), Utils.fHeight - p.getY()));
    }

    public void reset() {
        this.aim = false;
        this.willFireThisTick = false;
        this.waves = new LinkedList();
    }

    private final /* synthetic */ void this() {
        this.aim = false;
        this.willFireThisTick = false;
    }

    public MeleeNeuralNetGun(AdvancedRobot r) {
        this.this();
        robot = r;
        this.waves = new LinkedList();
        networks = new TreeMap();
        this.bulletPower = 1.75;
        this.bulletPowerToUse = 1.75;
    }

    static {
        double[] dArray = new double[41];
        dArray[0] = -1.0;
        dArray[1] = -0.95;
        dArray[2] = -0.9;
        dArray[3] = -0.85;
        dArray[4] = -0.8;
        dArray[5] = -0.75;
        dArray[6] = -0.7;
        dArray[7] = -0.65;
        dArray[8] = -0.6;
        dArray[9] = -0.55;
        dArray[10] = -0.5;
        dArray[11] = -0.45;
        dArray[12] = -0.4;
        dArray[13] = -0.35;
        dArray[14] = -0.3;
        dArray[15] = -0.25;
        dArray[16] = -0.2;
        dArray[17] = -0.15;
        dArray[18] = -0.1;
        dArray[19] = -0.05;
        dArray[21] = 0.05;
        dArray[22] = 0.1;
        dArray[23] = 0.15;
        dArray[24] = 0.2;
        dArray[25] = 0.25;
        dArray[26] = 0.3;
        dArray[27] = 0.35;
        dArray[28] = 0.4;
        dArray[29] = 0.45;
        dArray[30] = 0.5;
        dArray[31] = 0.55;
        dArray[32] = 0.6;
        dArray[33] = 0.65;
        dArray[34] = 0.7;
        dArray[35] = 0.75;
        dArray[36] = 0.8;
        dArray[37] = 0.85;
        dArray[38] = 0.9;
        dArray[39] = 0.95;
        dArray[40] = 1.0;
        offsets = dArray;
        networkNormalVector = new double[]{8.0, 16.0, 900.0, 500.0, 0.7853981633974483, 0.7853981633974483};
        networkSpreadFactor = Math.sqrt(networkNormalVector.length) / 9.0;
        actualBulletHits = 0L;
        actualBulletMisses = 0L;
    }
}

