/*
 * Decompiled with CFR 0.152.
 */
package rdm.state.entities;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import rdm.state.entities.EnemyState;
import rdm.state.entities.SelfState;
import rdm.state.entities.WorldState;
import robocode.Rules;
import robocode.util.Utils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J'\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J \u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\fH\u0002J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0017\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lrdm/state/entities/InstantState;", "", "world", "Lrdm/state/entities/WorldState;", "self", "Lrdm/state/entities/SelfState;", "enemy", "Lrdm/state/entities/EnemyState;", "(Lrdm/state/entities/WorldState;Lrdm/state/entities/SelfState;Lrdm/state/entities/EnemyState;)V", "getEnemy", "()Lrdm/state/entities/EnemyState;", "enemyBearingFromGun", "", "getEnemyBearingFromGun", "()D", "enemyHeadingFromGun", "getEnemyHeadingFromGun", "linearRotationPrediction1", "getLinearRotationPrediction1", "linearRotationPrediction2", "getLinearRotationPrediction2", "linearRotationPredictionRadians1", "getLinearRotationPredictionRadians1", "linearRotationPredictionRadians2", "getLinearRotationPredictionRadians2", "getSelf", "()Lrdm/state/entities/SelfState;", "getWorld", "()Lrdm/state/entities/WorldState;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "limit", "value", "min", "max", "toString", "", "Commons"})
public final class InstantState {
    private final double linearRotationPrediction1;
    private final double linearRotationPrediction2;
    @NotNull
    private final WorldState world;
    @NotNull
    private final SelfState self;
    @NotNull
    private final EnemyState enemy;

    public final double getEnemyBearingFromGun() {
        double absoluteBearing = this.self.getBody().getHeading() + this.enemy.getBearing();
        double gunHeading = this.self.getGun().getHeading();
        return Utils.normalRelativeAngleDegrees((double)(absoluteBearing - gunHeading));
    }

    public final double getEnemyHeadingFromGun() {
        double absoluteBearing = this.self.getBody().getHeading() + this.enemy.getBearing();
        double enemyHeading = this.enemy.getHeading();
        return Utils.normalRelativeAngleDegrees((double)(enemyHeading - absoluteBearing));
    }

    public final double getLinearRotationPrediction1() {
        return this.linearRotationPrediction1;
    }

    public final double getLinearRotationPrediction2() {
        return this.linearRotationPrediction2;
    }

    public final double getLinearRotationPredictionRadians1() {
        double bulletPower = 3.0;
        double headOnBearing = this.self.getBody().getHeadingRadians() + this.enemy.getBearingRadians();
        double linearPrediction = Math.asin(this.enemy.getVelocity() / Rules.getBulletSpeed((double)bulletPower) * Math.sin(this.enemy.getHeadingRadians() - headOnBearing));
        return Utils.normalRelativeAngle((double)linearPrediction);
    }

    public final double getLinearRotationPredictionRadians2() {
        double d;
        double c;
        double a;
        double D;
        double C;
        double eHd;
        double FIREPOWER = 3.0;
        double ROBOT_WIDTH = 16.0;
        double ROBOT_HEIGHT = 16.0;
        double eAbsBearing = this.self.getBody().getHeadingRadians() + this.enemy.getBearingRadians();
        double rX = this.self.getBody().getX();
        double rY = this.self.getBody().getY();
        double bV = Rules.getBulletSpeed((double)FIREPOWER);
        double eX = rX + this.enemy.getDistance() * Math.sin(eAbsBearing);
        double eY = rY + this.enemy.getDistance() * Math.cos(eAbsBearing);
        double A = (eX - rX) / bV;
        double eV = this.enemy.getVelocity();
        double B = eV / bV * Math.sin(eHd = this.enemy.getHeadingRadians());
        double b = (double)2 * (A * B + (C = (eY - rY) / bV) * (D = eV / bV * Math.cos(eHd)));
        double discriminant = b * b - 4.0 * (a = A * A + C * C) * (c = B * B + D * D - 1.0);
        if (discriminant >= 0.0) {
            double t2;
            double t1 = (double)2 * a / (-b - Math.sqrt(discriminant));
            double t = Math.min(t1, t2 = (double)2 * a / (-b + Math.sqrt(discriminant))) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
            double endX = this.limit(eX + eV * t * Math.sin(eHd), ROBOT_WIDTH / (double)2, this.world.getWidth() - ROBOT_WIDTH / (double)2);
            double endY = this.limit(eY + eV * t * Math.cos(eHd), ROBOT_HEIGHT / (double)2, this.world.getHeight() - ROBOT_HEIGHT / (double)2);
            d = Utils.normalRelativeAngle((double)(Math.atan2(endX - rX, endY - rY) - this.self.getGun().getHeadingRadians()));
        } else {
            d = 0.0;
        }
        return d;
    }

    private final double limit(double value, double min, double max) {
        return Math.min(max, Math.max(min, value));
    }

    @NotNull
    public final WorldState getWorld() {
        return this.world;
    }

    @NotNull
    public final SelfState getSelf() {
        return this.self;
    }

    @NotNull
    public final EnemyState getEnemy() {
        return this.enemy;
    }

    public InstantState(@NotNull WorldState world, @NotNull SelfState self, @NotNull EnemyState enemy) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(self, "self");
        Intrinsics.checkParameterIsNotNull(enemy, "enemy");
        this.world = world;
        this.self = self;
        this.enemy = enemy;
        this.linearRotationPrediction1 = Math.toDegrees(this.getLinearRotationPredictionRadians1());
        this.linearRotationPrediction2 = Math.toDegrees(this.getLinearRotationPredictionRadians2());
    }

    @NotNull
    public final WorldState component1() {
        return this.world;
    }

    @NotNull
    public final SelfState component2() {
        return this.self;
    }

    @NotNull
    public final EnemyState component3() {
        return this.enemy;
    }

    @NotNull
    public final InstantState copy(@NotNull WorldState world, @NotNull SelfState self, @NotNull EnemyState enemy) {
        Intrinsics.checkParameterIsNotNull(world, "world");
        Intrinsics.checkParameterIsNotNull(self, "self");
        Intrinsics.checkParameterIsNotNull(enemy, "enemy");
        return new InstantState(world, self, enemy);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ InstantState copy$default(InstantState instantState, WorldState worldState, SelfState selfState, EnemyState enemyState, int n, Object object) {
        if ((n & 1) != 0) {
            worldState = instantState.world;
        }
        if ((n & 2) != 0) {
            selfState = instantState.self;
        }
        if ((n & 4) != 0) {
            enemyState = instantState.enemy;
        }
        return instantState.copy(worldState, selfState, enemyState);
    }

    public String toString() {
        return "InstantState(world=" + this.world + ", self=" + this.self + ", enemy=" + this.enemy + ")";
    }

    public int hashCode() {
        WorldState worldState = this.world;
        SelfState selfState = this.self;
        EnemyState enemyState = this.enemy;
        return ((worldState != null ? ((Object)worldState).hashCode() : 0) * 31 + (selfState != null ? ((Object)selfState).hashCode() : 0)) * 31 + (enemyState != null ? ((Object)enemyState).hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof InstantState)) break block3;
                InstantState instantState = (InstantState)object;
                if (!Intrinsics.areEqual(this.world, instantState.world) || !Intrinsics.areEqual(this.self, instantState.self) || !Intrinsics.areEqual(this.enemy, instantState.enemy)) break block3;
            }
            return true;
        }
        return false;
    }
}

