/*
 * Decompiled with CFR 0.152.
 */
package muf.utils;

import muf.utils.GameData;
import muf.utils.Targeting;
import muf.utils.TargetingEvaluator;

public class TargetingsEvaluator {
    protected TargetingEvaluator[] evaluators;

    public TargetingsEvaluator() {
        this.evaluators = null;
    }

    public TargetingsEvaluator(Targeting[] targetingArray, GameData gameData) {
        this(targetingArray, gameData, 0);
    }

    public TargetingsEvaluator(Targeting[] targetingArray, GameData gameData, int n) {
        this.evaluators = new TargetingEvaluator[targetingArray.length];
        int n2 = 0;
        while (n2 < targetingArray.length) {
            this.evaluators[n2] = new TargetingEvaluator(targetingArray[n2], gameData, n);
            ++n2;
        }
    }

    public void virtualAim(double d) {
        int n = 0;
        while (n < this.evaluators.length) {
            this.evaluators[n].virtualAim(d);
            ++n;
        }
    }

    public void virtualFire(double d) {
        int n = 0;
        while (n < this.evaluators.length) {
            this.evaluators[n].virtualFire(d);
            ++n;
        }
    }

    public void evaluateBullets() {
        int n = 0;
        while (n < this.evaluators.length) {
            this.evaluators[n].evaluateBullets();
            ++n;
        }
    }

    public void notifyEnemyScanned() {
        int n = 0;
        while (n < this.evaluators.length) {
            this.evaluators[n].notifyEnemyScanned();
            ++n;
        }
    }

    public int getBestSuccessRateIndex() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.evaluators.length) {
            if (this.evaluators[n2].getSuccessRate() > this.evaluators[n].getSuccessRate()) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public Targeting getBestTargeting() {
        int n = this.getBestSuccessRateIndex();
        return this.evaluators[n].getTargeting();
    }

    public void dump() {
        int n = 0;
        while (n < this.evaluators.length) {
            System.out.println(this.evaluators[n].getTargeting().getName());
            System.out.println(this.evaluators[n].getSuccessRate());
            ++n;
        }
    }
}

