/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.util.Set;
import pedersen.debug.DebuggableBase;
import pedersen.divination.CombatWave;
import pedersen.physics.BearingOffsetRange;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.Position;
import pedersen.physics.Snapshot;
import pedersen.physics.Vehicle;
import pedersen.physics.constant.DistanceVectorImpl;
import pedersen.util.Arena;
import pedersen.util.Constraints;

public class TargetAnalysis
extends DebuggableBase {
    public final Direction originalBearingToTarget;
    public final double originalPosDistanceToWall;
    public final double originalNegDistanceToWall;
    public final double originalDistanceToTarget;
    public final double originalVelocity;
    public final double originalLateralVelocity;
    public final double originalClosingVelocity;
    public final int originalBulletFlightTime;
    private BearingOffsetRange rangeOfInterception = null;
    public static long counter = 0L;
    public static long release = 0L;

    public TargetAnalysis(CombatWave wave, Snapshot agressor, Snapshot defender) {
        Position firingPosition = wave.getPosition();
        this.originalBearingToTarget = firingPosition.getBearing(defender);
        this.originalDistanceToTarget = firingPosition.getDistance(defender).distance();
        this.originalVelocity = defender.getVelocity().velocity() / Constraints.maxAbsVehicleVelocity.velocity();
        Position defenderOrbitPosition = agressor.getPrevious().getPosition();
        this.originalLateralVelocity = TargetAnalysis.getTangentalVelocity(defenderOrbitPosition, defender.getVehicle());
        this.originalClosingVelocity = TargetAnalysis.getClosingVelocity(defenderOrbitPosition, defender.getVehicle());
        Direction tangentPos = this.originalBearingToTarget.getTangentAngle();
        Direction tangentNeg = this.originalBearingToTarget.getTangentAngle().getOpposedAngle();
        this.originalPosDistanceToWall = defender.getPosition().getDistance(Arena.singleton.getWallIntercept(defender, new DistanceVectorImpl((HasDirection)tangentPos, 1.0))).distance();
        this.originalNegDistanceToWall = defender.getPosition().getDistance(Arena.singleton.getWallIntercept(defender, new DistanceVectorImpl((HasDirection)tangentNeg, 1.0))).distance();
        this.originalBulletFlightTime = 1 + (int)(this.originalDistanceToTarget / wave.getVelocity().velocity());
        ++counter;
    }

    private static double getTangentalVelocity(Position firingPosition, Vehicle target) {
        Direction bearingToTarget = firingPosition.getPosition().getBearing(target);
        Position targetPrediction = target.getPosition().addVector(target);
        Direction bearingToTargetPrediction = firingPosition.getPosition().getBearing(targetPrediction);
        double relativeBearingToPrediction = bearingToTarget.getRelativeDirection(bearingToTargetPrediction).getRelativeRadians();
        Direction bearingToTargetTangent = bearingToTarget.getTangentAngle();
        Position targetMaxTangent = target.getPosition().addVector((HasDirection)bearingToTargetTangent, Constraints.maxAbsVehicleVelocity);
        Direction bearingToTargetMaxTangent = firingPosition.getPosition().getBearing(targetMaxTangent);
        double relativeBearingToMaxTangent = bearingToTarget.getRelativeDirection(bearingToTargetMaxTangent).getRelativeRadians();
        return Constraints.limitValue(-1.0, relativeBearingToPrediction / relativeBearingToMaxTangent, 1.0);
    }

    private static double getClosingVelocity(Position firingPosition, Vehicle target) {
        double distanceToTarget = firingPosition.getPosition().getDistance(target).distance();
        Position targetPrediction = target.getPosition().addVector(target);
        double distanceToTargetPrediction = firingPosition.getPosition().getDistance(targetPrediction).distance();
        return (distanceToTarget - distanceToTargetPrediction) / 8.0;
    }

    public void addRangeOfInterception(BearingOffsetRange addition) {
        if (this.rangeOfInterception == null) {
            this.rangeOfInterception = addition;
        } else {
            this.rangeOfInterception.add(addition);
        }
    }

    public BearingOffsetRange getRangeOfInterception() {
        return this.rangeOfInterception;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Target Analysis: ");
        buffer.append("oBT: ").append(this.formatDebug(this.originalBearingToTarget.getAbsoluteRadians()));
        buffer.append(", oLV: ").append(this.formatDebug(this.originalLateralVelocity));
        buffer.append(", oHV: ").append(this.formatDebug(this.originalClosingVelocity));
        buffer.append(", oCwDW: ").append(this.formatDebug(this.originalPosDistanceToWall));
        buffer.append(", oCcwDW: ").append(this.formatDebug(this.originalNegDistanceToWall));
        return buffer.toString();
    }

    private String formatDebug(double value) {
        String formattedValue = null;
        formattedValue = value == 0.0 ? " 0.0000" : (value > 0.0 ? " " + super.trim(value) : super.trim(value));
        return formattedValue;
    }

    public static final Set<TargetAnalysis>[] getArrayOfSets(int length) {
        return new Set[length];
    }

    public void release() {
        ++release;
    }
}

