/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination.analysis;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringSolution;
import pedersen.divination.TargetAnalysis;
import pedersen.divination.analysis.AnalysisConfiguration;
import pedersen.divination.analysis.SpectrumAnalysis;
import pedersen.divination.analysis.WaveAnalysis;
import pedersen.physics.Direction;
import pedersen.util.TargetingStatistics;

public class SpectrumAnalysisWrapper
extends SpectrumAnalysis
implements WaveAnalysis {
    public static final double drawHeight = 200.0;
    private final AnalysisConfiguration analysisConfiguration;
    private final TargetingStatistics targetingStatistics = new TargetingStatistics();

    SpectrumAnalysisWrapper(AnalysisConfiguration analysisConfiguration) {
        this.analysisConfiguration = analysisConfiguration;
    }

    @Override
    public FiringSolution getFiringSolution(CombatWave wave, TargetAnalysis targetAnalysis) {
        this.analysisConfiguration.setPaintSubject(this);
        double bearingOffset = this.analysisConfiguration.analysisMethod.getBearingOffset(this, wave);
        Direction absoluteHeading = targetAnalysis.originalBearingToTarget.addRadians(bearingOffset);
        return new FiringSolution(absoluteHeading, this.targetingStatistics);
    }

    @Override
    public void recordWave(CombatWave wave, TargetAnalysis targetAnalysis) {
        double increment = this.analysisConfiguration.virtualWeight;
        this.addRange(targetAnalysis.getRangeOfInterception(), increment);
    }

    public void paint(Point2D.Double p) {
        if (GraphicalDebugger.paintBins) {
            int half = this.bin.length / 2;
            int p2 = half - 1;
            int p4 = p2 + half;
            GraphicalDebugger.addTurnScope(new Line2D.Double(p.x + 0.0, p.y, p.x + 0.0, p.y + 200.0), Color.blue);
            GraphicalDebugger.addTurnScope(new Line2D.Double(p.x + (double)p2, p.y, p.x + (double)p2, p.y + 200.0), Color.blue);
            GraphicalDebugger.addTurnScope(new Line2D.Double(p.x + (double)half, p.y, p.x + (double)half, p.y + 200.0), Color.blue);
            GraphicalDebugger.addTurnScope(new Line2D.Double(p.x + (double)p4, p.y, p.x + (double)p4, p.y + 200.0), Color.blue);
            double highwatermark = 0.0;
            double[] dArray = this.bin;
            int n = this.bin.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                if (value > highwatermark) {
                    highwatermark = value;
                }
                ++n2;
            }
            double scalar = 200.0 / highwatermark;
            int i = 0;
            while (i < half) {
                GraphicalDebugger.addTurnScope(new Line2D.Double(p.x + (double)i, p.y, p.x + (double)i, Math.round(p.y + this.bin[i] * scalar)), Color.pink);
                ++i;
            }
            i = half + 1;
            while (i < this.bin.length) {
                GraphicalDebugger.addTurnScope(new Line2D.Double(p.x + (double)i, p.y, p.x + (double)i, Math.round(p.y + this.bin[i] * scalar)), Color.pink);
                ++i;
            }
        }
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        return buffer.toString();
    }

    @Override
    public String debugPath(CombatWave wave, TargetAnalysis targetAnalysis) {
        return super.trim(this.targetingStatistics.getSuccessRate());
    }
}

