/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics.constant;

import pedersen.debug.DebuggableBase;
import pedersen.physics.Direction;
import pedersen.physics.Distance;
import pedersen.physics.DistanceVector;
import pedersen.physics.HasDirection;
import pedersen.physics.HasDistance;
import pedersen.physics.HasDistanceVector;
import pedersen.physics.HasVector;
import pedersen.physics.Magnitude;
import pedersen.physics.Vector;
import pedersen.physics.constant.DirectionImpl;
import pedersen.physics.constant.DistanceImpl;

public class DistanceVectorImpl
extends DebuggableBase
implements DistanceVector {
    private Direction direction;
    private Distance distance;

    public DistanceVectorImpl(HasDirection direction, HasDistance distance) {
        this.direction = direction.getDirection();
        this.distance = distance.getDistance();
    }

    public DistanceVectorImpl(HasDirection direction, double distance) {
        this(direction, new DistanceImpl(distance));
    }

    public DistanceVectorImpl(double radians, double distance) {
        this((HasDirection)new DirectionImpl(radians), new DistanceImpl(distance));
    }

    @Override
    public DistanceVector getDistanceVector() {
        return this;
    }

    @Override
    public Vector getVector() {
        return this;
    }

    @Override
    public boolean equalsDistanceVector(HasDistanceVector other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.direction.equalsDirection(other.getDistanceVector().getDirection()) && this.distance.equalsDistance(other.getDistanceVector().getDistance());
    }

    @Override
    public boolean equalsVector(HasVector other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.direction.equalsDirection(other.getVector().getDirection()) && this.distance.equalsMagnitude(other.getVector().getMagnitude());
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public Distance getDistance() {
        return this.distance;
    }

    @Override
    public Magnitude getMagnitude() {
        return this.getDistance();
    }
}

