/*
 * Decompiled with CFR 0.152.
 */
package pedersen.team.communication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pedersen.team.communication.Communique;
import pedersen.team.communication.CommuniqueBase;
import pedersen.team.communication.CommuniqueEnemyScan;
import pedersen.team.communication.CommuniqueEnemyWave;
import pedersen.team.communication.CommuniqueMyBullet;
import pedersen.team.communication.CommuniqueMyBulletTarget;
import pedersen.team.communication.CommuniqueMyRadarTarget;
import pedersen.team.communication.CommuniqueNotAvailable;
import pedersen.team.communication.CommuniquePersonalData;
import pedersen.team.communication.CommuniqueSuggestedBulletTarget;
import pedersen.team.communication.CommuniqueSuggestedRadarTarget;
import robocode.MessageEvent;

public class CommuniqueFactory {
    private static final String lineDelimiter = "\n";

    public static List<Communique> translateMessage(MessageEvent e) {
        String[] message;
        ArrayList<Communique> communiques = new ArrayList<Communique>();
        String sender = e.getSender();
        long time = e.getTime();
        String[] stringArray = message = ((String)((Object)e.getMessage())).split(lineDelimiter);
        int n = message.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            communiques.add(CommuniqueFactory.translateMessage(sender, time, line));
            ++n2;
        }
        return communiques;
    }

    public static Serializable packageCommuniques(List<Communique> communiques) {
        StringBuffer buffer = new StringBuffer();
        for (Communique e : communiques) {
            buffer.append(lineDelimiter).append(e.toString());
        }
        return buffer.toString().substring(1);
    }

    private static Communique translateMessage(String sender, long time, String message) {
        CommuniqueBase communique = null;
        try {
            String[] values = message.split(",");
            String id = values[0];
            communique = id.contentEquals("PD") ? new CommuniquePersonalData(sender, values) : (id.contentEquals("BO") ? new CommuniqueMyBullet(sender, values) : (id.contentEquals("ES") ? new CommuniqueEnemyScan(sender, values) : (id.contentEquals("EW") ? new CommuniqueEnemyWave(sender, values) : (id.contentEquals("MR") ? new CommuniqueMyRadarTarget(sender, values) : (id.contentEquals("MB") ? new CommuniqueMyBulletTarget(sender, values) : (id.contentEquals("TR") ? new CommuniqueSuggestedRadarTarget(sender, values) : (id.contentEquals("TB") ? new CommuniqueSuggestedBulletTarget(sender, values) : (id.contentEquals("NA") ? new CommuniqueEnemyWave(sender, values) : new CommuniqueNotAvailable(sender, time, message)))))))));
        }
        catch (Exception ex) {
            communique = new CommuniqueNotAvailable(sender, time, message);
        }
        return communique;
    }
}

