/*
 * Decompiled with CFR 0.152.
 */
package edu.otg.spr;

import edu.otg.spr.Enemy;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RateControlRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class TheTeacher
extends RateControlRobot {
    private Point2D.Double desiredPos;
    private Point2D.Double radarRetning;
    private Point2D.Double gunRetning;
    private Point2D.Double moveRetning;
    private double radarOffset;
    private double posAngleOffset;
    private double bulletPower;
    private double confidence;
    private double gunOffsetAngle;
    private double gunOffsetAngleAmp;
    ArrayList<Enemy> enemies = new ArrayList();
    private String target;
    private long currentTime;
    private int bulletsHit;
    private int bulletsMissed;
    private boolean forward;
    private boolean roundDone;
    private static final boolean debug = true;
    private double radarGain = 0.9;
    private double gunGain = 0.7;
    private double moveGain = 0.3;
    private double VelocityGain = 0.4;
    private int positionFan = 55;
    private double radarFan = 10.0;
    private double bulletPowerScale = 1.5;
    private int distanceFromTarget = 300;
    private int scale = 1;
    private double radarFrequency = 1.0;
    private double posFrequency = 0.01;
    private double overTone = 10.0;
    private double retning = 1.0;

    public void run() {
        this.roundDone = false;
        this.setColors(Color.WHITE, Color.GREEN, Color.WHITE);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.desiredPos = new Point2D.Double(0.0, 0.0);
        this.moveRetning = new Point2D.Double(0.0, 0.0);
        this.radarRetning = new Point2D.Double(0.0, 0.0);
        this.gunRetning = new Point2D.Double(0.0, 0.0);
        this.setParameters();
        this.bulletsHit = 0;
        this.bulletsMissed = 0;
        this.target = "";
        this.randomize();
        while (!this.roundDone) {
            this.currentTime = this.getTime();
            this.clearAllEvents();
            this.updateOffset();
            if (this.currentTime % 10L == 1L) {
                this.selectEnemy();
                this.randomize();
            }
            this.setRadarRate();
            this.setGunRate();
            this.setMoveRate();
            this.doGun();
            this.execute();
        }
        while (this.roundDone) {
        }
    }

    private void randomize() {
        if (this.enemies.size() == 1 && Math.random() > 0.8 && this.getEnergy() <= this.getEnemyByName(this.target).getEnergy()) {
            this.gunOffsetAngleAmp = 15.0 * Math.random();
            this.distanceFromTarget = (int)(300.0 * Math.random()) + 50;
            this.bulletPowerScale = 20.0 * Math.random() + 2.0;
            System.out.println("Skifter strategi!");
        }
    }

    private void selectEnemy() {
        double max = Double.MIN_VALUE;
        for (Enemy e : this.enemies) {
            if (!(e.getHitDamage() > max)) continue;
            max = e.getHitDamage();
            this.target = e.getName();
            this.bulletsHit = 0;
            this.bulletsMissed = 0;
        }
    }

    private void setParameters() {
        this.radarFrequency = 1.0;
        this.posFrequency = 0.06;
        this.radarGain = 0.8;
        this.gunGain = 0.45;
        this.moveGain = 0.3;
        this.VelocityGain = 0.4;
        this.positionFan = 45;
        this.radarFan = 30.0;
        this.bulletPowerScale = 18.0;
        this.distanceFromTarget = 300;
        this.scale = 1;
        this.overTone = 5.0;
        this.retning = 1.0;
        this.gunOffsetAngleAmp = 2.0;
    }

    private void doGun() {
        Enemy e = this.getEnemyByName(this.target);
        if (e != null && this.currentTime - e.getLastScanTime() < 2L && e.getLastScanInterval() < 4L && this.getGunHeat() == 0.0) {
            this.bulletPower = this.confidence * 3.0 * this.bulletPowerScale;
            this.setFire(this.bulletPower);
        }
    }

    private void setMoveRate() {
        double moveError = 0.0;
        double retning_magnitude = 10.0;
        try {
            if (!this.target.equals("")) {
                Enemy enemy = this.getEnemyByName(this.target);
                if (enemy == null) {
                    System.out.println("Fejl i setMoveRate");
                }
                boolean top = enemy.getCurrentPos().getY() > this.getBattleFieldHeight() / 2.0;
                boolean left = enemy.getCurrentPos().getX() < this.getBattleFieldWidth() / 2.0;
                this.desiredPos.setLocation(0.0, 0.0);
                this.desiredPos.y = top ? (this.desiredPos.y -= (double)this.distanceFromTarget) : (this.desiredPos.y += (double)this.distanceFromTarget);
                this.desiredPos.x = left ? (this.desiredPos.x += (double)this.distanceFromTarget) : (this.desiredPos.x -= (double)this.distanceFromTarget);
                double ca = Math.cos(Math.toRadians(this.posAngleOffset));
                double sa = Math.sin(Math.toRadians(this.posAngleOffset));
                double tmpX = this.desiredPos.x;
                double tmpY = this.desiredPos.y;
                this.desiredPos.setLocation(tmpX * ca - tmpY * sa, tmpX * sa + tmpY * ca);
                this.desiredPos.setLocation(this.desiredPos.x + enemy.getCurrentPos().getX(), this.desiredPos.y + enemy.getCurrentPos().getY());
                if (this.desiredPos.x < 50.0) {
                    this.desiredPos.x = 50.0;
                } else if (this.desiredPos.x > this.getBattleFieldWidth() - 50.0) {
                    this.desiredPos.x = this.getBattleFieldWidth() - 50.0;
                }
                if (this.desiredPos.y < 50.0) {
                    this.desiredPos.y = 50.0;
                } else if (this.desiredPos.y > this.getBattleFieldHeight() - 50.0) {
                    this.desiredPos.y = this.getBattleFieldHeight() - 50.0;
                }
                this.moveRetning.setLocation(this.desiredPos.getX() - this.getX(), this.desiredPos.getY() - this.getY());
                retning_magnitude = Math.sqrt(Math.pow(this.moveRetning.x, 2.0) + Math.pow(this.moveRetning.y, 2.0));
                this.moveRetning.x /= retning_magnitude;
                this.moveRetning.y /= retning_magnitude;
                double retningAngle = this.getMoveRetningAngle();
                double heading = (this.getHeading() + 90.0) * -1.0 + 180.0;
                double headingError = retningAngle - heading;
                moveError = headingError = Utils.normalRelativeAngleDegrees((double)headingError);
                this.forward = true;
                if (Math.abs(moveError) > 90.0) {
                    this.forward = !this.forward;
                    retning_magnitude *= -1.0;
                    moveError = moveError > 0.0 ? (180.0 - moveError) * -1.0 : (-180.0 - moveError) * -1.0;
                }
            } else {
                moveError = 20.0;
            }
        }
        catch (Exception e) {
            System.out.println("ERR: move()");
        }
        if (Math.abs(retning_magnitude) > 1.0) {
            this.setTurnRate(moveError * -1.0 * this.moveGain);
            this.setVelocityRate(retning_magnitude * this.VelocityGain);
        }
    }

    private void setGunRate() {
        double gunHeadingError = 0.0;
        try {
            Enemy enemy = this.getEnemyByName(this.target);
            if (enemy.getLastScanInterval() < 4L && !this.target.equals("")) {
                this.radarRetning.setLocation(enemy.getCurrentPos().x - this.getX(), enemy.getCurrentPos().y - this.getY());
                this.gunRetning.setLocation(enemy.getPredictedPos().x - this.getX(), enemy.getPredictedPos().y - this.getY());
                double retning_magnitude = Math.sqrt(Math.pow(this.gunRetning.x, 2.0) + Math.pow(this.gunRetning.y, 2.0));
                this.gunRetning.x /= retning_magnitude;
                this.gunRetning.y /= retning_magnitude;
                retning_magnitude = Math.sqrt(Math.pow(this.radarRetning.x, 2.0) + Math.pow(this.radarRetning.y, 2.0));
                this.radarRetning.x /= retning_magnitude;
                this.radarRetning.y /= retning_magnitude;
                double gunHeading = (this.getGunHeading() + 90.0) * -1.0 + 180.0;
                gunHeadingError = Utils.normalRelativeAngleDegrees((double)(gunHeading - this.getRadarRetningAngle()));
                double delta = Double.MAX_VALUE;
                double bulletSpeed = 20.0 - this.bulletPower * 3.0;
                double hit_time = this.getTime();
                double last_time = this.currentTime - 5L;
                int iterations = 0;
                while (delta > 0.01 && iterations < 100) {
                    hit_time = retning_magnitude / bulletSpeed + (double)this.currentTime;
                    Point2D.Double prediction = enemy.getVelocityVector();
                    prediction.x = prediction.x * (hit_time - (double)this.getTime()) + enemy.getCurrentPos().x;
                    prediction.y = prediction.y * (hit_time - (double)this.getTime()) + enemy.getCurrentPos().y;
                    enemy.setPredictedPos(prediction);
                    this.gunRetning.setLocation(enemy.getPredictedPos().x - this.getX(), enemy.getPredictedPos().y - this.getY());
                    retning_magnitude = Math.sqrt(Math.pow(this.gunRetning.x, 2.0) + Math.pow(this.gunRetning.y, 2.0));
                    this.gunRetning.x /= retning_magnitude;
                    this.gunRetning.y /= retning_magnitude;
                    delta = hit_time - last_time;
                    last_time = hit_time;
                    ++iterations;
                }
                this.gunRetning.setLocation(enemy.getPredictedPos().x - this.getX(), enemy.getPredictedPos().y - this.getY());
                retning_magnitude = Math.sqrt(Math.pow(this.gunRetning.x, 2.0) + Math.pow(this.gunRetning.y, 2.0));
                this.gunRetning.x /= retning_magnitude;
                this.gunRetning.y /= retning_magnitude;
                gunHeading = (this.getGunHeading() + 90.0) * -1.0 + 180.0;
                gunHeadingError = Utils.normalRelativeAngleDegrees((double)(gunHeading - this.getGunRetningAngle()));
                gunHeadingError += this.gunOffsetAngle;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setGunRotationRate(gunHeadingError * this.gunGain);
    }

    private void setRadarRate() {
        double radarError = 0.0;
        try {
            if (!this.target.equals("") && this.currentTime - this.getEnemyByName(this.target).getLastScanTime() < 60L) {
                double retningAngle = this.getRadarRetningAngle();
                double radarHeading = (this.getRadarHeading() + 90.0) * -1.0 + 180.0;
                radarError = retningAngle - radarHeading + this.radarOffset;
            } else {
                radarError = 45.0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setRadarRotationRate(radarError * -1.0 * this.radarGain);
    }

    private void updateOffset() {
        int lastScanTime = 180;
        try {
            if (!this.target.equals("")) {
                Enemy enemy = this.getEnemyByName(this.target);
                lastScanTime = (int)(this.currentTime - enemy.getLastScanTime());
            } else {
                lastScanTime = 180;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lastScanTime > 180) {
            lastScanTime = 180;
        }
        this.radarOffset = (double)lastScanTime * this.radarFan * Math.sin((double)this.currentTime * this.radarFrequency);
        this.posAngleOffset = ((double)this.positionFan - this.overTone) * Math.sin((double)this.currentTime * this.posFrequency);
        this.posAngleOffset += this.overTone * Math.sin((double)this.currentTime * this.posFrequency * 5.0);
        this.posAngleOffset *= this.retning;
        this.gunOffsetAngle = this.gunOffsetAngleAmp * Math.sin((double)(this.currentTime * 2L) * this.posFrequency);
    }

    private double getRadarRetningAngle() {
        double retningAngle = Math.toDegrees(Math.acos(this.radarRetning.x));
        if (this.radarRetning.y < 0.0) {
            retningAngle *= -1.0;
        }
        return retningAngle;
    }

    private double getGunRetningAngle() {
        double retningAngle = Math.toDegrees(Math.acos(this.gunRetning.x));
        if (this.radarRetning.y < 0.0) {
            retningAngle *= -1.0;
        }
        return retningAngle;
    }

    private double getMoveRetningAngle() {
        double retningAngle = Math.acos(this.moveRetning.x) * 360.0 / (Math.PI * 2);
        if (this.moveRetning.y < 0.0) {
            retningAngle *= -1.0;
        }
        return retningAngle;
    }

    private Enemy getEnemyByName(String name) {
        Enemy e2 = null;
        for (Enemy e2 : this.enemies) {
            if (e2.getName().equals(name)) break;
        }
        if (e2 == null && !name.equals("")) {
            System.out.println("Enemy doesn't exist!");
        }
        return e2;
    }

    private void trackEnemy(ScannedRobotEvent e) {
        if (this.target.equals("")) {
            this.target = e.getName();
            this.bulletsHit = 0;
            this.bulletsMissed = 0;
        }
        double dist = e.getDistance();
        double bearing = e.getBearing();
        Point2D.Double pos = new Point2D.Double();
        pos.x = (int)(this.getX() + Math.sin(Math.toRadians(this.getHeading() + bearing)) * dist);
        pos.y = (int)(this.getY() + Math.cos(Math.toRadians(this.getHeading() + bearing)) * dist);
        Enemy enemy = this.getEnemyByName(e.getName());
        enemy.setCurrentPos(pos);
        enemy.setVelocity(e.getVelocity());
        enemy.setHeading(e.getHeading());
        enemy.setBearing(e.getBearing());
        enemy.setLastScanTime(this.currentTime);
        enemy.setDist(dist);
        double energyDrop = e.getEnergy() - enemy.getEnergy();
        enemy.setEnergy(e.getEnergy());
        if (enemy.getName().equals(e.getName()) && energyDrop < -1.0 && Math.random() > 0.4) {
            this.retning *= -1.0;
        }
        Point2D.Double prediction = enemy.getDirectionVector();
        prediction.x = prediction.x * Math.abs(enemy.getVelocity()) * (20.0 - 3.0 * this.bulletPower) * (double)this.scale + enemy.getCurrentPos().x;
        prediction.y = prediction.y * Math.abs(enemy.getVelocity()) * (20.0 - 3.0 * this.bulletPower) * (double)this.scale + enemy.getCurrentPos().y;
        enemy.setPredictedPos(prediction);
    }

    private void removeEnemy(String name) {
        Iterator<Enemy> iterator = this.enemies.iterator();
        while (iterator.hasNext()) {
            Enemy e = iterator.next();
            if (e.getName() != name) continue;
            iterator.remove();
            System.out.println("Remaining enemies: " + this.enemies.size());
        }
    }

    private void addEnemy(ScannedRobotEvent e) {
        Enemy newEnemy = new Enemy(e.getName());
        this.enemies.add(newEnemy);
        System.out.println("Enemy added: " + newEnemy.getName());
        System.out.println("Remaining enemies: " + this.enemies.size());
    }

    private boolean enemyKnown(String name) {
        boolean known = false;
        for (Enemy e : this.enemies) {
            if (e.getName() != name) continue;
            known = true;
            break;
        }
        return known;
    }

    public void onPaint(Graphics2D g) {
        Enemy e2;
        g.setColor(Color.RED);
        for (Enemy e2 : this.enemies) {
            g.setColor(Color.WHITE);
            g.drawRect((int)e2.getCurrentPos().x - 6, (int)e2.getCurrentPos().y - 6, 12, 12);
            g.drawLine((int)e2.getLastPos().x, (int)e2.getLastPos().y, (int)e2.getCurrentPos().x, (int)e2.getCurrentPos().y);
            g.setColor(Color.RED);
            g.drawRect((int)e2.getLastPos().x - 5, (int)e2.getLastPos().y - 5, 10, 10);
            g.setColor(Color.BLUE);
            g.drawRect((int)e2.getPredictedPos().x - 7, (int)e2.getPredictedPos().y - 7, 14, 14);
        }
        g.drawString("Confidence: " + this.confidence, 10, 40);
        g.drawString("Retning: " + this.retning, 10, 60);
        g.setColor(Color.GREEN);
        g.setStroke(new BasicStroke(2.0f));
        g.drawArc((int)this.desiredPos.getX() - 5, (int)this.desiredPos.getY() - 5, 10, 10, 0, 360);
        g.setStroke(new BasicStroke(3.0f));
        g.drawLine((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.radarRetning.x * 30.0), (int)(this.getY() + this.radarRetning.y * 30.0));
        g.setColor(Color.BLUE);
        e2 = this.getEnemyByName(this.target);
        g.drawLine((int)this.getX(), (int)this.getY(), (int)e2.getPredictedPos().getX(), (int)e2.getPredictedPos().getY());
        g.drawLine((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.gunRetning.x * 30.0), (int)(this.getY() + this.gunRetning.y * 30.0));
        g.setColor(Color.WHITE);
        g.drawLine((int)this.getX(), (int)this.getY(), (int)(this.getX() + this.moveRetning.x * 50.0), (int)(this.getY() + this.moveRetning.y * 50.0));
        double heading = (this.getHeading() + 90.0) * -1.0 + 180.0;
        Point2D.Double dir = new Point2D.Double(Math.cos(Math.toRadians(heading)), Math.sin(Math.toRadians(heading)));
        g.setColor(Color.YELLOW);
        g.drawLine((int)this.getX(), (int)this.getY(), (int)(this.getX() + dir.x * 50.0), (int)(this.getY() + dir.y * 50.0));
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (!this.enemyKnown(e.getName())) {
            this.addEnemy(e);
        }
        this.trackEnemy(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.target = e.getName();
        this.bulletsHit = 0;
        this.bulletsMissed = 0;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName().equals(this.target)) {
            this.target = "";
        }
        this.removeEnemy(e.getName());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.target.equals("")) {
            this.target = e.getName();
            this.bulletsHit = 0;
            this.bulletsMissed = 0;
        }
        Enemy enemy = this.getEnemyByName(e.getName());
        enemy.setHitDamage(enemy.getHitDamage() + e.getPower() * 4.0);
    }

    public void onHitWall(HitWallEvent e) {
        System.out.println("Oops, I hit a wall. How did that happen?");
    }

    public void onBulletHit(BulletHitEvent e) {
        if (e.getName().equals(this.target)) {
            ++this.bulletsHit;
        } else {
            ++this.bulletsMissed;
        }
        this.confidence = (double)this.bulletsHit / (double)(this.bulletsMissed + this.bulletsHit + 1);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        ++this.bulletsMissed;
        this.confidence = (double)this.bulletsHit / (double)(this.bulletsMissed + this.bulletsHit + 1);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        ++this.bulletsMissed;
        this.confidence = (double)this.bulletsHit / (double)(this.bulletsMissed + this.bulletsHit + 1);
    }

    public void onWin(WinEvent e) {
        int i = 0;
        while (i < 25) {
            this.roundDone = true;
            this.clearAllEvents();
            this.setGunRotationRate(15.0);
            this.setTurnRate(0.0);
            this.setRadarRotationRate(0.0);
            this.setVelocityRate(0.0);
            this.execute();
            this.execute();
            this.setGunRotationRate(-15.0);
            this.setTurnRate(0.0);
            this.setRadarRotationRate(0.0);
            this.setVelocityRate(0.0);
            this.execute();
            this.execute();
            ++i;
        }
        this.roundDone = false;
    }
}

