/*
 * Decompiled with CFR 0.152.
 */
package ustimaw;

import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.Rules;
import ustimaw.CircularTargeting;
import ustimaw.GuessFactorTargeting;
import ustimaw.Gun;
import ustimaw.HeadOnTargeting;
import ustimaw.LinearTargeting;
import ustimaw.Nightmare;
import ustimaw.Position;

class GunManager {
    private final Gun[] gun = new Gun[]{new LinearTargeting(), new CircularTargeting(), new HeadOnTargeting(), new GuessFactorTargeting()};
    private static final Data[] effectiveness = new Data[4];
    private ArrayList<Bullet> bullets = new ArrayList();
    private Nightmare nightmare;

    GunManager(Nightmare n) {
        int i = 0;
        while (i < effectiveness.length) {
            if (effectiveness[i] == null) {
                GunManager.effectiveness[i] = new Data();
            }
            ++i;
        }
        this.nightmare = n;
    }

    void update(Nightmare n) {
        this.nightmare = n;
        Gun[] gunArray = this.gun;
        int n2 = this.gun.length;
        int n3 = 0;
        while (n3 < n2) {
            Gun g = gunArray[n3];
            g.update(n);
            ++n3;
        }
        int i = 0;
        while (i < this.bullets.size()) {
            block9: {
                Bullet b = this.bullets.get(i);
                String target = b.target;
                if (n.isDead(target)) {
                    this.bullets.remove(i--);
                } else {
                    Position fp = b.position;
                    long e = n.getTime() - b.time;
                    Position ep = n.getCurrentEnemyPosition(target);
                    this.nightmare.printCircle(fp.add(Position.polar(b.getSpeed() * (double)e, b.angle)), 5, b.index == 0 ? Color.green : Color.yellow);
                    Line2D.Double l = new Line2D.Double(fp.add(Position.polar(b.getSpeed() * (double)e, b.angle)), fp.add(Position.polar(b.getSpeed() * (double)(e - 1L), b.angle)));
                    if (this.checkHit(ep, l)) {
                        effectiveness[b.index].inc(new Element(b.power, b));
                        this.bullets.remove(i);
                        --i;
                    } else {
                        String[] t;
                        String[] stringArray = t = n.getLivingOtherTeammates();
                        int n4 = t.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String string = stringArray[n5];
                            if (this.checkHit(n.nameToPosition(string), l)) {
                                this.bullets.remove(i);
                                --i;
                                break block9;
                            }
                            ++n5;
                        }
                        if (b.getSpeed() * (double)e > n.enemys.get(target).getPoint().sub(n.getPosition()).abs() + 100.0) {
                            this.bullets.remove(i);
                            --i;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private boolean checkHit(Point2D.Double p, Line2D.Double l) {
        return new Rectangle2D.Double(p.x - 18.0, p.y - 18.0, 36.0, 36.0).intersectsLine(l);
    }

    void fire(Nightmare n, double p) {
        int i = 0;
        while (i < this.gun.length) {
            this.bullets.add(new Bullet(this.nightmare, this.gun[i], p, i));
            this.gun[i].fire(n, p);
            ++i;
        }
    }

    double getAngle(double p) {
        double m = Double.NEGATIVE_INFINITY;
        int x = 0;
        int i = 0;
        while (i < effectiveness.length) {
            double e = effectiveness[i].get(this.nightmare);
            if (e > m) {
                m = e;
                x = i;
            }
            this.nightmare.out.println(String.valueOf(i) + ":" + e);
            ++i;
        }
        this.nightmare.out.println("x:" + x);
        return this.gun[x].getAngle(this.nightmare, p);
    }

    double[] getFactor(Nightmare n) {
        return new double[]{n.getCurrentEnemyPosition(n.target).distance(n.getPosition())};
    }

    class Bullet {
        Position position;
        long time;
        double power;
        double angle;
        int index;
        double distance;
        String target;
        double velocity;
        double[] factor;

        Bullet(Nightmare n, Gun g, double p, int i) {
            this.position = n.getPosition();
            this.time = n.getTime();
            this.power = p;
            this.angle = g.getAngle(n, p);
            this.index = i;
            this.distance = this.position.distance(n.enemys.get(n.target).getPoint());
            this.target = n.target;
            this.velocity = Math.abs(n.enemys.get((Object)this.target).sre.getVelocity());
            this.factor = GunManager.this.getFactor(n);
        }

        double getSpeed() {
            return Rules.getBulletSpeed((double)this.power);
        }
    }

    class Data {
        ArrayList<Element> arrayList = new ArrayList();

        Data() {
        }

        double get(Nightmare n) {
            double[] ds = GunManager.this.getFactor(n);
            double t = 0.0;
            for (Element element : this.arrayList) {
                double d = 1.0;
                int i = 0;
                while (i < element.ds.length) {
                    d += (ds[i] - element.ds[i]) * (ds[i] - element.ds[i]);
                    ++i;
                }
                t += 1.0 / d;
            }
            return t;
        }

        void inc(Element e) {
            this.arrayList.add(e);
        }
    }

    class Element {
        double weight;
        double[] ds;

        Element(double w, Bullet bullet) {
            this.weight = w;
            this.ds = bullet.factor;
            this.ds = new double[0];
        }
    }
}

