/*
 * Decompiled with CFR 0.152.
 */
package pedersen.misc;

import pedersen.core.Combatant;
import pedersen.core.Constraints;
import pedersen.core.Snapshot;
import pedersen.core.SnapshotImpl;
import pedersen.debug.Debug;
import pedersen.misc.Metrics;
import pedersen.opponent.TargetBank;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;
import robocode.AdvancedRobot;

public class Host {
    private double chassisX = 0.0;
    private double chassisY = 0.0;
    private double chassisHeading = 0.0;
    private double chassisHeadingChange = 0.0;
    private double chassisVelocity = 0.0;
    private double turretHeading = 0.0;
    private double turretHeadingChange = 0.0;
    private double scannerHeading = 0.0;
    private double scannerHeadingChange = 0.0;
    private long turn = -1L;
    private long round = 0L;
    private int activeEnemyCount = 0;
    private double gunHeat = 0.0;
    private double energy = 0.0;
    private boolean shotFired = false;
    private double firepower = 0.0;
    private double maximumVelocity = 8.0;
    private StaticPosition staleChassisPosition = null;
    private final long rounds;
    private final double gunCoolingRate;
    private final double battleFieldWidth;
    private final double battleFieldHeight;
    private final String name;
    public static Host singleton = null;

    public Host(AdvancedRobot robot) {
        this.name = robot.getName();
        this.rounds = robot.getNumRounds();
        this.gunCoolingRate = robot.getGunCoolingRate();
        this.battleFieldWidth = robot.getBattleFieldWidth();
        this.battleFieldHeight = robot.getBattleFieldHeight();
        this.initializeTurn(robot);
    }

    public void initializeTurn(AdvancedRobot robot) {
        if (this.turn != robot.getTime()) {
            this.chassisX = robot.getX();
            this.chassisY = robot.getY();
            this.chassisHeading = robot.getHeadingRadians();
            this.chassisVelocity = robot.getVelocity();
            this.turretHeading = robot.getGunHeadingRadians();
            this.scannerHeading = robot.getRadarHeadingRadians();
            this.turn = robot.getTime();
            this.round = robot.getRoundNum();
            this.activeEnemyCount = robot.getOthers();
            this.gunHeat = robot.getGunHeat();
            this.shotFired = false;
            this.energy = robot.getEnergy();
            this.chassisHeadingChange = 0.0;
            this.turretHeadingChange = 0.0;
            this.scannerHeadingChange = 0.0;
            Combatant.getCombatant().appendSnapshot(this.getSnapshot());
            if (!Constraints.isVehicularVelocityLegal(this.chassisVelocity)) {
                Debug.line("Robot.getVelocity: " + Debug.trim(this.chassisVelocity));
            }
        }
    }

    public void applyInstructions(AdvancedRobot robot) {
        this.setStaleChassisPosition(this.chassisX, this.chassisY);
        if (this.shotFired) {
            robot.setFireBullet(this.firepower);
            Metrics.shotFired(this.firepower);
            TargetBank.singleton.onDefensiveFire();
        }
        robot.setMaxVelocity(Math.abs(this.maximumVelocity));
        if (this.isDisabled()) {
            this.turretHeadingChange += this.chassisHeadingChange;
            this.scannerHeadingChange += this.chassisHeadingChange;
        }
        robot.setTurnRightRadians(Constraints.getNegativePiToPi(this.chassisHeadingChange));
        robot.setTurnGunRightRadians(Constraints.getNegativePiToPi(this.turretHeadingChange));
        robot.setTurnRadarRightRadians(Constraints.getNegativePiToPi(this.scannerHeadingChange));
        if (Constraints.isInRange(0.0, this.chassisVelocity, 2.0)) {
            if (Constraints.isInRange(-2.0, this.maximumVelocity, 0.0)) {
                double delta = this.maximumVelocity - this.chassisVelocity;
                robot.setMaxVelocity(Math.abs(delta));
                robot.setAhead(this.maximumVelocity);
            } else if (this.maximumVelocity < 0.0) {
                robot.setAhead(-64.0);
            } else {
                robot.setAhead(64.0);
            }
        } else if (Constraints.isInRange(-2.0, this.chassisVelocity, 0.0)) {
            if (Constraints.isInRange(0.0, this.maximumVelocity, 2.0)) {
                double delta = this.maximumVelocity - this.chassisVelocity;
                robot.setMaxVelocity(Math.abs(delta));
                robot.setAhead(this.maximumVelocity);
            } else if (this.maximumVelocity < 0.0) {
                robot.setAhead(-64.0);
            } else {
                robot.setAhead(64.0);
            }
        } else if (this.maximumVelocity < 0.0) {
            robot.setAhead(-64.0);
        } else {
            robot.setAhead(64.0);
        }
    }

    public boolean isDisabled() {
        return this.energy == 0.0;
    }

    public boolean isGunCool() {
        return !this.isDisabled() && this.gunHeat == 0.0;
    }

    public boolean isGunCool(long turnFired, double firepower) {
        double heat = 1.0 + firepower * 0.2;
        double cool = this.gunCoolingRate * (double)(this.turn - turnFired);
        return heat <= cool;
    }

    public boolean isFirstTurn() {
        return this.turn == 0L;
    }

    public boolean isFirstRound() {
        return this.round == 0L;
    }

    public boolean isLastRound() {
        return this.round == this.rounds - 1L;
    }

    public boolean isEveryoneDead() {
        return this.activeEnemyCount == 0;
    }

    public boolean isInDuelMode() {
        return this.activeEnemyCount == 1;
    }

    public Snapshot getSnapshot() {
        return new SnapshotImpl(this.round, this.turn, this.chassisX, this.chassisY, this.chassisHeading, this.chassisVelocity, this.energy);
    }

    public double getChassisX() {
        return this.chassisX;
    }

    public double getChassisY() {
        return this.chassisY;
    }

    public double getChassisHeading() {
        return this.chassisHeading;
    }

    public double getChassisVelocity() {
        return this.chassisVelocity;
    }

    public double getTurretHeading() {
        return this.turretHeading;
    }

    public double getScannerHeading() {
        return this.scannerHeading;
    }

    public long getTurn() {
        return this.turn;
    }

    public long getRound() {
        return this.round;
    }

    public long getRounds() {
        return this.rounds;
    }

    public double getBattleFieldWidth() {
        return this.battleFieldWidth;
    }

    public double getBattleFieldHeight() {
        return this.battleFieldHeight;
    }

    public int getActiveEnemyCount() {
        return this.activeEnemyCount;
    }

    public double getThrottleSetting() {
        return this.maximumVelocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getGunHeat() {
        return this.gunHeat;
    }

    public String getName() {
        return this.name;
    }

    public void fireGun(double newFirepower) {
        this.shotFired = true;
        this.firepower = newFirepower;
    }

    public void setThrottle(double newMaxVelocity) {
        this.maximumVelocity = newMaxVelocity;
    }

    public void turnChassis(double delta) {
        this.chassisHeadingChange = delta;
    }

    public void turnTurret(double delta) {
        this.turretHeadingChange = delta;
    }

    public void turnScanner(double delta) {
        this.scannerHeadingChange = delta;
    }

    private void setStaleChassisPosition(double x, double y) {
        this.staleChassisPosition = new StaticPositionImpl(x, y);
    }

    public StaticPosition getStaleChassisPosition() {
        return this.staleChassisPosition;
    }
}

